/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.CallStatusChangedListener;
import com.skype.SkypeException;
import com.skype.SkypeExceptionHandler;
import com.skype.SkypeObject;
import com.skype.User;
import com.skype.Utils;
import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Call
extends SkypeObject {
    private static final Map<String, Call> calls = new HashMap<String, Call>();
    private final String id;
    private final List<CallStatusChangedListener> listeners = Collections.synchronizedList(new ArrayList());
    private Status oldStatus;
    private SkypeExceptionHandler exceptionHandler;
    private boolean isCallListenerEventFired;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Call getInstance(String id) {
        Map<String, Call> map = calls;
        synchronized (map) {
            if (!calls.containsKey(id)) {
                calls.put(id, new Call(id));
            }
            return calls.get(id);
        }
    }

    private Call(String newId) {
        this.id = newId;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object compared) {
        if (compared instanceof Call) {
            return this.id.equals(((Call)compared).id);
        }
        return false;
    }

    public String getId() {
        return this.id;
    }

    public void addCallStatusChangedListener(CallStatusChangedListener listener) {
        Utils.checkNotNull("listener", listener);
        this.listeners.add(listener);
    }

    public void removeCallStatusChangedListener(CallStatusChangedListener listener) {
        Utils.checkNotNull("listener", listener);
        this.listeners.remove(listener);
    }

    void fireStatusChanged(Status status) {
        CallStatusChangedListener[] listeners = this.listeners.toArray(new CallStatusChangedListener[0]);
        if (status == this.oldStatus) {
            return;
        }
        this.oldStatus = status;
        for (CallStatusChangedListener listener : listeners) {
            try {
                listener.statusChanged(status);
            }
            catch (Throwable e) {
                Utils.handleUncaughtException(e, this.exceptionHandler);
            }
        }
    }

    public void hold() throws SkypeException {
        this.setStatus("ONHOLD");
    }

    public void resume() throws SkypeException {
        this.setStatus("INPROGRESS");
    }

    public void finish() throws SkypeException {
        this.setStatus("FINISHED");
    }

    public void answer() throws SkypeException {
        this.setStatus("INPROGRESS");
    }

    public void cancel() throws SkypeException {
        this.setStatus("FINISHED");
    }

    private void setStatus(String status) throws SkypeException {
        try {
            String response = Connector.getInstance().executeWithId("SET CALL " + this.getId() + " STATUS " + status, "CALL " + this.getId() + " STATUS ");
            Utils.checkError(response);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    public void forward() throws SkypeException {
        Utils.executeWithErrorCheck("ALTER CALL " + this.getId() + " END FORWARD_CALL");
    }

    public void redirectToVoiceMail() throws SkypeException {
        Utils.executeWithErrorCheck("ALTER CALL " + this.getId() + " END FORWARD_CALL");
    }

    public void send(DTMF command) throws SkypeException {
        Utils.executeWithErrorCheck("SET CALL " + this.getId() + " DTMF " + command.getType());
    }

    public Date getStartTime() throws SkypeException {
        return Utils.parseUnixTime(this.getProperty("TIMESTAMP"));
    }

    public User getPartner() throws SkypeException {
        return User.getInstance(this.getPartnerId());
    }

    public String getPartnerId() throws SkypeException {
        return this.getProperty("PARTNER_HANDLE");
    }

    public String getPartnerDisplayName() throws SkypeException {
        return this.getProperty("PARTNER_DISPNAME");
    }

    public Type getType() throws SkypeException {
        return Type.valueOf(this.getProperty("TYPE"));
    }

    public Status getStatus() throws SkypeException {
        return Status.valueOf(Utils.getPropertyWithCommandId("CALL", this.getId(), "STATUS"));
    }

    public int getDuration() throws SkypeException {
        return Integer.parseInt(this.getProperty("DURATION"));
    }

    public int getErrorCode() throws SkypeException {
        return Integer.parseInt(this.getProperty("FAILUREREASON"));
    }

    public void setReceiveVideoEnabled(boolean videoStatus) throws SkypeException {
        String value = videoStatus ? "START_VIDEO_SEND" : "STOP_VIDEO_SEND";
        try {
            String response = Connector.getInstance().execute("ALTER CALL " + this.getId() + " " + value);
            Utils.checkError(response);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    public boolean isReceiveVideoEnabled() throws SkypeException {
        VideoEnabledStatus enabled = VideoEnabledStatus.valueOf(this.getProperty("VIDEO_STATUS"));
        switch (enabled) {
            case VIDEO_NONE: 
            case VIDEO_SEND_ENABLED: {
                return false;
            }
            case VIDEO_RECV_ENABLED: 
            case VIDEO_BOTH_ENABLED: {
                return true;
            }
        }
        return false;
    }

    public void setSendVideoEnabled(boolean videoStatus) throws SkypeException {
        String value = videoStatus ? "START_VIDEO_RECEIVE" : "STOP_VIDEO_RECEIVE";
        try {
            String response = Connector.getInstance().execute("ALTER CALL " + this.getId() + " " + value);
            Utils.checkError(response);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    public boolean isSendVideoEnabled() throws SkypeException {
        VideoEnabledStatus enabled = VideoEnabledStatus.valueOf(this.getProperty("VIDEO_STATUS"));
        switch (enabled) {
            case VIDEO_NONE: 
            case VIDEO_RECV_ENABLED: {
                return false;
            }
            case VIDEO_SEND_ENABLED: 
            case VIDEO_BOTH_ENABLED: {
                return true;
            }
        }
        return false;
    }

    public VideoStatus getReceiveVideoStatus() throws SkypeException {
        return VideoStatus.valueOf(this.getProperty("VIDEO_RECEIVE_STATUS"));
    }

    public VideoStatus getSendVideoStatus() throws SkypeException {
        return VideoStatus.valueOf(this.getProperty("VIDEO_SEND_STATUS"));
    }

    public String getConferenceId() throws SkypeException {
        return this.getProperty("CONF_ID");
    }

    public String getParticipantsCount() throws SkypeException {
        return this.getProperty("CONF_PARTICIPANTS_COUNT");
    }

    private String getProperty(String name) throws SkypeException {
        return Utils.getProperty("CALL", this.getId(), name);
    }

    boolean isCallListenerEventFired() {
        return this.isCallListenerEventFired;
    }

    void setCallListenerEventFired(boolean fired) {
        this.isCallListenerEventFired = fired;
    }

    public void setFileInput(File file) throws SkypeException {
        if (file == null) {
            this.clearFileInput();
            return;
        }
        Map<String, String> inputStreams = this.getInputStreams();
        inputStreams.put("FILE", file.getAbsolutePath());
        this.setInputStreams(inputStreams);
    }

    public void clearFileInput() throws SkypeException {
        Map<String, String> inputStreams = this.getInputStreams();
        inputStreams.remove("FILE");
        this.setInputStreams(inputStreams);
    }

    public void setFileOutput(File file) throws SkypeException {
        if (file == null) {
            this.clearFileOutput();
            return;
        }
        Map<String, String> outputStreams = this.getOutputStreams();
        outputStreams.put("FILE", file.getAbsolutePath());
        this.setOutputStreams(outputStreams);
    }

    public void clearFileOutput() throws SkypeException {
        Map<String, String> outputStreams = this.getOutputStreams();
        outputStreams.remove("FILE");
        this.setOutputStreams(outputStreams);
    }

    public void setFileCaptureMic(File file) throws SkypeException {
        if (file == null) {
            this.clearFileCaptureMic();
            return;
        }
        Map<String, String> captureMicStreams = this.getCaptureMicStreams();
        captureMicStreams.put("FILE", file.getAbsolutePath());
        this.setCaptureMicStreams(captureMicStreams);
    }

    public void clearFileCaptureMic() throws SkypeException {
        Map<String, String> inputStreams = this.getCaptureMicStreams();
        inputStreams.remove("FILE");
        this.setCaptureMicStreams(inputStreams);
    }

    public void setPortInput(int port) throws SkypeException {
        if (port <= 0) {
            this.clearPortInput();
            return;
        }
        Map<String, String> inputStreams = this.getInputStreams();
        inputStreams.put("PORT", "" + port);
        this.setInputStreams(inputStreams);
    }

    public void clearPortInput() throws SkypeException {
        Map<String, String> inputStreams = this.getInputStreams();
        inputStreams.remove("PORT");
        this.setInputStreams(inputStreams);
    }

    public void setPortOutput(int port) throws SkypeException {
        if (port <= 0) {
            this.clearPortOutput();
            return;
        }
        Map<String, String> outputStreams = this.getOutputStreams();
        outputStreams.put("PORT", "" + port);
        this.setOutputStreams(outputStreams);
    }

    public void clearPortOutput() throws SkypeException {
        Map<String, String> outputStreams = this.getOutputStreams();
        outputStreams.remove("PORT");
        this.setOutputStreams(outputStreams);
    }

    public void setPortCaptureMic(int port) throws SkypeException {
        if (port <= 0) {
            this.clearPortCaptureMic();
            return;
        }
        Map<String, String> captureMicStreams = this.getCaptureMicStreams();
        captureMicStreams.put("PORT", "" + port);
        this.setCaptureMicStreams(captureMicStreams);
    }

    public void clearPortCaptureMic() throws SkypeException {
        Map<String, String> captureMicStreams = this.getCaptureMicStreams();
        captureMicStreams.remove("PORT");
        this.setCaptureMicStreams(captureMicStreams);
    }

    private Map<String, String> getInputStreams() throws SkypeException {
        return this.getStreams("INPUT");
    }

    private Map<String, String> getOutputStreams() throws SkypeException {
        return this.getStreams("OUTPUT");
    }

    private Map<String, String> getCaptureMicStreams() throws SkypeException {
        return this.getStreams("CAPTURE_MIC");
    }

    private Map<String, String> getStreams(String type) throws SkypeException {
        String response = Utils.getProperty("CALL", this.getId(), type);
        Utils.checkError(response);
        if ("".equals(response)) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> r = new HashMap<String, String>();
        for (String element : response.split(", ")) {
            int index = element.indexOf(61);
            String key = element.substring(0, index);
            String value = element.substring(index + 2, element.length() - 1);
            r.put(key, value);
        }
        return r;
    }

    private void setInputStreams(Map<String, String> inputStreams) throws SkypeException {
        this.setStreams("INPUT", inputStreams);
    }

    private void setOutputStreams(Map<String, String> outputStreams) throws SkypeException {
        this.setStreams("OUTPUT", outputStreams);
    }

    private void setCaptureMicStreams(Map<String, String> captureMicStreams) throws SkypeException {
        this.setStreams("CAPTURE_MIC", captureMicStreams);
    }

    private void setStreams(String type, Map<String, String> streams) throws SkypeException {
        try {
            StringBuilder parameters = new StringBuilder();
            for (String key : streams.keySet()) {
                parameters.append(" ");
                parameters.append(key);
                parameters.append("=\"");
                parameters.append(streams.get(key));
                parameters.append("\"");
            }
            String response = Connector.getInstance().execute("ALTER CALL " + this.getId() + " SET_" + type + parameters);
            Utils.checkError(response);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    public boolean canTransferTo(String skypeId) throws SkypeException {
        try {
            String command = "GET CALL " + this.getId() + " CAN_TRANSFER " + skypeId;
            String responseHeader = "CALL " + this.getId() + " CAN_TRANSFER " + skypeId + " ";
            String response = Connector.getInstance().execute(command, responseHeader);
            Utils.checkError(response);
            return Boolean.parseBoolean(response.substring(responseHeader.length()));
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return false;
        }
    }

    public void transferTo(String ... skypeIds) throws SkypeException {
        Utils.checkNotNull("skypeIds", skypeIds);
        try {
            String response = Connector.getInstance().execute("ALTER CALL " + this.getId() + " TRANSFER \"" + Utils.convertToCommaSeparatedString(skypeIds) + "\"");
            Utils.checkError(response);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    private static enum VideoEnabledStatus {
        VIDEO_NONE,
        VIDEO_SEND_ENABLED,
        VIDEO_RECV_ENABLED,
        VIDEO_BOTH_ENABLED;

    }

    public static enum DTMF {
        TYPE_0,
        TYPE_1,
        TYPE_2,
        TYPE_3,
        TYPE_4,
        TYPE_5,
        TYPE_6,
        TYPE_7,
        TYPE_8,
        TYPE_9,
        TYPE_SHARP('#'),
        TYPE_ASTERISK('*');

        private final char type;

        private DTMF() {
            this.type = this.name().charAt("TYPE_".length());
        }

        private DTMF(char type) {
            this.type = type;
        }

        char getType() {
            return this.type;
        }
    }

    public static enum VideoStatus {
        NOT_AVAILABLE,
        AVAILABLE,
        STARTING,
        REJECTED,
        RUNNING,
        STOPPING,
        PAUSED;

    }

    public static enum Type {
        INCOMING_PSTN,
        OUTGOING_PSTN,
        INCOMING_P2P,
        OUTGOING_P2P;

    }

    public static enum Status {
        UNPLACED,
        ROUTING,
        EARLYMEDIA,
        FAILED,
        RINGING,
        INPROGRESS,
        ONHOLD,
        FINISHED,
        MISSED,
        REFUSED,
        BUSY,
        CANCELLED,
        VM_BUFFERING_GREETING,
        VM_PLAYING_GREETING,
        VM_RECORDING,
        VM_UPLOADING,
        VM_SENT,
        VM_CANCELLED,
        VM_FAILED,
        TRANSFERRING,
        TRANSFERRED,
        LOCALHOLD,
        REMOTEHOLD,
        WAITING_REDIAL_COMMAND,
        REDIAL_PENDING;

    }
}

