/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.Chat;
import com.skype.ChatMessage;
import com.skype.ChatMessageListener;
import com.skype.GlobalChatListener;
import com.skype.SkypeException;
import com.skype.User;
import java.util.ArrayList;
import java.util.List;

public class ChatListenerMananager
implements ChatMessageListener {
    private List<GlobalChatListener> listeners = new ArrayList<GlobalChatListener>();

    @Override
    public void chatMessageReceived(ChatMessage chatMessage) throws SkypeException {
        this.determineChatEvent(chatMessage);
    }

    @Override
    public void chatMessageSent(ChatMessage chatMessage) throws SkypeException {
        this.determineChatEvent(chatMessage);
    }

    private synchronized void determineChatEvent(ChatMessage chatMessage) throws SkypeException {
        Chat chat = chatMessage.getChat();
        ChatMessage.Type type = chatMessage.getType();
        switch (type) {
            case ADDEDMEMBERS: {
                User[] addedUsers;
                for (User user : addedUsers = chatMessage.getAllUsers()) {
                    this.fireChatUserAdded(chat, user);
                }
                break;
            }
            case LEFT: {
                ChatMessage.LeaveReason leaveReason = chatMessage.getLeaveReason();
                if (!leaveReason.equals((Object)ChatMessage.LeaveReason.UNSUBSCRIBE)) break;
                User user = chatMessage.getSender();
                this.fireChatUserLeft(chat, user);
                break;
            }
        }
    }

    private void fireChatUserAdded(Chat chat, User user) {
        for (GlobalChatListener listener : this.listeners) {
            listener.userAdded(chat, user);
        }
    }

    private void fireChatUserLeft(Chat chat, User user) {
        for (GlobalChatListener listener : this.listeners) {
            listener.userLeft(chat, user);
        }
    }

    void addGlobalChatListener(GlobalChatListener listener) {
        this.listeners.add(listener);
    }

    void removeListener(GlobalChatListener listener) {
        this.listeners.remove(listener);
    }
}

