/*
 * Decompiled with CFR 0.152.
 */
package com.skype.connector.win32;

import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import com.skype.connector.ConnectorUtils;
import com.skype.connector.LoadLibraryException;

public class Win32Connector
extends Connector {
    private static final int ATTACH_SUCCESS = 0;
    private static final int ATTACH_PENDING_AUTHORIZATION = 1;
    private static final int ATTACH_REFUSED = 2;
    private static final int ATTACH_NOT_AVAILABLE = 3;
    private static final int ATTACH_API_AVAILABLE = 32769;
    private static final String LIB_FILENAME_FORMAT = "skype_%s.dll";
    private static Win32Connector instance = null;
    private Thread eventDispatcher = null;

    public static synchronized Connector getInstance() {
        if (instance == null) {
            instance = new Win32Connector();
            try {
                instance.initialize();
            }
            catch (ConnectorException e) {
                throw new IllegalStateException(e);
            }
        }
        return instance;
    }

    protected Win32Connector() {
    }

    @Override
    public String getInstalledPath() {
        return this.jni_getInstalledPath();
    }

    @Override
    protected void initializeImpl() {
        String osArch = System.getProperty("os.arch");
        String libfilename = String.format(LIB_FILENAME_FORMAT, osArch);
        try {
            ConnectorUtils.loadLibrary(libfilename);
        }
        catch (LoadLibraryException e) {
            throw new IllegalStateException("It was impossible to load " + libfilename + " dll.", e);
        }
        this.jni_init();
        this.eventDispatcher = new Thread(new Runnable(){

            @Override
            public void run() {
                Win32Connector.this.jni_windowProc();
            }
        }, "SkypeBridge WindowProc Thread");
        this.eventDispatcher.setDaemon(true);
        this.eventDispatcher.start();
    }

    @Override
    protected Connector.Status connect(int timeout) throws ConnectorException {
        try {
            int retries = 3;
            while (true) {
                Connector.Status status;
                this.jni_connect();
                long start = System.currentTimeMillis();
                if ((long)timeout <= System.currentTimeMillis() - start) {
                    this.setStatus(Connector.Status.NOT_RUNNING);
                }
                if ((status = this.getStatus()) != Connector.Status.PENDING_AUTHORIZATION && status != Connector.Status.NOT_RUNNING) {
                    return status;
                }
                if (retries <= 0) {
                    return Connector.Status.NOT_RUNNING;
                }
                --retries;
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            throw new ConnectorException("Trying to connect was interrupted.", e);
        }
    }

    @Override
    protected void sendApplicationName(String applicationName) throws ConnectorException {
        String command = "NAME " + applicationName;
        this.execute(command, new String[]{command}, false);
    }

    public void jni_onAttach(int status) {
        switch (status) {
            case 1: {
                this.setStatus(Connector.Status.PENDING_AUTHORIZATION);
                break;
            }
            case 0: {
                this.setStatus(Connector.Status.ATTACHED);
                break;
            }
            case 2: {
                this.setStatus(Connector.Status.REFUSED);
                break;
            }
            case 3: {
                this.setStatus(Connector.Status.NOT_AVAILABLE);
                break;
            }
            case 32769: {
                this.setStatus(Connector.Status.API_AVAILABLE);
                break;
            }
            default: {
                this.setStatus(Connector.Status.NOT_RUNNING);
            }
        }
    }

    public void jni_onSkypeMessage(String message) {
        this.fireMessageReceived(message);
    }

    @Override
    protected void disposeImpl() {
        throw new UnsupportedOperationException("WindowsConnector#disposeImpl() is not implemented yet.");
    }

    @Override
    protected void sendCommand(String command) {
        this.jni_sendMessage(command);
    }

    private native void jni_init();

    private native void jni_windowProc();

    private native void jni_sendMessage(String var1);

    private native void jni_connect();

    private native String jni_getInstalledPath();
}

