/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.Chat;
import com.skype.SkypeException;
import com.skype.SkypeObject;
import com.skype.User;
import com.skype.Utils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public final class ChatMessage
extends SkypeObject {
    private static final Map<String, ChatMessage> chatMessages = new HashMap<String, ChatMessage>();
    private final String id;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ChatMessage getInstance(String id) {
        Map<String, ChatMessage> map = chatMessages;
        synchronized (map) {
            if (!chatMessages.containsKey(id)) {
                chatMessages.put(id, new ChatMessage(id));
            }
            return chatMessages.get(id);
        }
    }

    private ChatMessage(String newId) {
        this.id = newId;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object compared) {
        if (compared instanceof ChatMessage) {
            ChatMessage comparedChatMessage = (ChatMessage)compared;
            return this.getId().equals(comparedChatMessage.getId());
        }
        return false;
    }

    public String getId() {
        return this.id;
    }

    public Date getTime() throws SkypeException {
        return Utils.parseUnixTime(this.getProperty("TIMESTAMP"));
    }

    public User getSender() throws SkypeException {
        return User.getInstance(this.getSenderId());
    }

    public String getSenderId() throws SkypeException {
        return this.getProperty("FROM_HANDLE");
    }

    public String getSenderDisplayName() throws SkypeException {
        return this.getProperty("FROM_DISPNAME");
    }

    public Type getType() throws SkypeException {
        return Type.valueOf(this.getProperty("TYPE"));
    }

    public Status getStatus() throws SkypeException {
        return Status.valueOf(Utils.getPropertyWithCommandId("CHATMESSAGE", this.getId(), "STATUS"));
    }

    public LeaveReason getLeaveReason() throws SkypeException {
        return LeaveReason.valueOf(this.getProperty("LEAVEREASON"));
    }

    public String getContent() throws SkypeException {
        return this.getProperty("BODY");
    }

    public void setContent(String content) throws SkypeException {
        this.setProperty("BODY", content);
    }

    public void setSeen() throws SkypeException {
        Utils.setProperty("CHATMESSAGE", this.getId(), "SEEN", "", "CHATMESSAGE " + this.getId() + " STATUS READ");
    }

    public boolean isEditable() throws SkypeException {
        return Boolean.parseBoolean(this.getProperty("IS_EDITABLE"));
    }

    public Chat getChat() throws SkypeException {
        return Chat.getInstance(this.getProperty("CHATNAME"));
    }

    public User[] getAllUsers() throws SkypeException {
        String value = this.getProperty("USERS");
        if ("".equals(value)) {
            return new User[0];
        }
        String[] ids = value.split(" ");
        User[] users = new User[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            users[i] = User.getInstance(ids[i]);
        }
        return users;
    }

    private String getProperty(String name) throws SkypeException {
        return Utils.getProperty("CHATMESSAGE", this.getId(), name);
    }

    private void setProperty(String name, String value) throws SkypeException {
        Utils.setProperty("CHATMESSAGE", this.getId(), name, value);
    }

    public static enum LeaveReason {
        USER_NOT_FOUND,
        USER_INCAPABLE,
        ADDER_MUST_BE_FRIEND,
        ADDED_MUST_BE_AUTHORIZED,
        UNSUBSCRIBE;

    }

    public static enum Status {
        SENDING,
        SENT,
        RECEIVED,
        READ;

    }

    public static enum Type {
        SETTOPIC,
        SAID,
        ADDEDMEMBERS,
        SAWMEMBERS,
        CREATEDCHATWITH,
        LEFT,
        POSTEDCONTACTS,
        GAP_IN_CHAT,
        SETROLE,
        KICKED,
        KICKBANNED,
        SETOPTIONS,
        SETPICTURE,
        SETGUIDELINES,
        JOINEDASAPPLICANT,
        EMOTED,
        UNKNOWN;

    }
}

