/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.ChatMessage;
import com.skype.ChatMessageListener;
import com.skype.Skype;
import com.skype.connector.AbstractConnectorListener;
import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import com.skype.connector.ConnectorMessageEvent;
import java.util.HashSet;
import java.util.Set;

final class ChatMessageConnectorListener
extends AbstractConnectorListener {
    private static final String CHAT_API_MSG = "CHAT ";
    private static final String ACTIVITY_TIMESTAMP_MSG = "ACTIVITY_TIMESTAMP";
    private static final String CHATMESSAGE_API_MSG = "CHATMESSAGE ";
    private static final String READ_MESSAGE_SUFFIX = "READ";
    private static final String RECEIVED_MESSAGE_SUFFIX = "RECEIVED";
    private static final String SENT_MESSAGE_SUFFIX = "SENT";
    private final Object _isReceivedMutex = new Object();
    private Set<Integer> lastReceivedIds = new HashSet<Integer>();
    private Integer currentReceivedId;

    ChatMessageConnectorListener() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageReceived(ConnectorMessageEvent event) {
        String message = event.getMessage();
        if (message.startsWith(CHATMESSAGE_API_MSG)) {
            String data = message.substring(CHATMESSAGE_API_MSG.length());
            String id = data.substring(0, data.indexOf(32));
            String propertyNameAndValue = data.substring(data.indexOf(32) + 1);
            String propertyName = propertyNameAndValue.substring(0, propertyNameAndValue.indexOf(32));
            if ("STATUS".equals(propertyName)) {
                String propertyValue = propertyNameAndValue.substring(propertyNameAndValue.indexOf(32) + 1);
                try {
                    this.currentReceivedId = Integer.parseInt(id);
                }
                catch (NumberFormatException ex) {
                    return;
                }
                ChatMessageListener[] listeners = Skype.chatMessageListeners.toArray(new ChatMessageListener[0]);
                ChatMessage chatMessage = ChatMessage.getInstance(this.currentReceivedId.toString());
                if (SENT_MESSAGE_SUFFIX.equals(propertyValue)) {
                    this.fireMessageSent(listeners, chatMessage);
                } else if (RECEIVED_MESSAGE_SUFFIX.equals(propertyValue)) {
                    Object object = this._isReceivedMutex;
                    synchronized (object) {
                        if (this.lastReceivedIds.contains(this.currentReceivedId)) {
                            return;
                        }
                        this.lastReceivedIds.add(this.currentReceivedId);
                        this._isReceivedMutex.notifyAll();
                    }
                    this.fireMessageReceived(listeners, chatMessage);
                }
            }
        } else if (message.startsWith(CHAT_API_MSG) && message.contains(ACTIVITY_TIMESTAMP_MSG)) {
            try {
                Connector.getInstance().getMissedMessages();
            }
            catch (ConnectorException ex) {
                System.out.println(ex);
            }
        }
    }

    private void fireMessageSent(ChatMessageListener[] listeners, ChatMessage chatMessage) {
        for (ChatMessageListener listener : listeners) {
            try {
                listener.chatMessageSent(chatMessage);
            }
            catch (Throwable e) {
                Skype.handleUncaughtException(e);
            }
        }
    }

    private void fireMessageReceived(ChatMessageListener[] listeners, ChatMessage chatMessage) {
        for (ChatMessageListener listener : listeners) {
            try {
                listener.chatMessageReceived(chatMessage);
            }
            catch (Throwable e) {
                Skype.handleUncaughtException(e);
            }
        }
    }
}

