/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.ChatMessage;
import com.skype.ChatMessageEditListener;
import com.skype.User;
import com.skype.connector.AbstractConnectorListener;
import com.skype.connector.ConnectorMessageEvent;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class ChatMessageEditConnectorListener
extends AbstractConnectorListener {
    final List<ChatMessageEditListener> listeners = new CopyOnWriteArrayList<ChatMessageEditListener>();
    Map<ChatMessage, EditData> edits = new LinkedHashMap<ChatMessage, EditData>();

    public void addListener(ChatMessageEditListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ChatMessageEditListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void messageReceived(ConnectorMessageEvent event) {
        String message = event.getMessage();
        this.processMessage(message);
    }

    synchronized void processMessage(String message) {
        String cmd = "CHATMESSAGE ";
        if (!message.startsWith(cmd)) {
            return;
        }
        String remain = message.substring(cmd.length());
        String messageId = remain.substring(0, remain.indexOf(" "));
        ChatMessage chatMessage = ChatMessage.getInstance(messageId);
        remain = remain.substring(messageId.length() + 1);
        String chatEvent = remain.substring(0, remain.indexOf(" "));
        String parameter = remain.substring(chatEvent.length() + 1);
        if (chatEvent.equals("EDITED_TIMESTAMP")) {
            this.processTimeStamp(chatMessage, parameter);
            return;
        }
        if (chatEvent.equals("EDITED_BY")) {
            this.processAuthor(chatMessage, parameter);
            return;
        }
        if (chatEvent.equals("BODY")) {
            this.processBody(chatMessage, parameter);
        }
    }

    private void processTimeStamp(ChatMessage chatMessage, String parameter) {
        EditData editData = this.getEditData(chatMessage);
        editData.eventDate = new Date(Integer.parseInt(parameter));
        this.edits.put(chatMessage, editData);
    }

    private void processAuthor(ChatMessage chatMessage, String parameter) {
        EditData editData = this.getEditData(chatMessage);
        editData.author = User.getInstance(parameter);
    }

    private EditData getEditData(ChatMessage chatMessage) {
        EditData editData = this.edits.get(chatMessage);
        if (editData == null) {
            editData = new EditData();
            this.edits.put(chatMessage, editData);
        }
        return editData;
    }

    private void processBody(ChatMessage chatMessage, String parameter) {
        this.fireEdit(chatMessage);
    }

    private void fireEdit(ChatMessage chatMessage) {
        EditData editData = this.edits.get(chatMessage);
        if (editData == null) {
            return;
        }
        for (ChatMessageEditListener l : this.listeners) {
            l.chatMessageEdited(chatMessage, editData.eventDate, editData.author);
        }
        this.edits.remove(chatMessage);
    }

    class EditData {
        private Date eventDate;
        private User author;

        EditData() {
        }
    }
}

