/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.FileTransferListener;
import com.skype.SkypeException;
import com.skype.SkypeExceptionHandler;
import com.skype.SkypeObject;
import com.skype.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class FileTransfer
extends SkypeObject {
    private static final Map<String, FileTransfer> files = new HashMap<String, FileTransfer>();
    private final String id;
    private final List<FileTransferListener> listeners = Collections.synchronizedList(new ArrayList());
    private Status oldStatus;
    private SkypeExceptionHandler exceptionHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FileTransfer getInstance(String id) {
        Map<String, FileTransfer> map = files;
        synchronized (map) {
            if (!files.containsKey(id)) {
                FileTransfer file = new FileTransfer(id);
                files.put(id, file);
            }
            return files.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FileTransfer getInstance(String id, FileTransferListener fileTransferListener) {
        Map<String, FileTransfer> map = files;
        synchronized (map) {
            if (!files.containsKey(id)) {
                files.put(id, new FileTransfer(id, fileTransferListener));
            }
            return files.get(id);
        }
    }

    private FileTransfer(String newId) {
        assert (newId != null);
        this.id = newId;
    }

    private FileTransfer(String newId, FileTransferListener fileTransferListener) {
        assert (newId != null);
        this.id = newId;
        this.addFileTransferListener(fileTransferListener);
    }

    public final int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object compared) {
        if (compared instanceof FileTransfer) {
            return this.getId().equals(((FileTransfer)compared).getId());
        }
        return false;
    }

    public String getId() {
        return this.id;
    }

    public void addFileTransferListener(FileTransferListener fileTransferListener) {
        Utils.checkNotNull("listener", fileTransferListener);
        this.listeners.add(fileTransferListener);
    }

    public void removeCallMonitorListener(FileTransferListener fileTransferListener) {
        Utils.checkNotNull("listener", fileTransferListener);
        this.listeners.remove(fileTransferListener);
    }

    void fireFileTransfer(Status status) {
        if (status == this.oldStatus) {
            return;
        }
        this.oldStatus = status;
        for (FileTransferListener listener : this.listeners) {
            try {
                listener.fileTransferMonitor(this, status);
            }
            catch (Throwable e) {
                Utils.handleUncaughtException(e, this.exceptionHandler);
            }
        }
    }

    public Type getType() throws SkypeException {
        return Type.valueOf(this.getProperty("TYPE"));
    }

    public Status getStatus() throws SkypeException {
        return Status.valueOf(this.getProperty("STATUS"));
    }

    public FailureReason getFailureReason() throws SkypeException {
        return FailureReason.valueOf(this.getProperty("FAILUREREASON"));
    }

    public String getPartnerHandle() throws SkypeException {
        return this.getProperty("PARTNER_HANDLE");
    }

    public String getPartnerDisplayName() throws SkypeException {
        return this.getProperty("PARTNER_DISPNAME");
    }

    public String getStartTime() throws SkypeException {
        return this.getProperty("STARTTIME");
    }

    public String getFinishTime() throws SkypeException {
        return this.getProperty("FINISHTIME");
    }

    public String getFilePath() throws SkypeException {
        return this.getProperty("FILEPATH");
    }

    public String getFileName() throws SkypeException {
        return this.getProperty("FILENAME");
    }

    public String getFileSize() throws SkypeException {
        return this.getProperty("FILESIZE");
    }

    public String getBytesPerSecond() throws SkypeException {
        return this.getProperty("BYTESPERSECOND");
    }

    public String getBytesTransferred() throws SkypeException {
        return this.getProperty("BYTESTRANSFERRED");
    }

    final void dispose() {
        files.remove(this.getId());
    }

    private String getProperty(String name) throws SkypeException {
        return Utils.getProperty("FILETRANSFER", this.getId(), name);
    }

    public static enum FailureReason {
        SENDER_NOT_AUTHORIZED,
        REMOTELY_CANCELLED,
        FAILED_READ,
        FAILED_REMOTE_READ,
        FAILED_WRITE,
        FAILED_REMOTE_WRITE,
        REMOTE_DOES_NOT_SUPPORT_FT,
        REMOTE_OFFLINE_FOR_TOO_LONG,
        UNKNOWN;

    }

    public static enum Status {
        NEW,
        WAITING_FOR_ACCEPT,
        CONNECTING,
        TRANSFERRING,
        TRANSFERRING_OVER_RELAY,
        PAUSED,
        REMOTELY_PAUSED,
        CANCELLED,
        COMPLETED,
        FAILED,
        UNKNOWN;

    }

    public static enum Type {
        INCOMING,
        OUTGOING;

    }
}

