/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.FileTransfer;
import com.skype.FileTransferListener;
import com.skype.connector.AbstractConnectorListener;
import com.skype.connector.ConnectorMessageEvent;

final class FileTransferConnectorListener
extends AbstractConnectorListener {
    private FileTransferListener fileTransferListener = null;

    FileTransferConnectorListener(FileTransferListener listener) {
        this.fileTransferListener = listener;
    }

    @Override
    public void messageReceived(ConnectorMessageEvent event) {
        String message = event.getMessage();
        if (message.startsWith("FILETRANSFER ")) {
            String data = message.substring("FILETRANSFER ".length());
            String id = data.substring(0, data.indexOf(32));
            String propertyNameAndValue = data.substring(data.indexOf(32) + 1);
            String propertyName = propertyNameAndValue.substring(0, propertyNameAndValue.indexOf(32));
            if ("STATUS".equals(propertyName)) {
                String propertyValue = propertyNameAndValue.substring(propertyNameAndValue.indexOf(32) + 1);
                FileTransfer.Status status = FileTransfer.Status.valueOf(propertyValue);
                if (this.fileTransferListener != null) {
                    FileTransfer fileTransfer = FileTransfer.getInstance(id, this.fileTransferListener);
                    fileTransfer.fireFileTransfer(status);
                } else {
                    FileTransfer fileTransfer = FileTransfer.getInstance(id);
                }
                if (status == FileTransfer.Status.COMPLETED || status == FileTransfer.Status.CANCELLED || status == FileTransfer.Status.FAILED) {
                    // empty if block
                }
            }
        }
    }
}

