/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.Call;
import com.skype.Chat;
import com.skype.ChatMessage;
import com.skype.Friend;
import com.skype.Skype;
import com.skype.SkypeException;
import com.skype.SkypeExceptionHandler;
import com.skype.SkypeObject;
import com.skype.UserListener;
import com.skype.Utils;
import com.skype.VoiceMail;
import com.skype.connector.AbstractConnectorListener;
import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import com.skype.connector.ConnectorListener;
import com.skype.connector.ConnectorMessageEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;

public class User
extends SkypeObject {
    private static final Map<String, User> users = new HashMap<String, User>();
    private static final Object propertyChangeListenerMutex = new Object();
    private static ConnectorListener propertyChangeListener;
    public static final String STATUS_PROPERTY = "status";
    public static final String MOOD_TEXT_PROPERTY = "moodText";
    public static final String FULL_NAME = "fullName";
    public static final String PHONE_MOBILE = "phoneMobile";
    public static final String PHONE_HOME = "phoneHome";
    public static final String PHONE_OFFICE = "phoneOffice";
    public static final String DISPLAYNAME = "displayname";
    public static final String COUNTRY = "country";
    public static final String PROVINCE = "province";
    public static final String CITY = "city";
    public static final String TIMEZONE = "timezone";
    public static final String SEX = "sex";
    public static final String HOMEPAGE = "homepage";
    public static final String BIRTHDAY = "birthday";
    public static final String LANGUAGE = "language";
    public static final String ABOUT = "about";
    private Status oldStatus;
    private Sex oldSex;
    private String oldMoodText;
    private String oldFullName;
    private String oldPhoneMobile;
    private String oldPhoneHome;
    private String oldPhoneOffice;
    private String oldDisplayName;
    private String oldCountry;
    private String oldProvince;
    private String oldCity;
    private String oldTimeZone;
    private String oldHomePage;
    private String oldBirthday;
    private String oldLanguage;
    private String oldAbout;
    private boolean oldIsBlocked;
    private boolean oldIsAuthorized;
    private String id;
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private static final List<UserListener> monitorListeners;
    private SkypeExceptionHandler exceptionHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static User getInstance(String id) {
        Map<String, User> map = users;
        synchronized (map) {
            if (!users.containsKey(id)) {
                users.put(id, new User(id));
            }
            return users.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static User getInstance(String id, UserListener userListener) {
        Map<String, User> map = users;
        synchronized (map) {
            if (!users.containsKey(id)) {
                users.put(id, new User(id, userListener));
            } else {
                User.addUserListener(userListener);
            }
            return users.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Friend getFriendInstance(String id) {
        Map<String, User> map = users;
        synchronized (map) {
            if (!users.containsKey(id)) {
                Friend friend = new Friend(id);
                users.put(id, friend);
                return friend;
            }
            User user = users.get(id);
            if (user instanceof Friend) {
                return (Friend)user;
            }
            Friend friend = new Friend(id);
            friend.copyFrom(user);
            users.put(id, friend);
            return friend;
        }
    }

    User(String newId) {
        this.id = newId;
    }

    private User(String newId, UserListener userListener) {
        this.id = newId;
        User.addUserListener(userListener);
    }

    public final int hashCode() {
        return this.getId().hashCode();
    }

    public final boolean equals(Object compared) {
        if (compared instanceof User) {
            User comparedUser = (User)compared;
            return this.getId().equals(comparedUser.getId());
        }
        return false;
    }

    public final String toString() {
        return this.getId();
    }

    public final String getId() {
        return this.id;
    }

    static void addUserListener(UserListener userListener) {
        Utils.checkNotNull("listener", userListener);
        if (!monitorListeners.contains(userListener)) {
            monitorListeners.add(userListener);
        }
    }

    final void removeUserListener(UserListener userListener) {
        Utils.checkNotNull("listener", userListener);
        monitorListeners.remove(userListener);
    }

    protected void fireStatusMonitor(Status val) {
        if (val.equals((Object)this.oldStatus)) {
            return;
        }
        this.oldStatus = val;
        for (UserListener listener : monitorListeners) {
            try {
                listener.statusMonitor(val, this);
            }
            catch (Throwable e) {
                Utils.handleUncaughtException(e, this.exceptionHandler);
            }
        }
    }

    protected void fireMoodTextMonitor(String val) {
        if (val.equals(this.oldMoodText)) {
            return;
        }
        this.oldMoodText = val;
        for (UserListener listener : monitorListeners) {
            try {
                listener.moodTextMonitor(val, this);
            }
            catch (Throwable e) {
                Utils.handleUncaughtException(e, this.exceptionHandler);
            }
        }
    }

    protected void fireFullNameMonitor(String val) {
        if (val.equals(this.oldFullName)) {
            return;
        }
        this.oldFullName = val;
        for (UserListener listener : monitorListeners) {
            try {
                listener.fullNameMonitor(val, this);
            }
            catch (Throwable e) {
                Utils.handleUncaughtException(e, this.exceptionHandler);
            }
        }
    }

    protected void firePhoneMobileMonitor(String val) {
        if (val.equals(this.oldPhoneMobile)) {
            return;
        }
        this.oldPhoneMobile = val;
        for (UserListener listener : monitorListeners) {
            try {
                listener.phoneMobileMonitor(val, this);
            }
            catch (Throwable e) {
                Utils.handleUncaughtException(e, this.exceptionHandler);
            }
        }
    }

    protected void firePhoneHomeMonitor(String val) {
        if (val.equals(this.oldPhoneHome)) {
            return;
        }
        this.oldPhoneHome = val;
        for (UserListener listener : monitorListeners) {
            try {
                listener.phoneHomeMonitor(val, this);
            }
            catch (Throwable e) {
                Utils.handleUncaughtException(e, this.exceptionHandler);
            }
        }
    }

    protected void firePhoneOfficeMonitor(String val) {
        if (val.equals(this.oldPhoneOffice)) {
            return;
        }
        this.oldPhoneOffice = val;
        for (UserListener listener : monitorListeners) {
            try {
                listener.phoneOfficeMonitor(val, this);
            }
            catch (Throwable e) {
                Utils.handleUncaughtException(e, this.exceptionHandler);
            }
        }
    }

    protected void fireDisplayNameMonitor(String val) {
        if (val.equals(this.oldDisplayName)) {
            return;
        }
        this.oldDisplayName = val;
        for (UserListener listener : monitorListeners) {
            try {
                listener.displayNameMonitor(val, this);
            }
            catch (Throwable e) {
                Utils.handleUncaughtException(e, this.exceptionHandler);
            }
        }
    }

    protected void fireCountryMonitor(String val) {
        if (val.equals(this.oldCountry)) {
            return;
        }
        this.oldCountry = val;
        for (UserListener listener : monitorListeners) {
            try {
                listener.countryMonitor(val, this);
            }
            catch (Throwable e) {
                Utils.handleUncaughtException(e, this.exceptionHandler);
            }
        }
    }

    protected void fireProvinceMonitor(String val) {
        if (val.equals(this.oldProvince)) {
            return;
        }
        this.oldProvince = val;
        for (UserListener listener : monitorListeners) {
            try {
                listener.provinceMonitor(val, this);
            }
            catch (Throwable e) {
                Utils.handleUncaughtException(e, this.exceptionHandler);
            }
        }
    }

    protected void fireCityMonitor(String val) {
        if (val.equals(this.oldCity)) {
            return;
        }
        this.oldCity = val;
        for (UserListener listener : monitorListeners) {
            try {
                listener.cityMonitor(val, this);
            }
            catch (Throwable e) {
                Utils.handleUncaughtException(e, this.exceptionHandler);
            }
        }
    }

    protected void fireTimeZoneMonitor(String val) {
        if (val.equals(this.oldTimeZone)) {
            return;
        }
        this.oldTimeZone = val;
        for (UserListener listener : monitorListeners) {
            try {
                listener.timeZoneMonitor(val, this);
            }
            catch (Throwable e) {
                Utils.handleUncaughtException(e, this.exceptionHandler);
            }
        }
    }

    protected void fireSexMonitor(Sex val) {
        if (val.equals((Object)this.oldSex)) {
            return;
        }
        this.oldSex = val;
        for (UserListener listener : monitorListeners) {
            try {
                listener.sexMonitor(val, this);
            }
            catch (Throwable e) {
                Utils.handleUncaughtException(e, this.exceptionHandler);
            }
        }
    }

    protected void fireHomePageMonitor(String val) {
        if (val.equals(this.oldHomePage)) {
            return;
        }
        this.oldHomePage = val;
        for (UserListener listener : monitorListeners) {
            try {
                listener.homePageMonitor(val, this);
            }
            catch (Throwable e) {
                Utils.handleUncaughtException(e, this.exceptionHandler);
            }
        }
    }

    protected void fireBirthdayMonitor(String val) {
        if (val.equals(this.oldBirthday)) {
            return;
        }
        this.oldBirthday = val;
        for (UserListener listener : monitorListeners) {
            try {
                listener.birthdayMonitor(val, this);
            }
            catch (Throwable e) {
                Utils.handleUncaughtException(e, this.exceptionHandler);
            }
        }
    }

    protected void fireLanguageMonitor(String val) {
        if (val.equals(this.oldLanguage)) {
            return;
        }
        this.oldLanguage = val;
        for (UserListener listener : monitorListeners) {
            try {
                listener.languageMonitor(val, this);
            }
            catch (Throwable e) {
                Utils.handleUncaughtException(e, this.exceptionHandler);
            }
        }
    }

    protected void fireAboutMonitor(String val) {
        if (val.equals(this.oldAbout)) {
            return;
        }
        this.oldAbout = val;
        for (UserListener listener : monitorListeners) {
            try {
                listener.aboutMonitor(val, this);
            }
            catch (Throwable e) {
                Utils.handleUncaughtException(e, this.exceptionHandler);
            }
        }
    }

    protected void fireIsBlockedMonitor(boolean val) {
        if (val == this.oldIsBlocked) {
            return;
        }
        this.oldIsBlocked = val;
        for (UserListener listener : monitorListeners) {
            try {
                listener.isBlockedMonitor(val, this);
            }
            catch (Throwable e) {
                Utils.handleUncaughtException(e, this.exceptionHandler);
            }
        }
    }

    protected void fireIsAuthorizedMonitor(boolean val) {
        if (val == this.oldIsAuthorized) {
            return;
        }
        this.oldIsAuthorized = val;
        for (UserListener listener : monitorListeners) {
            try {
                listener.isAuthorizedMonitor(val, this);
            }
            catch (Throwable e) {
                Utils.handleUncaughtException(e, this.exceptionHandler);
            }
        }
    }

    public final String getFullName() throws SkypeException {
        return this.getProperty("FULLNAME");
    }

    public final Date getBirthDay() throws SkypeException {
        String value = this.getProperty("BIRTHDAY");
        if ("0".equals(value)) {
            return null;
        }
        try {
            return new SimpleDateFormat("yyyyMMdd").parse(value);
        }
        catch (ParseException e) {
            throw new IllegalStateException("library developer should check Skype specification.");
        }
    }

    public final Sex getSex() throws SkypeException {
        return Sex.valueOf(this.getProperty("SEX"));
    }

    @Deprecated
    public final Status getOnlineStatus() throws SkypeException {
        return this.getStatus();
    }

    public final Status getStatus() throws SkypeException {
        return Status.valueOf(this.getProperty("ONLINESTATUS"));
    }

    public Date getLastOnlineTime() throws SkypeException {
        return Utils.parseUnixTime(this.getProperty("LASTONLINETIMESTAMP"));
    }

    @Deprecated
    public final String getLauguage() throws SkypeException {
        return this.getLanguage();
    }

    public final String getLanguage() throws SkypeException {
        String value = this.getProperty("LANGUAGE");
        if ("".equals(value)) {
            return "";
        }
        return value.substring(value.indexOf(32) + 1);
    }

    public final String getLanguageByISOCode() throws SkypeException {
        String value = this.getProperty("LANGUAGE");
        if ("".equals(value)) {
            return "";
        }
        return value.substring(0, value.indexOf(32));
    }

    public final String getCountry() throws SkypeException {
        String value = this.getProperty("COUNTRY");
        if ("".equals(value)) {
            return "";
        }
        return value.substring(value.indexOf(32) + 1);
    }

    public final String getCountryByISOCode() throws SkypeException {
        String value = this.getProperty("COUNTRY");
        if ("".equals(value)) {
            return "";
        }
        return value.substring(0, value.indexOf(32));
    }

    public final String getProvince() throws SkypeException {
        return this.getProperty("PROVINCE");
    }

    public final String getCity() throws SkypeException {
        return this.getProperty("CITY");
    }

    @Deprecated
    public final String getHomePhone() throws SkypeException {
        return this.getHomePhoneNumber();
    }

    public final String getHomePhoneNumber() throws SkypeException {
        return this.getProperty("PHONE_HOME");
    }

    @Deprecated
    public final String getOfficePhone() throws SkypeException {
        return this.getOfficePhoneNumber();
    }

    public final String getOfficePhoneNumber() throws SkypeException {
        return this.getProperty("PHONE_OFFICE");
    }

    @Deprecated
    public final String getMobilePhone() throws SkypeException {
        return this.getMobilePhoneNumber();
    }

    public final String getMobilePhoneNumber() throws SkypeException {
        return this.getProperty("PHONE_MOBILE");
    }

    public final String getHomePageAddress() throws SkypeException {
        return this.getProperty("HOMEPAGE");
    }

    @Deprecated
    public final String getAbout() throws SkypeException {
        return this.getIntroduction();
    }

    public final String getIntroduction() throws SkypeException {
        return this.getProperty("ABOUT");
    }

    public String getMoodMessage() throws SkypeException {
        return this.getProperty("MOOD_TEXT");
    }

    public String getSpeedDial() throws SkypeException {
        return this.getProperty("SPEEDDIAL");
    }

    public void getSpeedDial(String newValue) throws SkypeException {
        this.setProperty("SPEEDDIAL", newValue);
    }

    public int getTimeZone() throws SkypeException {
        return Integer.parseInt(this.getProperty("TIMEZONE"));
    }

    public final String getDisplayName() throws SkypeException {
        return this.getProperty("DISPLAYNAME");
    }

    public final boolean isVideoCapable() throws SkypeException {
        return Boolean.parseBoolean(this.getProperty("IS_VIDEO_CAPABLE"));
    }

    public final BuddyStatus getBuddyStatus() throws SkypeException {
        return BuddyStatus.values()[Integer.parseInt(this.getProperty("BUDDYSTATUS"))];
    }

    final void askForAuthorization(String messageForAuthorization) throws SkypeException {
        try {
            String command = "SET USER " + this.getId() + " " + "BUDDYSTATUS" + " " + BuddyStatus.PENDING.ordinal() + " " + messageForAuthorization;
            String responseHeader = "USER " + this.getId() + " " + "BUDDYSTATUS";
            String response = Connector.getInstance().execute(command, responseHeader);
            Utils.checkError(response);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    final void removeFromContactList() throws SkypeException {
        this.setProperty("BUDDYSTATUS", "" + BuddyStatus.DELETED.ordinal());
    }

    public final boolean isAuthorized() throws SkypeException {
        return Boolean.parseBoolean(this.getProperty("ISAUTHORIZED"));
    }

    public final void setAuthorized(boolean on) throws SkypeException {
        this.setProperty("ISAUTHORIZED", on);
    }

    public final boolean isBlocked() throws SkypeException {
        return Boolean.parseBoolean(this.getProperty("ISBLOCKED"));
    }

    public final boolean canLeaveVoiceMail() throws SkypeException {
        return Boolean.parseBoolean(this.getProperty("CAN_LEAVE_VM"));
    }

    public final boolean isForwardingCalls() throws SkypeException {
        return Boolean.parseBoolean(this.getProperty("IS_CF_ACTIVE"));
    }

    public final void setBlocked(boolean on) throws SkypeException {
        this.setProperty("ISBLOCKED", on);
    }

    public BufferedImage getAvatar() throws SkypeException {
        try {
            File file = Utils.createTempraryFile("get_avator_", "jpg");
            String command = "GET USER " + this.getId() + " AVATAR 1 " + file.getAbsolutePath();
            String responseHeader = "USER " + this.getId() + " AVATAR 1 ";
            String response = Connector.getInstance().execute(command, responseHeader);
            Utils.checkError(response);
            BufferedImage image = ImageIO.read(file);
            file.delete();
            return image;
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private String getProperty(String name) throws SkypeException {
        return Utils.getProperty("USER", this.getId(), name);
    }

    private void setProperty(String name, boolean newValue) throws SkypeException {
        this.setProperty(name, ("" + newValue).toUpperCase());
    }

    private void setProperty(String name, String newValue) throws SkypeException {
        Utils.setProperty("USER", this.getId(), name, newValue);
    }

    public final Call call() throws SkypeException {
        return Skype.call(this.getId());
    }

    public final Chat chat() throws SkypeException {
        return Skype.chat(this.getId());
    }

    public final ChatMessage send(String message) throws SkypeException {
        return Skype.chat(this.getId()).send(message);
    }

    public final VoiceMail voiceMail() throws SkypeException {
        return Skype.voiceMail(this.getId());
    }

    public final void setDisplayName(String newValue) throws SkypeException {
        Utils.setProperty("USER", this.getId(), "DISPLAYNAME", newValue);
    }

    public final ChatMessage[] getAllChatMessages() throws SkypeException {
        String[] ids = this.getHistory("CHATMESSAGES");
        ChatMessage[] messages = new ChatMessage[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            messages[i] = ChatMessage.getInstance(ids[i]);
        }
        List<ChatMessage> messageList = Arrays.asList(messages);
        Collections.reverse(messageList);
        return messageList.toArray(new ChatMessage[0]);
    }

    public final Call[] getAllCalls() throws SkypeException {
        String[] ids = this.getHistory("CALLS");
        Call[] calls = new Call[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            calls[i] = Call.getInstance(ids[i]);
        }
        return calls;
    }

    private String[] getHistory(String type) throws SkypeException {
        try {
            String responseHeader = type + " ";
            String response = Connector.getInstance().execute("SEARCH " + type + " " + this.getId(), responseHeader);
            Utils.checkError(response);
            String data = response.substring(responseHeader.length());
            return Utils.convertToArray(data);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return null;
        }
    }

    final void dispose() {
        users.remove(this.getId());
    }

    private void firePropertyChanged(String propertyName, Object oldValue, Object newValue) {
        this.listeners.firePropertyChange(propertyName, oldValue, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPropertyChangeListener(PropertyChangeListener listener) throws SkypeException {
        Object object = propertyChangeListenerMutex;
        synchronized (object) {
            if (propertyChangeListener == null) {
                AbstractConnectorListener connectorListener = new AbstractConnectorListener(){

                    @Override
                    public void messageReceived(ConnectorMessageEvent event) {
                        String message = event.getMessage();
                        if (message.startsWith("USER ")) {
                            String data = message.substring("USER ".length());
                            String skypeId = data.substring(0, data.indexOf(32));
                            data = data.substring(data.indexOf(32) + 1);
                            String propertyName = data.substring(0, data.indexOf(32));
                            String propertyValue = data.substring(data.indexOf(32) + 1);
                            if (propertyName.equals("ONLINESTATUS")) {
                                User.getInstance(skypeId).firePropertyChanged(User.STATUS_PROPERTY, null, (Object)Status.valueOf(propertyValue));
                            } else if (propertyName.equals("MOOD_TEXT")) {
                                User.getInstance(skypeId).firePropertyChanged(User.MOOD_TEXT_PROPERTY, null, propertyValue);
                            } else if (propertyName.equals("FULLNAME")) {
                                User.getInstance(skypeId).firePropertyChanged(User.FULL_NAME, null, propertyValue);
                            } else if (propertyName.equals("PHONE_MOBILE")) {
                                User.getInstance(skypeId).firePropertyChanged(User.PHONE_MOBILE, null, propertyValue);
                            } else if (propertyName.equals("PHONE_HOME")) {
                                User.getInstance(skypeId).firePropertyChanged(User.PHONE_HOME, null, propertyValue);
                            } else if (propertyName.equals("PHONE_OFFICE")) {
                                User.getInstance(skypeId).firePropertyChanged(User.PHONE_OFFICE, null, propertyValue);
                            } else if (propertyName.equals("DISPLAYNAME")) {
                                User.getInstance(skypeId).firePropertyChanged(User.DISPLAYNAME, null, propertyValue);
                            } else if (propertyName.equals("COUNTRY")) {
                                User.getInstance(skypeId).firePropertyChanged(User.COUNTRY, null, propertyValue);
                            } else if (propertyName.equals("PROVINCE")) {
                                User.getInstance(skypeId).firePropertyChanged(User.PROVINCE, null, propertyValue);
                            } else if (propertyName.equals("CITY")) {
                                User.getInstance(skypeId).firePropertyChanged(User.CITY, null, propertyValue);
                            } else if (propertyName.equals("TIMEZONE")) {
                                User.getInstance(skypeId).firePropertyChanged(User.TIMEZONE, null, propertyValue);
                            } else if (propertyName.equals("SEX")) {
                                User.getInstance(skypeId).firePropertyChanged(User.SEX, null, propertyValue);
                            } else if (propertyName.equals("HOMEPAGE")) {
                                User.getInstance(skypeId).firePropertyChanged(User.HOMEPAGE, null, propertyValue);
                            } else if (propertyName.equals("BIRTHDAY")) {
                                User.getInstance(skypeId).firePropertyChanged(User.BIRTHDAY, null, propertyValue);
                            } else if (propertyName.equals("LANGUAGE")) {
                                User.getInstance(skypeId).firePropertyChanged(User.LANGUAGE, null, propertyValue);
                            } else if (propertyName.equals("ABOUT")) {
                                User.getInstance(skypeId).firePropertyChanged(User.ABOUT, null, propertyValue);
                            }
                        }
                    }
                };
                try {
                    Connector.getInstance().addConnectorListener(connectorListener);
                    propertyChangeListener = connectorListener;
                }
                catch (ConnectorException e) {
                    Utils.convertToSkypeException(e);
                }
            }
        }
        this.listeners.addPropertyChangeListener(listener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    static {
        monitorListeners = Collections.synchronizedList(new ArrayList());
    }

    public static enum BuddyStatus {
        NEVER_BEEN,
        DELETED,
        PENDING,
        ADDED;

    }

    public static enum Sex {
        UNKNOWN,
        MALE,
        FEMALE;

    }

    public static enum Status {
        UNKNOWN,
        ONLINE,
        OFFLINE,
        SKYPEME,
        AWAY,
        NA,
        DND,
        INVISIBLE,
        LOGGEDOUT;

    }
}

