/*
 * Decompiled with CFR 0.152.
 */
package com.skype.connector;

import com.skype.connector.LoadLibraryException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;

public final class ConnectorUtils {
    private static List<String> loadedLibraries = new ArrayList<String>();
    private static String skypeApiTempDir = null;

    public static void checkNotNull(String name, Object value) {
        if (value == null) {
            throw new NullPointerException("The " + name + " must not be null.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLibrary(String libraryName) throws LoadLibraryException {
        List<String> list = loadedLibraries;
        synchronized (list) {
            if (loadedLibraries.contains(libraryName)) {
                return;
            }
            try {
                System.loadLibrary(libraryName);
            }
            catch (UnsatisfiedLinkError err) {
                File libraryFile;
                String libraryFileName = libraryName;
                URL url = ConnectorUtils.class.getResource("/" + libraryFileName);
                if (url == null) {
                    throw new IllegalStateException("Library " + libraryFileName + " is not in the resource path! This is a bug!");
                }
                if (url.getProtocol().toLowerCase().equals("file")) {
                    try {
                        libraryFile = new File(URLDecoder.decode(url.getPath(), "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new LoadLibraryException("UTF-8 is not supported encoding.");
                    }
                } else {
                    ConnectorUtils.cleanUpOldLibraryFiles(libraryFileName);
                    libraryFile = ConnectorUtils.createTempLibraryFile(libraryFileName);
                }
                ConnectorUtils.rehydrateFrameworkAtLibraryPath(libraryFile);
                try {
                    System.load(libraryFile.getAbsolutePath());
                }
                catch (UnsatisfiedLinkError e) {
                    throw new LoadLibraryException("Loading " + libraryFileName + " failed.\n" + e.getMessage());
                }
            }
            loadedLibraries.add(libraryName);
        }
    }

    private static void rehydrateFrameworkAtLibraryPath(File libraryFile) {
        if (!libraryFile.getName().endsWith("jnilib")) {
            return;
        }
        try {
            File skypeFramework = new File(libraryFile.getCanonicalFile().getParentFile(), "Skype.Framework");
            URL skypeFrameworkResourceUrl = ConnectorUtils.class.getResource("/Skype.Framework");
            if (!skypeFramework.getAbsolutePath().equals(skypeFrameworkResourceUrl.getPath())) {
                InputStream skypeFrameworkStream = ConnectorUtils.class.getResourceAsStream("/Skype.Framework");
                ConnectorUtils.writeStreamToFile(skypeFrameworkStream, skypeFramework);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeStreamToFile(InputStream skypeFrameworkStream, File skypeFramework) throws FileNotFoundException, IOException {
        FileOutputStream out = null;
        try {
            int count;
            out = new FileOutputStream(skypeFramework);
            byte[] buffer = new byte[1024];
            while (0 < (count = skypeFrameworkStream.read(buffer))) {
                out.write(buffer, 0, count);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private static void cleanUpOldLibraryFiles(String libraryFileName) {
        final String fileNamePrefix = libraryFileName.substring(0, libraryFileName.indexOf(46));
        final String extension = libraryFileName.substring(libraryFileName.lastIndexOf(46));
        for (File file : new File(System.getProperty("java.io.tmpdir")).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(fileNamePrefix) && name.endsWith(extension);
            }
        })) {
            file.delete();
        }
    }

    private static File createTempLibraryFile(String libraryFileName) throws LoadLibraryException {
        InputStream in = ConnectorUtils.class.getResourceAsStream("/" + libraryFileName);
        if (in == null) {
            throw new LoadLibraryException(libraryFileName + " is not contained in the jar.");
        }
        FileOutputStream out = null;
        try {
            String fileNamePrefix = libraryFileName.substring(0, libraryFileName.indexOf(46));
            String extension = libraryFileName.substring(libraryFileName.lastIndexOf(46));
            File libraryFile = File.createTempFile(fileNamePrefix, extension);
            libraryFile.deleteOnExit();
            ConnectorUtils.writeStreamToFile(in, libraryFile);
            File file = libraryFile;
            return file;
        }
        catch (IOException e) {
            throw new LoadLibraryException("Writing " + libraryFileName + " failed.");
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private ConnectorUtils() {
    }

    public static String getSkypeTempDir() {
        if (skypeApiTempDir != null && new File(skypeApiTempDir).exists()) {
            return skypeApiTempDir;
        }
        File directory = new File(System.getProperty("java.io.tmpdir"));
        try {
            File tempDir = File.createTempFile("skype-java-api", "", directory);
            tempDir.delete();
            tempDir.mkdir();
            skypeApiTempDir = tempDir.getCanonicalPath();
            return skypeApiTempDir;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create temporary directory to extract required libraries", e);
        }
    }
}

