/*
 * Decompiled with CFR 0.152.
 */
package testoptimal.api;

import com.google.gson.Gson;
import testoptimal.api.APIError;
import testoptimal.api.COMB.DataSet;
import testoptimal.api.COMB.DataSetReq;
import testoptimal.api.Constants;
import testoptimal.api.RunResult;
import testoptimal.api.Server;

public class DataSetAPI {
    private Server svr;
    private Gson gson = new Gson();

    protected DataSetAPI(Server svr_p) {
        this.svr = svr_p;
    }

    public void upload(DataSet ds_p) throws APIError {
        String dsJson = this.gson.toJson((Object)ds_p);
        this.svr.sendPut("datadesign", "dataset/" + ds_p.getName(), dsJson, 200);
    }

    public RunResult generate(String dsName_p, Constants.Algorithm alg_p) throws APIError {
        DataSetReq req = new DataSetReq();
        req.dsName = dsName_p;
        req.path = "client";
        req.algorithm = alg_p;
        String reqJson = this.gson.toJson((Object)req);
        String retJson = this.svr.sendPost("client", "dataset/gen", reqJson, 200);
        RunResult result = (RunResult)this.gson.fromJson(retJson, RunResult.class);
        return result;
    }
}

