/*
 * Decompiled with CFR 0.152.
 */
package com.github.thorbenkuck.netcom2.network.client;

import com.github.thorbenkuck.netcom2.logging.Logging;
import com.github.thorbenkuck.netcom2.network.shared.comm.RemoteAccessCommunicationRequest;
import com.github.thorbenkuck.netcom2.network.shared.comm.RemoteAccessCommunicationResponse;
import com.github.thorbenkuck.netcom2.utility.NetCom2Utils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Semaphore;

class RemoteAccessBlockRegistration {
    private final Map<UUID, Semaphore> semaphoreMap = new HashMap<UUID, Semaphore>();
    private final Map<UUID, RemoteAccessCommunicationResponse> responseMap = new HashMap<UUID, RemoteAccessCommunicationResponse>();
    private final Logging logging = Logging.unified();

    RemoteAccessBlockRegistration() {
        this.logging.instantiated((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Semaphore getAndCreateSemaphore(UUID uuid) {
        Map<UUID, Semaphore> map = this.semaphoreMap;
        synchronized (map) {
            this.semaphoreMap.computeIfAbsent(uuid, key -> new Semaphore(1));
        }
        Semaphore semaphore = this.getSemaphore(uuid);
        try {
            semaphore.acquire();
        }
        catch (InterruptedException e) {
            this.logging.catching((Throwable)e);
        }
        return semaphore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Semaphore getSemaphore(UUID uuid) {
        Semaphore semaphore;
        Map<UUID, Semaphore> map = this.semaphoreMap;
        synchronized (map) {
            semaphore = this.semaphoreMap.get(uuid);
        }
        return semaphore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearSemaphore(UUID uuid) {
        NetCom2Utils.parameterNotNull((Object)uuid);
        Map<UUID, Semaphore> map = this.semaphoreMap;
        synchronized (map) {
            this.semaphoreMap.remove(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearResult(UUID uuid) {
        NetCom2Utils.parameterNotNull((Object)uuid);
        Map<UUID, RemoteAccessCommunicationResponse> map = this.responseMap;
        synchronized (map) {
            this.responseMap.remove(uuid);
        }
    }

    Semaphore await(RemoteAccessCommunicationRequest request) {
        NetCom2Utils.parameterNotNull((Object)request);
        Semaphore semaphore = this.getAndCreateSemaphore(request.getUuid());
        this.responseMap.remove(request.getUuid());
        return semaphore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(RemoteAccessCommunicationResponse response) {
        NetCom2Utils.parameterNotNull((Object)response);
        Map<UUID, RemoteAccessCommunicationResponse> map = this.responseMap;
        synchronized (map) {
            this.responseMap.put(response.getUuid(), response);
        }
        Semaphore semaphore = this.getSemaphore(response.getUuid());
        if (semaphore == null) {
            return;
        }
        semaphore.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RemoteAccessCommunicationResponse getResponse(UUID uuid) {
        NetCom2Utils.parameterNotNull((Object)uuid);
        Map<UUID, RemoteAccessCommunicationResponse> map = this.responseMap;
        synchronized (map) {
            return this.responseMap.get(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int countSemaphores() {
        Map<UUID, Semaphore> map = this.semaphoreMap;
        synchronized (map) {
            return this.semaphoreMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int countResponses() {
        Map<UUID, RemoteAccessCommunicationResponse> map = this.responseMap;
        synchronized (map) {
            return this.responseMap.size();
        }
    }
}

