/*
 * Decompiled with CFR 0.152.
 */
package com.github.thorbenkuck.netcom2.network.server;

import com.github.thorbenkuck.netcom2.annotations.rmi.IgnoreRemoteExceptions;
import com.github.thorbenkuck.netcom2.annotations.rmi.RegistrationOverrideProhibited;
import com.github.thorbenkuck.netcom2.exceptions.RemoteObjectInvalidMethodException;
import com.github.thorbenkuck.netcom2.exceptions.RemoteObjectNotRegisteredException;
import com.github.thorbenkuck.netcom2.exceptions.RemoteRequestException;
import com.github.thorbenkuck.netcom2.logging.Logging;
import com.github.thorbenkuck.netcom2.network.server.RemoteObjectRegistration;
import com.github.thorbenkuck.netcom2.network.server.ServerStart;
import com.github.thorbenkuck.netcom2.network.shared.CommunicationRegistration;
import com.github.thorbenkuck.netcom2.network.shared.Session;
import com.github.thorbenkuck.netcom2.network.shared.comm.OnReceiveTriple;
import com.github.thorbenkuck.netcom2.network.shared.comm.RemoteAccessCommunicationRequest;
import com.github.thorbenkuck.netcom2.network.shared.comm.RemoteAccessCommunicationResponse;
import com.github.thorbenkuck.netcom2.network.shared.connections.Connection;
import com.github.thorbenkuck.netcom2.network.shared.connections.ConnectionContext;
import com.github.thorbenkuck.netcom2.utility.NetCom2Utils;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

final class NativeRemoteObjectRegistration
implements RemoteObjectRegistration {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_MAPPING;
    private final Map<Class<?>, Object> mapping = new HashMap();
    private final Logging logging = Logging.unified();
    private final RemoteRequestHandler remoteRequestHandler = new RemoteRequestHandler();
    private CommunicationRegistration communicationRegistration;

    NativeRemoteObjectRegistration() {
        this.logging.instantiated((Object)this);
    }

    private Object[] orderParameters(Object[] args, Method method) {
        if (args == null) {
            return null;
        }
        ArrayList<Object> arguments = new ArrayList<Object>(Arrays.asList(args));
        ArrayList<Object> parameters = new ArrayList<Object>();
        for (Class<?> parameterClass : method.getParameterTypes()) {
            Class<?> casedParameter = this.convertPrimitiveTypes(parameterClass);
            Object o = this.get(arguments, casedParameter);
            parameters.add(o);
        }
        return parameters.toArray();
    }

    private Object get(List<Object> list, Class clazz) {
        for (Object object : list) {
            if (!this.convertPrimitiveTypes(object.getClass()).equals(clazz)) continue;
            return object;
        }
        throw new IllegalArgumentException("Could not correctly determine the Objects! Possible internal error! Requested: " + clazz + " provided " + list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canBeOverridden(Class clazz) {
        if (clazz.getAnnotation(RegistrationOverrideProhibited.class) != null) {
            Object check;
            this.logging.trace((Object)"Found RegistrationOverrideProhibited Annotation, checking if instance is saved");
            Map<Class<?>, Object> map = this.mapping;
            synchronized (map) {
                check = this.mapping.get(clazz);
            }
            return check == null;
        }
        return true;
    }

    private RemoteAccessCommunicationResponse generateResult(UUID uuid, Exception exception, Object result, Class clazz, Method method) {
        if (this.ignoreThrowable(exception, clazz, method)) {
            return new RemoteAccessCommunicationResponse(uuid, null, result);
        }
        return new RemoteAccessCommunicationResponse(uuid, (Throwable)exception, result);
    }

    private boolean ignoreThrowable(Exception exception, AnnotatedElement ... annotatedElements) {
        if (exception != null) {
            for (AnnotatedElement element : annotatedElements) {
                IgnoreRemoteExceptions annotation;
                if (element == null || (annotation = element.getAnnotation(IgnoreRemoteExceptions.class)) == null) continue;
                return !Arrays.asList(annotation.exceptTypes()).contains(exception.getClass());
            }
        }
        return false;
    }

    private Class<?> convertPrimitiveTypes(Class<?> input) {
        return PRIMITIVE_MAPPING.getOrDefault(input, input);
    }

    private boolean parameterTypesEqual(Method method, Object[] args) {
        Class<?>[] declaredParameterTypes = method.getParameterTypes();
        if (args == null) {
            return declaredParameterTypes.length == 0;
        }
        if (args.length != declaredParameterTypes.length) {
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            Class<?> argumentType;
            Class<?> declaredType = this.convertPrimitiveTypes(declaredParameterTypes[i]);
            if (declaredType.equals(argumentType = this.convertPrimitiveTypes(args[i].getClass())) && !declaredParameterTypes[i].equals(Session.class) && !declaredParameterTypes[i].equals(Connection.class)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterCertainClass(Class clazz) {
        this.logging.trace((Object)("Unregister " + clazz));
        Map<Class<?>, Object> map = this.mapping;
        synchronized (map) {
            this.mapping.remove(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object handleMethod(Method method, Object callOn, Object[] args) throws Throwable {
        boolean accessible = method.isAccessible();
        this.logging.trace((Object)("updating accessibility of Method " + method.getName()));
        method.setAccessible(true);
        try {
            this.logging.trace((Object)("invoking Method " + method.getName() + " of " + callOn + " with parameters " + Arrays.toString(args)));
            Object object = method.invoke(callOn, args);
            return object;
        }
        finally {
            this.logging.trace((Object)("Setting accessibility back to original state(" + accessible + ").."));
            method.setAccessible(accessible);
        }
    }

    public final void setup(ServerStart serverStart) {
        this.communicationRegistration = serverStart.getCommunicationRegistration();
        try {
            this.communicationRegistration.acquire();
            this.communicationRegistration.register(RemoteAccessCommunicationRequest.class).addFirst((OnReceiveTriple)this.remoteRequestHandler);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.communicationRegistration.release();
        }
    }

    public final void close() {
        try {
            this.communicationRegistration.acquire();
            this.communicationRegistration.register(RemoteAccessCommunicationRequest.class).remove((OnReceiveTriple)this.remoteRequestHandler);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.communicationRegistration.release();
        }
    }

    @Override
    public final void register(Object object) {
        NetCom2Utils.parameterNotNull((Object)object);
        this.register(object, object.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void register(Object o, Class<?> ... identifier) {
        NetCom2Utils.parameterNotNull((Object[])new Object[]{o, identifier});
        if (identifier.length <= 0) {
            throw new IllegalArgumentException("At least on identifier class is required to register an Object!");
        }
        this.logging.debug((Object)("Trying to register " + o.getClass() + " by " + Arrays.asList(identifier)));
        for (Class<?> clazz : identifier) {
            Object savedInstance;
            this.logging.debug((Object)("Assignable " + clazz.isAssignableFrom(o.getClass())));
            if (!clazz.isAssignableFrom(o.getClass())) {
                this.logging.error((Object)("The Object " + o.getClass() + " is not assignable from " + clazz));
                continue;
            }
            Map<Class<?>, Object> map = this.mapping;
            synchronized (map) {
                savedInstance = this.mapping.get(clazz);
            }
            if (savedInstance != null && !this.canBeOverridden(savedInstance.getClass())) {
                this.logging.debug((Object)("Overriding of " + clazz + " not possible due to its annotation at " + savedInstance));
                continue;
            }
            this.logging.trace((Object)("Registering " + clazz + " as RemoteUsable by Object " + o.getClass()));
            map = this.mapping;
            synchronized (map) {
                this.mapping.put(clazz, o);
            }
        }
    }

    @Override
    public final void hook(Object object) {
        NetCom2Utils.parameterNotNull((Object)object);
        ArrayList classList = new ArrayList(Arrays.asList(object.getClass().getInterfaces()));
        classList.add(object.getClass().getSuperclass());
        classList.add(object.getClass());
        this.register(object, classList.toArray(new Class[classList.size()]));
    }

    @Override
    public final void unregister(Object object) {
        NetCom2Utils.parameterNotNull((Object)object);
        this.unregister(object, object.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unregister(Object object, Class ... identifiers) {
        NetCom2Utils.parameterNotNull((Object[])new Object[]{object, identifiers});
        this.logging.debug((Object)("Trying to unregister " + object.getClass() + ", identified by " + Arrays.asList(identifiers)));
        for (Class clazz : identifiers) {
            Object selected;
            this.logging.debug((Object)("Assignable " + clazz.isAssignableFrom(object.getClass())));
            Map<Class<?>, Object> map = this.mapping;
            synchronized (map) {
                selected = this.mapping.get(clazz);
            }
            if (selected == null) {
                this.logging.warn((Object)("No instance registered for " + clazz + ".. Tried to unregister " + object));
                continue;
            }
            if (!object.equals(selected)) {
                this.logging.error((Object)("The Object " + object.getClass() + " is not assignable from " + clazz));
                continue;
            }
            this.unregisterCertainClass(clazz);
        }
    }

    @Override
    public final void unregister(Class ... identifier) {
        NetCom2Utils.parameterNotNull((Object[])identifier);
        for (Class clazz : identifier) {
            this.unregisterCertainClass(clazz);
        }
    }

    @Override
    public final void unhook(Object object) {
        NetCom2Utils.parameterNotNull((Object)object);
        ArrayList classList = new ArrayList(Arrays.asList(object.getClass().getInterfaces()));
        classList.add(object.getClass().getSuperclass());
        classList.add(object.getClass());
        this.unregister(object, classList.toArray(new Class[classList.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clear() {
        this.logging.debug((Object)("Clearing the RemoteObjectRegistration " + this.toString()));
        Map<Class<?>, Object> map = this.mapping;
        synchronized (map) {
            this.mapping.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final RemoteAccessCommunicationResponse run(RemoteAccessCommunicationRequest request) {
        Object handlingObject;
        NetCom2Utils.parameterNotNull((Object)request);
        NetCom2Utils.parameterNotNull((Object[])new Object[]{request.getMethodName(), request.getClazz(), request.getUuid()});
        Map<Class<?>, Object> map = this.mapping;
        synchronized (map) {
            handlingObject = this.mapping.get(request.getClazz());
        }
        if (handlingObject == null) {
            this.logging.error((Object)("No registered Objects found for " + request.getClazz()));
            this.logging.trace((Object)"Returning exception for no registered Object..");
            return this.generateResult(request.getUuid(), (Exception)((Object)new RemoteObjectNotRegisteredException(request.getClazz() + " is not registered!")), null, request.getClazz(), null);
        }
        Object exception = null;
        Object methodCallResult = null;
        Method methodToCall = null;
        for (Method method : handlingObject.getClass().getMethods()) {
            if (!method.getName().equals(request.getMethodName()) || !this.parameterTypesEqual(method, request.getParameters())) continue;
            this.logging.debug((Object)("Found suitable Method " + method.getName() + " of " + handlingObject));
            methodToCall = method;
            break;
        }
        if (methodToCall != null) {
            Object[] args = this.orderParameters(request.getParameters(), methodToCall);
            try {
                methodCallResult = this.handleMethod(methodToCall, handlingObject, args);
                this.logging.debug((Object)("Computed result detected: " + methodCallResult));
            }
            catch (Exception e) {
                this.logging.catching((Throwable)e);
                exception = e;
            }
            catch (Throwable throwable) {
                this.logging.fatal((Object)("Encountered throwable, non Exception: " + throwable + " while executing " + methodToCall + " on " + handlingObject.getClass()), throwable);
                exception = new RemoteException("RemoteObjectRegistration encountered " + throwable.getClass());
            }
        } else {
            exception = new RemoteObjectInvalidMethodException("No suitable method found for name " + request.getMethodName() + " with parameters" + Arrays.toString(request.getParameters()));
        }
        this.logging.trace((Object)("Finalizing run of " + request.getClazz()));
        return this.generateResult(request.getUuid(), (Exception)exception, methodCallResult, request.getClazz(), methodToCall);
    }

    static {
        HashMap<Class<Serializable>, Class> primitives = new HashMap<Class<Serializable>, Class>();
        primitives.put(Integer.TYPE, Integer.class);
        primitives.put(Double.TYPE, Double.class);
        primitives.put(Long.TYPE, Long.class);
        primitives.put(Short.TYPE, Short.class);
        primitives.put(Float.TYPE, Float.class);
        primitives.put(Character.TYPE, Character.class);
        primitives.put(Boolean.TYPE, Boolean.class);
        primitives.put(Byte.TYPE, Byte.class);
        PRIMITIVE_MAPPING = Collections.unmodifiableMap(primitives);
    }

    private final class RemoteRequestHandler
    implements OnReceiveTriple<RemoteAccessCommunicationRequest> {
        private RemoteRequestHandler() {
        }

        public void accept(ConnectionContext connectionContext, Session session, RemoteAccessCommunicationRequest remoteAccessCommunicationRequest) {
            NetCom2Utils.parameterNotNull((Object[])new Object[]{connectionContext, remoteAccessCommunicationRequest});
            try {
                connectionContext.send((Object)NativeRemoteObjectRegistration.this.run(remoteAccessCommunicationRequest));
            }
            catch (RemoteRequestException e) {
                NativeRemoteObjectRegistration.this.logging.error((Object)"Could not run RemoteObjectRequest", (Throwable)e);
            }
        }

        public String toString() {
            return "RemoteRequestHandler{}";
        }
    }
}

