/*
 * Decompiled with CFR 0.152.
 */
package com.github.thorbenkuck.scripting;

import com.github.thorbenkuck.scripting.Line;
import com.github.thorbenkuck.scripting.Parser;
import com.github.thorbenkuck.scripting.Register;
import com.github.thorbenkuck.scripting.Rule;
import java.util.function.Consumer;

class LoopStartRule
implements Rule {
    LoopStartRule() {
    }

    @Override
    public Consumer<Register> apply(Line line, Parser parser, int linePointer) {
        String rawArgs = line.toString();
        String withoutIdentifier = rawArgs.substring(5, rawArgs.length());
        StringBuilder stringBuilder = new StringBuilder(withoutIdentifier);
        final String name = stringBuilder.substring(0, withoutIdentifier.indexOf(" "));
        stringBuilder.delete(0, name.length() + 1);
        final String initial = stringBuilder.substring(0, withoutIdentifier.indexOf(" "));
        stringBuilder.delete(0, name.length() + 1);
        String finale = stringBuilder.substring(0, withoutIdentifier.indexOf(" "));
        stringBuilder.delete(0, name.length() + 1);
        if (!"null".equals(parser.getInternalVariable(name))) {
            int value = Integer.parseInt(parser.getInternalVariable(name));
            String stringedValue = String.valueOf(++value);
            int finalValue = Integer.parseInt(finale);
            if (value > finalValue) {
                parser.setLinePointer(Integer.parseInt(parser.getInternalVariable("loopEnd" + name)));
                parser.deleteInternalVariable(name);
                parser.clearInternalVariable("loop" + name);
                parser.clearInternalVariable("loopEnd" + name);
                return new Consumer<Register>(){

                    @Override
                    public void accept(Register register) {
                        register.remove(name);
                    }

                    public String toString() {
                        return "Loop Finalizer. Removing " + name;
                    }
                };
            }
            parser.setInternalVariable(name, stringedValue);
            return new Consumer<Register>(){

                @Override
                public void accept(Register register) {
                    int count = Integer.parseInt(register.get(name));
                    register.put(name, String.valueOf(++count));
                }

                public String toString() {
                    return "Increase Loop-Count(" + name + ")";
                }
            };
        }
        parser.setInternalVariable(name, initial);
        parser.setInternalVariable("loop" + name, String.valueOf(linePointer - 1));
        return new Consumer<Register>(){

            @Override
            public void accept(Register register) {
                register.put(name, initial);
            }

            public String toString() {
                return "Loop initializer";
            }
        };
    }

    @Override
    public boolean applies(Line line) {
        return line.startsWith("loop");
    }
}

