/*
 * Decompiled with CFR 0.152.
 */
package com.github.thorbenkuck.scripting;

import com.github.thorbenkuck.scripting.Function;
import com.github.thorbenkuck.scripting.Register;
import java.util.Arrays;
import java.util.function.Consumer;

public class Utility {
    public static Consumer<Register> createPrintVariable(final String variableName) {
        return new Consumer<Register>(){

            @Override
            public void accept(Register register) {
                System.out.print(register.get(variableName));
            }

            public String toString() {
                return "PrintVariable(" + variableName + ")";
            }
        };
    }

    public static Consumer<Register> createPrintText(final String what) {
        return new Consumer<Register>(){

            @Override
            public void accept(Register register) {
                System.out.print(what);
            }

            public String toString() {
                return "PrintText(\"" + what + "\")";
            }
        };
    }

    public static Consumer<Register> createPrintLineVariable(final String variableName) {
        return new Consumer<Register>(){

            @Override
            public void accept(Register register) {
                System.out.println(register.get(variableName));
            }

            public String toString() {
                return "PrintlnVariable(" + variableName + ")";
            }
        };
    }

    public static Consumer<Register> createPrintLineText(final String what) {
        return new Consumer<Register>(){

            @Override
            public void accept(Register register) {
                System.out.println(what);
            }

            public String toString() {
                return "PrintlnText(\"" + what + "\")";
            }
        };
    }

    public static Consumer<Register> wrapFunction(final Function function, final String registerAddress, final String[] args) {
        if ("void".equals(function.hintReturnValue())) {
            return new Consumer<Register>(){

                @Override
                public void accept(Register register) {
                    function.calculate(args, register);
                }

                public String toString() {
                    return function.getFunctionName() + "(" + Arrays.toString(args) + ")";
                }
            };
        }
        return new Consumer<Register>(){

            @Override
            public void accept(Register register) {
                register.put(registerAddress, function.calculate(args, register));
            }

            public String toString() {
                return "Set register " + registerAddress + " to " + function.getFunctionName() + "(" + Arrays.toString(args) + ")";
            }
        };
    }

    public static boolean isInteger(String s, Register register) {
        return Utility.isInteger(s) || Utility.isInteger(register.get(s));
    }

    public static boolean isInteger(String s, int radix) {
        if (s.isEmpty()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (!(i == 0 && s.charAt(i) == '-' ? s.length() == 1 : Character.digit(s.charAt(i), radix) < 0)) continue;
            return false;
        }
        return true;
    }

    public static boolean isInteger(String s) {
        return Utility.isInteger(s, 10);
    }

    public static boolean isDouble(String s) {
        try {
            Double.parseDouble(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isDouble(String s, Register register) {
        return Utility.isDouble(s) || Utility.isDouble(register.get(s));
    }

    public static double toDouble(String s) {
        return Utility.toDouble(s, 0.0);
    }

    public static double toDouble(String s, double defaultValue) {
        if (!Utility.isDouble(s)) {
            return defaultValue;
        }
        return Double.parseDouble(s);
    }

    public static double toDouble(String s, Register register) {
        return Utility.toDouble(s, register, 0.0);
    }

    public static double toDouble(String s, Register register, double defaultValue) {
        if (!Utility.isDouble(s)) {
            if (Utility.isDouble(register.get(s))) {
                return Utility.toDouble(register.get(s));
            }
            if (Utility.isInteger(s, register)) {
                return Utility.toInt(s, register);
            }
            return defaultValue;
        }
        return Utility.toDouble(s);
    }

    public static int toInt(String s) {
        return Utility.toInt(s, 0);
    }

    public static int toInt(String s, int defaultValue) {
        if (!Utility.isInteger(s)) {
            return defaultValue;
        }
        return Integer.parseInt(s);
    }

    public static int toInt(String s, Register register) {
        return Utility.toInt(s, register, 0);
    }

    public static int toInt(String s, Register register, int defaultValue) {
        if (!Utility.isInteger(s)) {
            if (Utility.isInteger(s, register)) {
                return Utility.toInt(register.get(s));
            }
            return defaultValue;
        }
        return Utility.toInt(s);
    }
}

