/*
 * Decompiled with CFR 0.152.
 */
package com.github.thorbenkuck.scripting.io;

import com.github.thorbenkuck.scripting.Function;
import com.github.thorbenkuck.scripting.Parser;
import com.github.thorbenkuck.scripting.Register;
import com.github.thorbenkuck.scripting.io.IOUtils;
import java.io.PrintStream;

public class PrintFunction
implements Function {
    private final PrintStream out;

    public PrintFunction() {
        this(System.out);
    }

    public PrintFunction(PrintStream out) {
        this.out = out;
    }

    @Override
    public String calculate(String[] args, Register register) {
        for (String name : args) {
            IOUtils.printAccordingToType(name, register, this.out);
        }
        return "void";
    }

    @Override
    public void onParse(String[] args, Parser parser, int lineNumber) {
        if (args.length == 0) {
            parser.error(this.getFunctionName() + " expects at least one argument");
        }
    }

    @Override
    public String getFunctionName() {
        return "print";
    }

    @Override
    public String hintReturnValue() {
        return "void";
    }
}

