/*
 * Decompiled with CFR 0.152.
 */
package com.github.thorbenkuck.scripting.system;

import com.github.thorbenkuck.scripting.Function;
import com.github.thorbenkuck.scripting.Line;
import com.github.thorbenkuck.scripting.Parser;
import com.github.thorbenkuck.scripting.Register;
import com.github.thorbenkuck.scripting.Rule;
import com.github.thorbenkuck.scripting.exceptions.ExecutionRuntimeException;
import java.util.function.Consumer;

public class VariableDefinitionRule
implements Rule {
    @Override
    public boolean applies(Line line) {
        return line.matches(".+[ ]*=[ ]*.+");
    }

    @Override
    public Consumer<Register> apply(Line line, Parser parser, int linePointer) {
        final String name = this.parseVariableName(line.duplicate());
        final String value = this.parseVariableValue(line.duplicate());
        return new Consumer<Register>(){

            @Override
            public void accept(Register register) {
                if ("null".equals(register.get(name))) {
                    throw new ExecutionRuntimeException(name + " is not defined");
                }
                if (Function.isVariable.apply(value, register).booleanValue()) {
                    String savedValue = register.get(value);
                    if ("null".equals(savedValue)) {
                        throw new ExecutionRuntimeException("Tried to set null variable!");
                    }
                    register.put(name, savedValue);
                } else {
                    register.put(name, value);
                }
            }

            public String toString() {
                return "SetVariable(" + name + " to " + value + ")";
            }
        };
    }

    private String parseVariableValue(Line input) {
        String potentialValue = input.toString().substring(input.indexOf("=") + 1, input.length());
        Line potentialValueLine = Line.create(potentialValue, -1);
        while (potentialValueLine.getAt(0) == ' ') {
            potentialValueLine.remove(0);
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < potentialValueLine.length() && potentialValueLine.getAt(i) != ' '; ++i) {
            result.append(potentialValueLine.getAt(i));
        }
        potentialValueLine.clear();
        return result.toString();
    }

    private String parseVariableName(Line input) {
        int startingIndex;
        StringBuilder line = new StringBuilder(input.toString());
        String lineString = line.toString();
        int equalsIndex = lineString.indexOf("=");
        String potentialName = line.substring(0, equalsIndex);
        Line potentialNameLine = Line.create(potentialName, -1);
        while (potentialNameLine.getAt(equalsIndex - 1) == ' ') {
            potentialNameLine.remove(equalsIndex - 1);
            --equalsIndex;
        }
        StringBuilder result = new StringBuilder();
        for (int i = startingIndex = equalsIndex - 1; i >= 0 && potentialNameLine.getAt(i) != ' '; --i) {
            result.append(potentialNameLine.getAt(i));
        }
        result.reverse();
        potentialNameLine.clear();
        return result.toString();
    }
}

