/*
 * Decompiled with CFR 0.152.
 */
package com.github.thorbenkuck.scripting;

import com.github.thorbenkuck.scripting.Line;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;

class LineImpl
implements Line {
    private String content;
    private final int lineNumber;

    LineImpl(String content, int lineNumber) {
        this.content = content;
        this.lineNumber = lineNumber;
    }

    @Override
    public void remove(int index) {
        StringBuilder stringBuilder = new StringBuilder(this.content);
        stringBuilder.deleteCharAt(index);
        this.content = stringBuilder.toString();
    }

    @Override
    public void remove(int from, int to) {
        for (int index = from; index <= to; ++index) {
            this.remove(0);
        }
    }

    @Override
    public void changeTo(String newLine) {
        this.content = newLine;
    }

    @Override
    public void trimLeadingWhiteSpaces() {
        while (this.content.startsWith(" ")) {
            this.content = this.content.replace(" ", "");
        }
    }

    @Override
    public void trimWhiteSpaces() {
        while (this.content.contains(" ")) {
            this.content = this.content.replace(" ", "");
        }
    }

    @Override
    public boolean matches(String regex) {
        return this.content.matches(regex);
    }

    @Override
    public boolean contains(String s) {
        return this.content.contains(s);
    }

    @Override
    public boolean startsWith(String s) {
        return this.content.startsWith(s);
    }

    @Override
    public boolean isBlank() {
        for (char character : this.content.toCharArray()) {
            if (character == ' ') continue;
            return false;
        }
        return true;
    }

    @Override
    public String toReadable() {
        return "(" + this.lineNumber + ") " + this.toString();
    }

    public String toString() {
        return this.content;
    }

    @Override
    public Line subpart(int begin) {
        return this.subpart(begin, this.content.length());
    }

    @Override
    public Line subpart(int begin, int end) {
        return new LineImpl(this.content.substring(begin, end), this.lineNumber);
    }

    @Override
    public int indexOf(String s) {
        return this.content.indexOf(s);
    }

    @Override
    public int lastIndexOf(String s) {
        return this.content.lastIndexOf(s);
    }

    @Override
    public String[] split(String regex) {
        return this.content.split(regex);
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public Line duplicate() {
        return new LineImpl(this.content, this.lineNumber);
    }

    @Override
    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    @Override
    public char getAt(int index) {
        return this.content.toCharArray()[index];
    }

    @Override
    public void replace(String oldString, String newString) {
        this.content = this.content.replace(oldString, newString);
    }

    @Override
    public int length() {
        return this.content.length();
    }

    @Override
    public boolean endsWith(String s) {
        return this.content.endsWith(s);
    }

    @Override
    public void removeLast() {
        this.remove(this.content.length() - 1);
    }

    @Override
    public int countCharInLine(char toCount) {
        int count = 0;
        for (int i = 0; i < this.content.length(); ++i) {
            if (this.content.charAt(i) != toCount) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<Character> iterator() {
        return new CharacterIterator(this.content.toCharArray());
    }

    private class CharacterIterator
    implements Iterator<Character> {
        private final Queue<Character> elements;
        private Character current;

        private CharacterIterator(Collection<Character> elements) {
            this.elements = new LinkedList<Character>(elements);
        }

        private CharacterIterator(char[] elements) {
            ArrayList<Character> ourList = new ArrayList<Character>();
            for (char currentChar : elements) {
                ourList.add(Character.valueOf(currentChar));
            }
            this.elements = new LinkedList<Character>(ourList);
        }

        @Override
        public boolean hasNext() {
            return this.elements.peek() != null;
        }

        @Override
        public Character next() {
            this.current = this.elements.poll();
            return this.current;
        }
    }
}

