/*
 * Decompiled with CFR 0.152.
 */
package com.github.thorbenkuck.scripting;

import com.github.thorbenkuck.scripting.Function;
import com.github.thorbenkuck.scripting.Line;
import com.github.thorbenkuck.scripting.LineProvider;
import com.github.thorbenkuck.scripting.Parser;
import com.github.thorbenkuck.scripting.Register;
import com.github.thorbenkuck.scripting.Rule;
import com.github.thorbenkuck.scripting.Script;
import com.github.thorbenkuck.scripting.ScriptImpl;
import com.github.thorbenkuck.scripting.Utility;
import com.github.thorbenkuck.scripting.exceptions.ParsingFailedException;
import com.github.thorbenkuck.scripting.packages.Package;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;

class ParserImpl
implements Parser {
    private final List<Rule> rules = new ArrayList<Rule>();
    private final Map<String, Function> functions = new HashMap<String, Function>();
    private final Lock functionsLock = new ReentrantLock(true);
    private final Lock ruleLock = new ReentrantLock(true);
    private final Register internalVariables = Register.create();
    private final AtomicInteger linePointer = new AtomicInteger();
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final Queue<Consumer<Register>> created = new LinkedList<Consumer<Register>>();
    private final AtomicBoolean linePointerFreeze = new AtomicBoolean(false);
    private static int currentFunctionCount = 0;
    private String errorMessage;

    ParserImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextFunctionCount() {
        ParserImpl parserImpl = this;
        synchronized (parserImpl) {
            return currentFunctionCount++;
        }
    }

    private boolean applyRules(Line line, Queue<Consumer<Register>> created) {
        boolean success = false;
        for (Rule rule : this.rules) {
            Consumer<Register> consumer;
            if (!rule.applies(line) || (consumer = rule.apply(line, this, this.linePointer.get())) == null) continue;
            created.add(consumer);
            success = true;
        }
        return success;
    }

    private String sliceFunctionNameAndParametrise(Line line) {
        StringBuilder functionName = new StringBuilder();
        line.trimLeadingWhiteSpaces();
        while (!line.startsWith(" ") && !line.startsWith("(")) {
            functionName.append(line.toString().toCharArray()[0]);
            line.remove(0);
        }
        line.trimLeadingWhiteSpaces();
        line.remove(0);
        line.removeLast();
        return functionName.toString();
    }

    private void applyFunctions(Line line) {
        Line functionComplete = this.sliceMostOuterFunction(line);
        Line reference = functionComplete.duplicate();
        String functionName = this.sliceFunctionNameAndParametrise(functionComplete);
        Line value = functionComplete.duplicate();
        String[] args = this.getParameter(value);
        String address = this.evaluateFunction(functionName, args, line.getLineNumber());
        line.replace(reference.toString(), address);
    }

    private Line sliceMostOuterFunction(Line line) {
        int lastIndex = line.lastIndexOf(")") + 1;
        int beginOfFunction = line.indexOf("(");
        while (line.getAt(beginOfFunction - 1) == ' ') {
            line.remove(beginOfFunction - 1);
        }
        while (beginOfFunction != 0 && line.getAt(beginOfFunction - 1) != ' ') {
            --beginOfFunction;
        }
        return line.subpart(beginOfFunction, lastIndex);
    }

    private String evaluateFunction(String functionName, String[] args, int lineNumber) {
        Function function = this.functions.get(functionName);
        if (function == null) {
            return "void";
        }
        function.onParse(args, this, lineNumber);
        String registerAddress = "F#" + functionName + this.getNextFunctionCount();
        this.created.add(Utility.wrapFunction(function, registerAddress, args));
        return registerAddress;
    }

    private String[] getParameter(Line args) {
        if (args.startsWith("(")) {
            args.remove(0);
            if (args.endsWith(")")) {
                args.remove(args.length() - 1);
            }
        }
        ArrayList<String> results = new ArrayList<String>();
        if (this.isFunction(args)) {
            results.add(this.evaluateFunction(this.sliceFunctionNameAndParametrise(args), this.getParameter(args), args.getLineNumber()));
        } else {
            String[] parameters;
            for (String parameter : parameters = this.getArgumentsOfFunction(args)) {
                Line newLine = Line.create(parameter, args.getLineNumber());
                if (this.isFunction(newLine)) {
                    results.add(this.evaluateFunction(this.sliceFunctionNameAndParametrise(newLine), this.getParameter(newLine), args.getLineNumber()));
                    continue;
                }
                results.add(parameter);
            }
        }
        return results.toArray(new String[results.size()]);
    }

    private String spliceNextFunction(Line line) {
        int currentBracketStand = 0;
        StringBuilder currentArgument = new StringBuilder();
        Iterator iterator = line.iterator();
        while (iterator.hasNext()) {
            char character = ((Character)iterator.next()).charValue();
            if (character == '(') {
                ++currentBracketStand;
                currentArgument.append(character);
                continue;
            }
            if (character == ')') {
                currentArgument.append(character);
                if (--currentBracketStand != 0) continue;
                line.remove(0, currentArgument.length() - 1);
                return currentArgument.toString();
            }
            currentArgument.append(character);
        }
        return "NULL";
    }

    private String[] spliceAllFunction(Line line) {
        ArrayList<String> results = new ArrayList<String>();
        while (this.containsFunction(line.toString())) {
            results.add(this.spliceNextFunction(line));
        }
        return results.toArray(new String[results.size()]);
    }

    private String[] getArgumentsOfFunction(Line line) {
        ArrayList<String> results = new ArrayList<String>();
        StringBuilder currentArgument = new StringBuilder();
        while (!line.isEmpty()) {
            char character;
            if (this.startsWithFunction(line.toString())) {
                results.add(this.spliceNextFunction(line));
                continue;
            }
            if (line.startsWith(",") || line.startsWith(" ")) {
                line.remove(0);
                continue;
            }
            Iterator iterator = line.iterator();
            while (iterator.hasNext() && (character = ((Character)iterator.next()).charValue()) != ',') {
                currentArgument.append(character);
            }
            results.add(currentArgument.toString());
            line.remove(0, currentArgument.length() - 1);
            currentArgument = new StringBuilder();
        }
        return results.toArray(new String[results.size()]);
    }

    private boolean isFunction(Line line) {
        if (!line.matches("[a-zA-Z0-9_][a-zA-Z0-9_-]+\\(.*")) {
            return false;
        }
        boolean foundLastClosingBracket = false;
        int bracketCount = 0;
        Iterator iterator = line.iterator();
        while (iterator.hasNext()) {
            char currentChar = ((Character)iterator.next()).charValue();
            if (currentChar == ')') {
                if (--bracketCount != 0) continue;
                foundLastClosingBracket = true;
                continue;
            }
            if (currentChar == '(') {
                if (foundLastClosingBracket) {
                    return false;
                }
                ++bracketCount;
                continue;
            }
            if (!foundLastClosingBracket || currentChar == ' ') continue;
            return false;
        }
        return true;
    }

    private boolean startsWithFunction(String toCheck) {
        return toCheck.matches("[a-zA-Z0-9_][a-zA-Z0-9_-]+[ ]*\\(.*\\).*");
    }

    private boolean containsFunction(String toCheck) {
        return toCheck.matches(".*[a-zA-Z0-9_][a-zA-Z0-9_-]+[ ]*\\(.*\\).*");
    }

    private void preEvaluation(Collection<Line> lines) {
        for (Line line : lines) {
            int relation = this.relationOpenClosed(line);
            if (relation > 0) {
                this.error("Missing closing bracket(s): " + relation, line.getLineNumber());
                continue;
            }
            if (relation >= 0) continue;
            this.error("To many closing bracket(s): " + -relation, line.getLineNumber());
        }
    }

    private int relationOpenClosed(Line line) {
        return line.countCharInLine('(') - line.countCharInLine(')');
    }

    private void checkForError(List<Line> lines) throws ParsingFailedException {
        if (!this.running.get()) {
            throw new ParsingFailedException("Stopped while parsing Script!\n" + this.errorMessage + "\n> (" + this.linePointer.get() + "): " + lines.get(this.linePointer.get()));
        }
    }

    private int getCurrentLine() {
        if (this.linePointerFreeze.get()) {
            this.linePointerFreeze.set(false);
            return this.linePointer.get();
        }
        return this.linePointer.incrementAndGet();
    }

    @Override
    public synchronized Script parse(String string) throws ParsingFailedException {
        return this.parse(LineProvider.ofString(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Script parse(LineProvider lineProvider) throws ParsingFailedException {
        ScriptImpl result;
        this.running.set(true);
        this.linePointerFreeze.set(false);
        List<Line> lines = lineProvider.provide();
        this.preEvaluation(lines);
        this.checkForError(lines);
        this.linePointer.set(0);
        try {
            this.functionsLock.lock();
            this.ruleLock.lock();
            int currentLine = 0;
            while (currentLine < lines.size()) {
                Line line = lines.get(currentLine).duplicate();
                boolean workedOn = true;
                while (!line.isEmpty() && workedOn) {
                    workedOn = false;
                    try {
                        if (this.containsFunction(line.toString())) {
                            this.applyFunctions(line);
                            workedOn = true;
                        }
                        this.applyRules(line, this.created);
                    }
                    catch (Exception e) {
                        throw new ParsingFailedException("Encountered Exception while parsing!", e);
                    }
                }
                this.checkForError(lines);
                currentLine = this.getCurrentLine();
            }
            this.checkForError(lines);
        }
        finally {
            this.functionsLock.unlock();
            this.ruleLock.unlock();
            ParserImpl parserImpl = this;
            synchronized (parserImpl) {
                this.internalVariables.clear();
                result = new ScriptImpl(this.created);
                this.created.clear();
                currentFunctionCount = 0;
                this.linePointer.set(0);
            }
            this.running.set(false);
        }
        return result;
    }

    @Override
    public void freezeLinePointer() {
        this.linePointerFreeze.set(true);
    }

    @Override
    public void setLinePointer(int to) {
        this.linePointer.set(to);
        this.linePointerFreeze.set(true);
    }

    @Override
    public void setInternalVariable(String key, String value) {
        this.internalVariables.put(key, value);
    }

    @Override
    public String getInternalVariable(String key) {
        return this.internalVariables.get(key);
    }

    @Override
    public void error(String message, int lineNumber) {
        this.running.set(false);
        this.linePointer.set(lineNumber);
        this.errorMessage = "error " + message;
    }

    @Override
    public void error(String message) {
        this.error(message, this.linePointer.get());
    }

    @Override
    public void clearInternalVariable(String name) {
        this.internalVariables.remove(name);
    }

    @Override
    public void insert(Consumer<Register> consumer) {
        this.created.add(consumer);
    }

    @Override
    public void deleteInternalVariable(String name) {
        this.internalVariables.remove(name);
    }

    @Override
    public void add(Function function) {
        try {
            this.functionsLock.lock();
            this.functions.put(function.getFunctionName(), function);
        }
        finally {
            this.functionsLock.unlock();
        }
    }

    @Override
    public void add(Rule rule) {
        try {
            this.ruleLock.lock();
            this.rules.add(rule);
        }
        finally {
            this.ruleLock.unlock();
        }
    }

    @Override
    public void add(Package newPackage) {
        for (Rule rule : newPackage.getRules()) {
            this.add(rule);
        }
        for (Function function : newPackage.getFunctions()) {
            this.add(function);
        }
    }

    public String toString() {
        return "Parser{rules=" + this.rules + ", internalVariables=" + this.internalVariables + ", linePointer=" + this.linePointer + ", running=" + this.running + '}';
    }
}

