/*
 * Decompiled with CFR 0.152.
 */
package com.github.thorbenkuck.scripting.math;

import com.github.thorbenkuck.scripting.Line;
import com.github.thorbenkuck.scripting.Parser;
import com.github.thorbenkuck.scripting.Register;
import com.github.thorbenkuck.scripting.Rule;
import com.github.thorbenkuck.scripting.Utility;
import com.github.thorbenkuck.scripting.exceptions.ExecutionRuntimeException;
import java.util.function.Consumer;

public class DecrementRule
implements Rule {
    @Override
    public boolean applies(Line line) {
        return line.matches("\\-\\-[a-zA-Z0-9]");
    }

    @Override
    public Consumer<Register> apply(Line line, Parser parser, int linePointer) {
        final String reference = line.subpart(2, line.length()).toString();
        return new Consumer<Register>(){

            @Override
            public void accept(Register register) {
                if (register.get(reference).equals("null")) {
                    throw new ExecutionRuntimeException("Decrement is only applicable to variables");
                }
                String currentValue = register.get(reference);
                if (Utility.isInteger(currentValue)) {
                    int intValue = Utility.toInt(currentValue);
                    register.put(reference, String.valueOf(--intValue));
                } else if (Utility.isDouble(currentValue)) {
                    double value = Utility.toDouble(currentValue);
                    register.put(reference, String.valueOf(value -= 1.0));
                } else {
                    throw new ExecutionRuntimeException("Unknown type of " + currentValue);
                }
            }

            public String toString() {
                return "decrease " + reference;
            }
        };
    }
}

