/*
 * Decompiled with CFR 0.152.
 */
package com.github.thorbenkuck.scripting;

import com.github.thorbenkuck.scripting.Register;
import com.github.thorbenkuck.scripting.Script;
import com.github.thorbenkuck.scripting.ScriptElement;
import com.github.thorbenkuck.scripting.exceptions.ExecutionFailedException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;

class ScriptImpl
implements Script {
    private final Queue<ScriptElement<Register>> core = new LinkedList<ScriptElement<Register>>();
    private final Map<String, String> initialRegisterValues = new HashMap<String, String>();
    private final LocalDateTime timeOfCreation = LocalDateTime.now();
    private String name = "Script(" + this.timeOfCreation + ")";

    ScriptImpl(Queue<ScriptElement<Register>> core) {
        this.core.addAll(core);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInstruction(ScriptElement<Register> instruction) {
        Queue<ScriptElement<Register>> queue = this.core;
        synchronized (queue) {
            this.core.add(instruction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Map<String, String> registerValues) throws ExecutionFailedException {
        Map<String, String> map = this.initialRegisterValues;
        synchronized (map) {
            this.initialRegisterValues.putAll(registerValues);
        }
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws ExecutionFailedException {
        LinkedList<ScriptElement<Register>> copy;
        Register register = Register.create();
        Map<String, String> map = this.initialRegisterValues;
        synchronized (map) {
            register.adapt(this.initialRegisterValues);
        }
        Queue<ScriptElement<Register>> queue = this.core;
        synchronized (queue) {
            copy = new LinkedList<ScriptElement<Register>>(this.core);
        }
        try {
            while (copy.peek() != null) {
                ScriptElement consumer = (ScriptElement)copy.poll();
                consumer.accept(register);
            }
        }
        catch (Exception e) {
            throw new ExecutionFailedException(e);
        }
        finally {
            register.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        ArrayList<ScriptElement<Register>> consumerCopy;
        int lineCounter = 0;
        StringBuilder result = new StringBuilder(this.getName());
        result.append("------ SCRIPT_START").append(System.lineSeparator());
        Queue<ScriptElement<Register>> queue = this.core;
        synchronized (queue) {
            consumerCopy = new ArrayList<ScriptElement<Register>>(this.core);
        }
        for (ScriptElement scriptElement : consumerCopy) {
            result.append("(").append(lineCounter++).append("): ").append(scriptElement).append(System.lineSeparator());
        }
        result.append("------ SCRIPT_END");
        return result.toString();
    }

    @Override
    public void setValue(String key, String value) {
        this.initialRegisterValues.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int countInstructions() {
        Queue<ScriptElement<Register>> queue = this.core;
        synchronized (queue) {
            return this.core.size();
        }
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public LocalDateTime getTimeOfCreation() {
        return this.timeOfCreation;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

