/*
 * Decompiled with CFR 0.152.
 */
package com.github.thorbenkuck.scripting.io;

import com.github.thorbenkuck.scripting.Function;
import com.github.thorbenkuck.scripting.Register;
import com.github.thorbenkuck.scripting.io.IOUtils;
import java.io.PrintStream;

public class PrintLineFunction
implements Function {
    private final PrintStream out;

    public PrintLineFunction() {
        this(System.out);
    }

    public PrintLineFunction(PrintStream out) {
        this.out = out;
    }

    @Override
    public String calculate(String[] args, Register register) {
        if (this.out == null) {
            return "void";
        }
        if (args.length == 0) {
            IOUtils.printAccordingToType("", register, this.out, "\n");
            return "void";
        }
        for (String name : args) {
            IOUtils.printAccordingToType(name, register, this.out);
        }
        IOUtils.printAccordingToType("", register, this.out, "\n");
        return "void";
    }

    @Override
    public String getFunctionName() {
        return "println";
    }

    @Override
    public String hintReturnValue() {
        return "void";
    }
}

