/*
 * Decompiled with CFR 0.152.
 */
package prettify.example;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import prettify.PrettifyParser;
import prettify.theme.ThemeDefault;
import syntaxhighlight.SyntaxHighlighter;

public class Example {
    private static final Logger LOG = Logger.getLogger(Example.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readResourceFile(String path) throws IOException {
        if (path == null) {
            throw new NullPointerException("argument 'path' cannot be null");
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        InputStream in = null;
        try {
            in = Example.class.getResourceAsStream(path);
            if (in == null) {
                throw new IOException("Resources not found: " + path);
            }
            int byteRead = 0;
            byte[] b = new byte[8096];
            while ((byteRead = in.read(b)) != -1) {
                bout.write(b, 0, byteRead);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bout.toByteArray();
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            LOG.log(Level.INFO, "Failed to set system look and feel.", ex);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                PrettifyParser parser = new PrettifyParser();
                SyntaxHighlighter highlighter = new SyntaxHighlighter(parser, new ThemeDefault());
                highlighter.setFirstLine(10);
                highlighter.setHighlightedLineList(Arrays.asList(13, 27, 28, 38, 42, 43, 53));
                try {
                    highlighter.setContent(new String(Example.readResourceFile("example.html")));
                }
                catch (IOException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
                long end = System.currentTimeMillis();
                System.out.println("time elapsed: " + (end - start) + "ms");
                JFrame frame = new JFrame();
                frame.setDefaultCloseOperation(3);
                frame.setContentPane(highlighter);
                frame.setLocationByPlatform(true);
                frame.pack();
                frame.setVisible(true);
            }
        });
    }
}

