/*
 * Decompiled with CFR 0.152.
 */
package syntaxhighlight;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.IconView;
import javax.swing.text.JTextComponent;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import syntaxhighlight.ParseResult;
import syntaxhighlight.Theme;

public class SyntaxHighlighterPane
extends JTextPane {
    private static final Logger LOG = Logger.getLogger(SyntaxHighlighterPane.class.getName());
    private static final long serialVersionUID = 1L;
    private int lineNumberOffset;
    private Color highlightedBackground;
    private boolean highlightWhenMouseOver;
    protected final List<Integer> highlightedLineList;
    protected Highlighter.HighlightPainter highlightPainter;
    protected Theme theme;
    protected Map<String, List<ParseResult>> styleList;
    protected int mouseOnLine;

    public SyntaxHighlighterPane() {
        this.setEditable(false);
        this.setEditorKit(new StyledEditorKit(){
            private static final long serialVersionUID = 1L;

            @Override
            public ViewFactory getViewFactory() {
                return new ViewFactory(){

                    @Override
                    public View create(Element elem) {
                        String kind = elem.getName();
                        if (kind != null) {
                            if (kind.equals("content")) {
                                return new LabelView(elem){

                                    @Override
                                    public int getBreakWeight(int axis, float pos, float len) {
                                        return 0;
                                    }
                                };
                            }
                            if (kind.equals("paragraph")) {
                                return new ParagraphView(elem){

                                    @Override
                                    public int getBreakWeight(int axis, float pos, float len) {
                                        return 0;
                                    }
                                };
                            }
                            if (kind.equals("section")) {
                                return new BoxView(elem, 1);
                            }
                            if (kind.equals("component")) {
                                return new ComponentView(elem){

                                    @Override
                                    public int getBreakWeight(int axis, float pos, float len) {
                                        return 0;
                                    }
                                };
                            }
                            if (kind.equals("icon")) {
                                return new IconView(elem);
                            }
                        }
                        return new LabelView(elem){

                            @Override
                            public int getBreakWeight(int axis, float pos, float len) {
                                return 0;
                            }
                        };
                    }
                };
            }
        });
        this.lineNumberOffset = 0;
        this.highlightedBackground = Color.black;
        this.highlightWhenMouseOver = true;
        this.highlightedLineList = new ArrayList<Integer>();
        this.highlightPainter = new Highlighter.HighlightPainter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paint(Graphics g, int p0, int p1, Shape bounds, JTextComponent c) {
                int _y;
                if (c.getParent() == null) {
                    return;
                }
                int startY = Math.abs(c.getY());
                int endY = startY + c.getParent().getHeight();
                FontMetrics textPaneFontMetrics = g.getFontMetrics(SyntaxHighlighterPane.this.getFont());
                int textPaneFontHeight = textPaneFontMetrics.getHeight();
                int largerestLineNumber = c.getDocument().getDefaultRootElement().getElementCount();
                g.setColor(SyntaxHighlighterPane.this.highlightedBackground);
                List<Integer> list = SyntaxHighlighterPane.this.highlightedLineList;
                synchronized (list) {
                    for (Integer lineNumber : SyntaxHighlighterPane.this.highlightedLineList) {
                        int _y2;
                        if (lineNumber > largerestLineNumber + SyntaxHighlighterPane.this.lineNumberOffset || (_y2 = Math.max(0, textPaneFontHeight * (lineNumber - SyntaxHighlighterPane.this.lineNumberOffset - 1))) > endY || _y2 + textPaneFontHeight < startY) continue;
                        g.fillRect(0, _y2, c.getWidth(), textPaneFontHeight);
                    }
                }
                if (SyntaxHighlighterPane.this.mouseOnLine != -1 && SyntaxHighlighterPane.this.mouseOnLine <= largerestLineNumber + SyntaxHighlighterPane.this.lineNumberOffset && (_y = Math.max(0, textPaneFontHeight * (SyntaxHighlighterPane.this.mouseOnLine - SyntaxHighlighterPane.this.lineNumberOffset - 1))) < endY && _y + textPaneFontHeight > startY) {
                    g.fillRect(0, _y, c.getWidth(), textPaneFontHeight);
                }
            }
        };
        try {
            this.getHighlighter().addHighlight(0, 0, this.highlightPainter);
        }
        catch (BadLocationException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        this.mouseOnLine = -1;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                if (!SyntaxHighlighterPane.this.highlightWhenMouseOver) {
                    return;
                }
                SyntaxHighlighterPane.this.mouseOnLine = -1;
                SyntaxHighlighterPane.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                int lineNumber;
                if (!SyntaxHighlighterPane.this.highlightWhenMouseOver) {
                    return;
                }
                Element defaultRootElement = SyntaxHighlighterPane.this.getDocument().getDefaultRootElement();
                int documentOffsetStart = SyntaxHighlighterPane.this.viewToModel(e.getPoint());
                int n = lineNumber = documentOffsetStart == -1 ? -1 : defaultRootElement.getElementIndex(documentOffsetStart) + 1 + SyntaxHighlighterPane.this.lineNumberOffset;
                if (lineNumber == defaultRootElement.getElementCount()) {
                    try {
                        Rectangle rectangle = SyntaxHighlighterPane.this.modelToView(documentOffsetStart);
                        if (e.getY() > rectangle.y + rectangle.height) {
                            lineNumber = -1;
                        }
                    }
                    catch (BadLocationException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                }
                if (SyntaxHighlighterPane.this.mouseOnLine != lineNumber) {
                    SyntaxHighlighterPane.this.mouseOnLine = lineNumber;
                    SyntaxHighlighterPane.this.repaint();
                }
            }
        });
    }

    @Override
    public void setHighlighter(Highlighter highlighter) {
        if (this.highlightPainter != null) {
            this.getHighlighter().removeHighlight(this.highlightPainter);
            try {
                highlighter.addHighlight(0, 0, this.highlightPainter);
            }
            catch (BadLocationException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        }
        super.setHighlighter(highlighter);
    }

    public void setContent(String content) {
        String newContent = content == null ? "" : content;
        DefaultStyledDocument document = (DefaultStyledDocument)this.getDocument();
        try {
            document.remove(0, document.getLength());
            if (this.theme != null) {
                document.insertString(0, newContent, this.theme.getPlain().getAttributeSet());
            } else {
                document.insertString(0, newContent, new SimpleAttributeSet());
            }
        }
        catch (BadLocationException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        this.setCaretPosition(0);
        this.styleList = null;
    }

    public void setStyle(List<ParseResult> styleList) {
        if (styleList == null) {
            throw new NullPointerException("argumenst 'styleList' cannot be null");
        }
        this.styleList = new HashMap<String, List<ParseResult>>();
        for (ParseResult parseResult : styleList) {
            String styleKeysString = parseResult.getStyleKeysString();
            List<ParseResult> _styleList = this.styleList.get(styleKeysString);
            if (_styleList == null) {
                _styleList = new ArrayList<ParseResult>();
                this.styleList.put(styleKeysString, _styleList);
            }
            _styleList.add(parseResult);
        }
        this.applyStyle();
    }

    protected void applyStyle() {
        if (this.theme == null || this.styleList == null) {
            return;
        }
        DefaultStyledDocument document = (DefaultStyledDocument)this.getDocument();
        document.setCharacterAttributes(0, document.getLength(), this.theme.getPlain().getAttributeSet(), true);
        for (String key : this.styleList.keySet()) {
            List<ParseResult> posList = this.styleList.get(key);
            SimpleAttributeSet attributeSet = this.theme.getStyle(key).getAttributeSet();
            for (ParseResult pos : posList) {
                document.setCharacterAttributes(pos.getOffset(), pos.getLength(), attributeSet, true);
            }
        }
        this.repaint();
    }

    public Theme getTheme() {
        return this.theme;
    }

    public void setTheme(Theme theme) {
        if (theme == null) {
            throw new NullPointerException("argument 'theme' cannot be null");
        }
        this.theme = theme;
        this.setFont(theme.getFont());
        this.setBackground(theme.getBackground());
        this.setHighlightedBackground(theme.getHighlightedBackground());
        if (this.styleList != null) {
            this.applyStyle();
        }
    }

    public int getLineNumberOffset() {
        return this.lineNumberOffset;
    }

    public void setLineNumberOffset(int offset) {
        this.lineNumberOffset = Math.max(0, offset);
        this.repaint();
    }

    public Color getHighlightedBackground() {
        return this.highlightedBackground;
    }

    public void setHighlightedBackground(Color highlightedBackground) {
        if (highlightedBackground == null) {
            throw new NullPointerException("argument 'highlightedBackground' cannot be null");
        }
        this.highlightedBackground = highlightedBackground;
        this.repaint();
    }

    public boolean isHighlightOnMouseOver() {
        return this.highlightWhenMouseOver;
    }

    public void setHighlightOnMouseOver(boolean highlightWhenMouseOver) {
        this.highlightWhenMouseOver = highlightWhenMouseOver;
        if (!highlightWhenMouseOver) {
            this.mouseOnLine = -1;
        }
        this.repaint();
    }

    public List<Integer> getHighlightedLineList() {
        return new ArrayList<Integer>(this.highlightedLineList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHighlightedLineList(List<Integer> highlightedLineList) {
        if (highlightedLineList == null) {
            throw new NullPointerException("argument 'highlightedLineList' cannot be null");
        }
        List<Integer> list = this.highlightedLineList;
        synchronized (list) {
            this.highlightedLineList.clear();
            this.highlightedLineList.addAll(highlightedLineList);
        }
        this.repaint();
    }

    public void addHighlightedLine(int lineNumber) {
        this.highlightedLineList.add(lineNumber);
        this.repaint();
    }

    protected static Font setFont(Font font, boolean bold, boolean italic) {
        if (font == null) {
            return null;
        }
        if ((font.getStyle() & 1) != 0) {
            if (!bold) {
                return font.deriveFont(font.getStyle() ^ 1);
            }
        } else if (bold) {
            return font.deriveFont(font.getStyle() | 1);
        }
        if ((font.getStyle() & 2) != 0) {
            if (!italic) {
                return font.deriveFont(font.getStyle() ^ 2);
            }
        } else if (italic) {
            return font.deriveFont(font.getStyle() | 2);
        }
        return font;
    }
}

