/*
 * Decompiled with CFR 0.152.
 */
package com.github.twalcari.prettify;

import com.github.twalcari.prettify.RTSyntaxHighlighter;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.concurrent.Task;
import org.fxmisc.richtext.StyleClassedTextArea;
import org.reactfx.EventStream;
import org.reactfx.util.Try;
import prettify.PrettifyParser;
import syntaxhighlight.ParseResult;

public class RTAsyncSyntaxHighlighter {
    private static final PrettifyParser prettifyParser = new PrettifyParser();
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private final StyleClassedTextArea textArea;
    private final String inputType;

    public RTAsyncSyntaxHighlighter(StyleClassedTextArea textArea, String inputType) {
        this.textArea = textArea;
        this.inputType = inputType;
        textArea.getStylesheets().add((Object)RTSyntaxHighlighter.class.getResource("code-highlighter.css").toExternalForm());
        EventStream textChanges = textArea.plainTextChanges();
        textChanges.successionEnds(Duration.ofMillis(100L)).supplyTask(this::computeHighlightingAsync).awaitLatest(textChanges).map(Try::get).subscribe(this::applyHighlighting);
        try {
            this.applyHighlighting((List)this.computeHighlightingAsync().get());
        }
        catch (InterruptedException | ExecutionException exception) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void applyHighlighting(List<ParseResult> parseResults) {
        for (ParseResult parseResult : parseResults) {
            this.textArea.setStyle(parseResult.getOffset(), parseResult.getOffset() + parseResult.getLength(), parseResult.getStyleKeys());
        }
    }

    private Task<List<ParseResult>> computeHighlightingAsync() {
        final String text = this.textArea.getText();
        Task<List<ParseResult>> task = new Task<List<ParseResult>>(){

            protected List<ParseResult> call() throws Exception {
                return prettifyParser.parse(RTAsyncSyntaxHighlighter.this.inputType, text);
            }
        };
        this.executor.execute((Runnable)task);
        return task;
    }

    public void stop() {
        this.executor.shutdown();
    }
}

