/*
 * Decompiled with CFR 0.152.
 */
package com.github.twalcari.prettify;

import java.util.List;
import javafx.application.Platform;
import org.fxmisc.richtext.StyleClassedTextArea;
import prettify.PrettifyParser;
import syntaxhighlight.ParseResult;

public class RTSyntaxHighlighter {
    private static final PrettifyParser prettifyParser = new PrettifyParser();
    private final StyleClassedTextArea textArea;
    private final String inputType;

    public RTSyntaxHighlighter(StyleClassedTextArea textArea, String inputType) {
        this.textArea = textArea;
        this.inputType = inputType;
        textArea.getStylesheets().add((Object)RTSyntaxHighlighter.class.getResource("code-highlighter.css").toExternalForm());
        textArea.textProperty().addListener((obs, oldText, newText) -> Platform.runLater(() -> this.computeAndApplyHighlighting((String)newText)));
        try {
            this.computeAndApplyHighlighting(textArea.getText());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void computeAndApplyHighlighting(String text) {
        List<ParseResult> parseResults = prettifyParser.parse(this.inputType, text);
        for (ParseResult parseResult : parseResults) {
            this.textArea.setStyle(parseResult.getOffset(), parseResult.getOffset() + parseResult.getLength(), parseResult.getStyleKeys());
        }
    }
}

