/*
 * Decompiled with CFR 0.152.
 */
package syntaxhighlight;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;

public class JTextComponentRowHeader
extends JPanel {
    private static final Logger LOG = Logger.getLogger(JTextComponentRowHeader.class.getName());
    private static final long serialVersionUID = 1L;
    protected Object textAntiAliasing = RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT;
    protected Color borderColor = new Color(184, 184, 184);
    protected Color highlightedColor = Color.black;
    protected int paddingLeft = 7;
    protected int paddingRight = 2;
    protected int borderWidth = 1;
    protected JScrollPane scrollPane;
    protected JTextComponent textComponent;
    protected Document document;
    protected DocumentListener documentListener;
    protected int panelWidth;
    protected int largestRowNumber;
    protected int textComponentHeight;
    protected int lineNumberOffset;
    protected final List<Integer> highlightedLineList;
    protected boolean listenToDocumentUpdate;

    public JTextComponentRowHeader(JScrollPane scrollPane, JTextComponent textComponent) {
        if (scrollPane == null) {
            throw new NullPointerException("argument 'scrollPane' cannot be null");
        }
        if (textComponent == null) {
            throw new NullPointerException("argument 'textComponent' cannot be null");
        }
        this.setFont(new Font("Verdana", 0, 10));
        this.setForeground(Color.black);
        this.setBackground(new Color(233, 232, 226));
        this.scrollPane = scrollPane;
        this.textComponent = textComponent;
        this.panelWidth = 0;
        this.largestRowNumber = 1;
        this.textComponentHeight = 0;
        this.lineNumberOffset = 0;
        this.highlightedLineList = Collections.synchronizedList(new ArrayList());
        this.listenToDocumentUpdate = true;
        this.document = textComponent.getDocument();
        this.documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.handleEvent(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.handleEvent(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.handleEvent(e);
            }

            public void handleEvent(DocumentEvent e) {
                if (!JTextComponentRowHeader.this.listenToDocumentUpdate) {
                    return;
                }
                Document _document = e.getDocument();
                if (JTextComponentRowHeader.this.document == _document) {
                    JTextComponentRowHeader.this.checkPanelSize();
                } else {
                    _document.removeDocumentListener(this);
                }
            }
        };
        this.document.addDocumentListener(this.documentListener);
        this.checkPanelSize();
    }

    protected void validateTextComponentDocument() {
        Document _currentDocument = this.textComponent.getDocument();
        if (this.document != _currentDocument) {
            this.document.removeDocumentListener(this.documentListener);
            this.document = _currentDocument;
            _currentDocument.addDocumentListener(this.documentListener);
        }
    }

    public void checkPanelSize() {
        this.validateTextComponentDocument();
        int _largestRowNumber = this.document.getDefaultRootElement().getElementCount() + this.lineNumberOffset;
        int _panelWidth = this.getFontMetrics(this.getFont()).stringWidth(Integer.toString(_largestRowNumber)) + this.paddingLeft + this.paddingRight;
        if (this.panelWidth != _panelWidth || this.largestRowNumber != _largestRowNumber) {
            this.panelWidth = _panelWidth;
            this.largestRowNumber = _largestRowNumber;
            this.updatePanelSize();
        }
    }

    protected void updatePanelSize() {
        Container parent = this.getParent();
        if (parent != null) {
            parent.doLayout();
            this.scrollPane.doLayout();
            parent.repaint();
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
    }

    @Override
    public void setForeground(Color foreground) {
        super.setForeground(foreground);
    }

    @Override
    public void setBackground(Color background) {
        super.setBackground(background);
    }

    @Override
    public Dimension getPreferredSize() {
        this.textComponentHeight = this.textComponent.getPreferredSize().height;
        return new Dimension(this.panelWidth, this.textComponentHeight);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Dimension textComponentPreferredSize = this.textComponent.getPreferredSize();
        if (this.textComponentHeight != textComponentPreferredSize.height) {
            this.textComponentHeight = textComponentPreferredSize.height;
            this.updatePanelSize();
        }
        JViewport viewport = this.scrollPane.getViewport();
        Point viewPosition = viewport.getViewPosition();
        Dimension viewportSize = viewport.getSize();
        this.validateTextComponentDocument();
        Element defaultRootElement = this.document.getDefaultRootElement();
        FontMetrics fontMetrics = g.getFontMetrics(this.getFont());
        int fontHeight = fontMetrics.getHeight();
        int fontAscent = fontMetrics.getAscent();
        int fontLeading = fontMetrics.getLeading();
        FontMetrics textPaneFontMetrics = g.getFontMetrics(this.textComponent.getFont());
        int textPaneFontHeight = textPaneFontMetrics.getHeight();
        int documentOffsetStart = this.textComponent.viewToModel(viewPosition);
        int documentOffsetEnd = this.textComponent.viewToModel(new Point(viewPosition.x + viewportSize.width, viewPosition.y + viewportSize.height));
        int startLine = defaultRootElement.getElementIndex(documentOffsetStart) + 1 + this.lineNumberOffset;
        int endLine = defaultRootElement.getElementIndex(documentOffsetEnd) + 1 + this.lineNumberOffset;
        g.setColor(this.borderColor);
        g.fillRect(this.panelWidth - this.borderWidth, viewPosition.y, this.borderWidth, viewportSize.height);
        int startY = -1;
        int baselineOffset = -1;
        try {
            startY = this.textComponent.modelToView((int)documentOffsetStart).y;
            baselineOffset = textPaneFontHeight / 2 + fontAscent - fontHeight / 2 + fontLeading;
        }
        catch (BadLocationException ex) {
            LOG.log(Level.WARNING, null, ex);
            return;
        }
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.textAntiAliasing);
        Color foregroundColor = this.getForeground();
        g.setColor(foregroundColor);
        g.setFont(this.getFont());
        int y = startY + baselineOffset;
        for (int i = startLine; i <= endLine; ++i) {
            boolean highlighted = false;
            if (this.highlightedLineList.indexOf(i) != -1) {
                g.setColor(this.borderColor);
                g.fillRect(0, y - baselineOffset, this.panelWidth - this.borderWidth, textPaneFontHeight);
                g.setColor(this.highlightedColor);
                highlighted = true;
            }
            String lineNumberString = Integer.toString(i);
            int lineNumberStringWidth = fontMetrics.stringWidth(lineNumberString);
            g.drawString(lineNumberString, this.panelWidth - lineNumberStringWidth - this.paddingRight, y);
            if (highlighted) {
                g.setColor(foregroundColor);
            }
            y += textPaneFontHeight;
        }
    }

    public Object getTextAntiAliasing() {
        return this.textAntiAliasing;
    }

    public void setTextAntiAliasing(Object textAntiAliasing) {
        if (textAntiAliasing == null) {
            throw new NullPointerException("argument 'textAntiAliasing' cannot be null");
        }
        this.textAntiAliasing = textAntiAliasing;
        this.repaint();
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        if (borderColor == null) {
            throw new NullPointerException("argument 'borderColor' cannot be null");
        }
        this.borderColor = borderColor;
        this.repaint();
    }

    public Color getHighlightedColor() {
        return this.highlightedColor;
    }

    public void setHighlightedColor(Color highlightedColor) {
        if (highlightedColor == null) {
            throw new NullPointerException("argument 'highlightedColor' cannot be null");
        }
        this.highlightedColor = highlightedColor;
        this.repaint();
    }

    public int getPaddingLeft() {
        return this.paddingLeft;
    }

    public void setPaddingLeft(int paddingLeft) {
        this.paddingLeft = paddingLeft;
        this.checkPanelSize();
    }

    public int getPaddingRight() {
        return this.paddingRight;
    }

    public void setPaddingRight(int paddingRight) {
        this.paddingRight = paddingRight;
        this.checkPanelSize();
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
        this.repaint();
    }

    public int getLineNumberOffset() {
        return this.lineNumberOffset;
    }

    public void setLineNumberOffset(int offset) {
        this.lineNumberOffset = Math.max(this.lineNumberOffset, offset);
        this.checkPanelSize();
        this.repaint();
    }

    public List<Integer> getHighlightedLineList() {
        return new ArrayList<Integer>(this.highlightedLineList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHighlightedLineList(List<Integer> highlightedLineList) {
        List<Integer> list = this.highlightedLineList;
        synchronized (list) {
            this.highlightedLineList.clear();
            if (highlightedLineList != null) {
                this.highlightedLineList.addAll(highlightedLineList);
            }
        }
        this.repaint();
    }

    public boolean addHighlightedLine(int lineNumber) {
        boolean returnValue = this.highlightedLineList.add(lineNumber);
        this.repaint();
        return returnValue;
    }

    public void clearHighlightedLine() {
        this.highlightedLineList.clear();
    }

    public boolean isListenToDocumentUpdate() {
        return this.listenToDocumentUpdate;
    }

    public void setListenToDocumentUpdate(boolean listenToDocumentUpdate) {
        this.listenToDocumentUpdate = listenToDocumentUpdate;
    }
}

