/*
 * Decompiled with CFR 0.152.
 */
package prettify.parser;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import prettify.lang.Lang;
import prettify.lang.LangAppollo;
import prettify.lang.LangBasic;
import prettify.lang.LangClj;
import prettify.lang.LangCss;
import prettify.lang.LangDart;
import prettify.lang.LangErlang;
import prettify.lang.LangGo;
import prettify.lang.LangHs;
import prettify.lang.LangLisp;
import prettify.lang.LangLlvm;
import prettify.lang.LangLua;
import prettify.lang.LangMatlab;
import prettify.lang.LangMl;
import prettify.lang.LangMumps;
import prettify.lang.LangN;
import prettify.lang.LangPascal;
import prettify.lang.LangR;
import prettify.lang.LangRd;
import prettify.lang.LangScala;
import prettify.lang.LangSql;
import prettify.lang.LangTcl;
import prettify.lang.LangTex;
import prettify.lang.LangVb;
import prettify.lang.LangVhdl;
import prettify.lang.LangWiki;
import prettify.lang.LangXq;
import prettify.lang.LangYaml;
import prettify.parser.CombinePrefixPattern;
import prettify.parser.Job;
import prettify.parser.Util;

public class Prettify {
    private static final Logger LOG = Logger.getLogger(Prettify.class.getName());
    public static final String FLOW_CONTROL_KEYWORDS = "break,continue,do,else,for,if,return,while";
    public static final String C_KEYWORDS = "break,continue,do,else,for,if,return,while,auto,case,char,const,default,double,enum,extern,float,goto,inline,int,long,register,short,signed,sizeof,static,struct,switch,typedef,union,unsigned,void,volatile";
    public static final String COMMON_KEYWORDS = "break,continue,do,else,for,if,return,while,auto,case,char,const,default,double,enum,extern,float,goto,inline,int,long,register,short,signed,sizeof,static,struct,switch,typedef,union,unsigned,void,volatile,catch,class,delete,false,import,new,operator,private,protected,public,this,throw,true,try,typeof";
    public static final String CPP_KEYWORDS = "break,continue,do,else,for,if,return,while,auto,case,char,const,default,double,enum,extern,float,goto,inline,int,long,register,short,signed,sizeof,static,struct,switch,typedef,union,unsigned,void,volatile,catch,class,delete,false,import,new,operator,private,protected,public,this,throw,true,try,typeof,alignof,align_union,asm,axiom,bool,concept,concept_map,const_cast,constexpr,decltype,delegate,dynamic_cast,explicit,export,friend,generic,late_check,mutable,namespace,nullptr,property,reinterpret_cast,static_assert,static_cast,template,typeid,typename,using,virtual,where";
    public static final String JAVA_KEYWORDS = "break,continue,do,else,for,if,return,while,auto,case,char,const,default,double,enum,extern,float,goto,inline,int,long,register,short,signed,sizeof,static,struct,switch,typedef,union,unsigned,void,volatile,catch,class,delete,false,import,new,operator,private,protected,public,this,throw,true,try,typeof,abstract,assert,boolean,byte,extends,final,finally,implements,import,instanceof,interface,null,native,package,strictfp,super,synchronized,throws,transient";
    public static final String RUST_KEYWORDS = "break,continue,do,else,for,if,return,while,as,assert,const,copy,drop,enum,extern,fail,false,fn,impl,let,log,loop,match,mod,move,mut,priv,pub,pure,ref,self,static,struct,true,trait,type,unsafe,use";
    public static final String CSHARP_KEYWORDS = "break,continue,do,else,for,if,return,while,auto,case,char,const,default,double,enum,extern,float,goto,inline,int,long,register,short,signed,sizeof,static,struct,switch,typedef,union,unsigned,void,volatile,catch,class,delete,false,import,new,operator,private,protected,public,this,throw,true,try,typeof,abstract,assert,boolean,byte,extends,final,finally,implements,import,instanceof,interface,null,native,package,strictfp,super,synchronized,throws,transient,as,base,by,checked,decimal,delegate,descending,dynamic,event,fixed,foreach,from,group,implicit,in,internal,into,is,let,lock,object,out,override,orderby,params,partial,readonly,ref,sbyte,sealed,stackalloc,string,select,uint,ulong,unchecked,unsafe,ushort,var,virtual,where";
    public static final String COFFEE_KEYWORDS = "all,and,by,catch,class,else,extends,false,finally,for,if,in,is,isnt,loop,new,no,not,null,of,off,on,or,return,super,then,throw,true,try,unless,until,when,while,yes";
    public static final String JSCRIPT_KEYWORDS = "break,continue,do,else,for,if,return,while,auto,case,char,const,default,double,enum,extern,float,goto,inline,int,long,register,short,signed,sizeof,static,struct,switch,typedef,union,unsigned,void,volatile,catch,class,delete,false,import,new,operator,private,protected,public,this,throw,true,try,typeof,debugger,eval,export,function,get,null,set,undefined,var,with,Infinity,NaN";
    public static final String PERL_KEYWORDS = "caller,delete,die,do,dump,elsif,eval,exit,foreach,for,goto,if,import,last,local,my,next,no,our,print,package,redo,require,sub,undef,unless,until,use,wantarray,while,BEGIN,END";
    public static final String PYTHON_KEYWORDS = "break,continue,do,else,for,if,return,while,and,as,assert,class,def,del,elif,except,exec,finally,from,global,import,in,is,lambda,nonlocal,not,or,pass,print,raise,try,with,yield,False,True,None";
    public static final String RUBY_KEYWORDS = "break,continue,do,else,for,if,return,while,alias,and,begin,case,class,def,defined,elsif,end,ensure,false,in,module,next,nil,not,or,redo,rescue,retry,self,super,then,true,undef,unless,until,when,yield,BEGIN,END";
    public static final String SH_KEYWORDS = "break,continue,do,else,for,if,return,while,case,done,elif,esac,eval,fi,function,in,local,set,then,until";
    public static final String ALL_KEYWORDS = "break,continue,do,else,for,if,return,while,auto,case,char,const,default,double,enum,extern,float,goto,inline,int,long,register,short,signed,sizeof,static,struct,switch,typedef,union,unsigned,void,volatile,catch,class,delete,false,import,new,operator,private,protected,public,this,throw,true,try,typeof,alignof,align_union,asm,axiom,bool,concept,concept_map,const_cast,constexpr,decltype,delegate,dynamic_cast,explicit,export,friend,generic,late_check,mutable,namespace,nullptr,property,reinterpret_cast,static_assert,static_cast,template,typeid,typename,using,virtual,where,break,continue,do,else,for,if,return,while,auto,case,char,const,default,double,enum,extern,float,goto,inline,int,long,register,short,signed,sizeof,static,struct,switch,typedef,union,unsigned,void,volatile,catch,class,delete,false,import,new,operator,private,protected,public,this,throw,true,try,typeof,abstract,assert,boolean,byte,extends,final,finally,implements,import,instanceof,interface,null,native,package,strictfp,super,synchronized,throws,transient,as,base,by,checked,decimal,delegate,descending,dynamic,event,fixed,foreach,from,group,implicit,in,internal,into,is,let,lock,object,out,override,orderby,params,partial,readonly,ref,sbyte,sealed,stackalloc,string,select,uint,ulong,unchecked,unsafe,ushort,var,virtual,where,break,continue,do,else,for,if,return,while,auto,case,char,const,default,double,enum,extern,float,goto,inline,int,long,register,short,signed,sizeof,static,struct,switch,typedef,union,unsigned,void,volatile,catch,class,delete,false,import,new,operator,private,protected,public,this,throw,true,try,typeof,debugger,eval,export,function,get,null,set,undefined,var,with,Infinity,NaN,caller,delete,die,do,dump,elsif,eval,exit,foreach,for,goto,if,import,last,local,my,next,no,our,print,package,redo,require,sub,undef,unless,until,use,wantarray,while,BEGIN,END,break,continue,do,else,for,if,return,while,and,as,assert,class,def,del,elif,except,exec,finally,from,global,import,in,is,lambda,nonlocal,not,or,pass,print,raise,try,with,yield,False,True,None,break,continue,do,else,for,if,return,while,alias,and,begin,case,class,def,defined,elsif,end,ensure,false,in,module,next,nil,not,or,redo,rescue,retry,self,super,then,true,undef,unless,until,when,yield,BEGIN,END,break,continue,do,else,for,if,return,while,case,done,elif,esac,eval,fi,function,in,local,set,then,until";
    public static final Pattern C_TYPES = Pattern.compile("^(DIR|FILE|vector|(de|priority_)?queue|list|stack|(const_)?iterator|(multi)?(set|map)|bitset|u?(int|float)\\d*)\\b");
    public static final String PR_STRING = "str";
    public static final String PR_KEYWORD = "kwd";
    public static final String PR_COMMENT = "com";
    public static final String PR_TYPE = "typ";
    public static final String PR_LITERAL = "lit";
    public static final String PR_PUNCTUATION = "pun";
    public static final String PR_PLAIN = "pln";
    public static final String PR_TAG = "tag";
    public static final String PR_DECLARATION = "dec";
    public static final String PR_SOURCE = "src";
    public static final String PR_ATTRIB_NAME = "atn";
    public static final String PR_ATTRIB_VALUE = "atv";
    public static final String PR_NOCODE = "nocode";
    private static final String REGEXP_PRECEDER_PATTERN = "(?:^^\\.?|[+-]|[!=]=?=?|\\#|%=?|&&?=?|\\(|\\*=?|[+\\-]=|->|\\/=?|::?|<<?=?|>>?>?=?|,|;|\\?|@|\\[|~|\\{|\\^\\^?=?|\\|\\|?=?|break|case|continue|delete|do|else|finally|instanceof|return|throw|try|typeof)\\s*";
    protected Map<String, Object> langHandlerRegistry = new HashMap<String, Object>();

    public Prettify() {
        try {
            HashMap<String, Object> decorateSourceMap = new HashMap<String, Object>();
            decorateSourceMap.put("keywords", ALL_KEYWORDS);
            decorateSourceMap.put("hashComments", true);
            decorateSourceMap.put("cStyleComments", true);
            decorateSourceMap.put("multiLineStrings", true);
            decorateSourceMap.put("regexLiterals", true);
            this.registerLangHandler(this.sourceDecorator(decorateSourceMap), Arrays.asList("default-code"));
            ArrayList<List<Object>> shortcutStylePatterns = new ArrayList<List<Object>>();
            ArrayList<List<Object>> fallthroughStylePatterns = new ArrayList<List<Object>>();
            fallthroughStylePatterns.add(Arrays.asList(PR_PLAIN, Pattern.compile("^[^<?]+")));
            fallthroughStylePatterns.add(Arrays.asList(PR_DECLARATION, Pattern.compile("^<!\\w[^>]*(?:>|$)")));
            fallthroughStylePatterns.add(Arrays.asList(PR_COMMENT, Pattern.compile("^<\\!--[\\s\\S]*?(?:-\\->|$)")));
            fallthroughStylePatterns.add(Arrays.asList("lang-", Pattern.compile("^<\\?([\\s\\S]+?)(?:\\?>|$)")));
            fallthroughStylePatterns.add(Arrays.asList("lang-", Pattern.compile("^<%([\\s\\S]+?)(?:%>|$)")));
            fallthroughStylePatterns.add(Arrays.asList(PR_PUNCTUATION, Pattern.compile("^(?:<[%?]|[%?]>)")));
            fallthroughStylePatterns.add(Arrays.asList("lang-", Pattern.compile("^<xmp\\b[^>]*>([\\s\\S]+?)<\\/xmp\\b[^>]*>", 2)));
            fallthroughStylePatterns.add(Arrays.asList("lang-js", Pattern.compile("^<script\\b[^>]*>([\\s\\S]*?)(<\\/script\\b[^>]*>)", 2)));
            fallthroughStylePatterns.add(Arrays.asList("lang-css", Pattern.compile("^<style\\b[^>]*>([\\s\\S]*?)(<\\/style\\b[^>]*>)", 2)));
            fallthroughStylePatterns.add(Arrays.asList("lang-in.tag", Pattern.compile("^(<\\/?[a-z][^<>]*>)", 2)));
            this.registerLangHandler(new CreateSimpleLexer(shortcutStylePatterns, fallthroughStylePatterns), Arrays.asList("default-markup", "htm", "html", "mxml", "xhtml", "xml", "xsl"));
            shortcutStylePatterns = new ArrayList();
            fallthroughStylePatterns = new ArrayList();
            shortcutStylePatterns.add(Arrays.asList(PR_PLAIN, Pattern.compile("^[\\s]+"), null, " \t\r\n"));
            shortcutStylePatterns.add(Arrays.asList(PR_ATTRIB_VALUE, Pattern.compile("^(?:\\\"[^\\\"]*\\\"?|\\'[^\\']*\\'?)"), null, "\"'"));
            fallthroughStylePatterns.add(Arrays.asList(PR_TAG, Pattern.compile("^^<\\/?[a-z](?:[\\w.:-]*\\w)?|\\/?>$", 2)));
            fallthroughStylePatterns.add(Arrays.asList(PR_ATTRIB_NAME, Pattern.compile("^(?!style[\\s=]|on)[a-z](?:[\\w:-]*\\w)?", 2)));
            fallthroughStylePatterns.add(Arrays.asList("lang-uq.val", Pattern.compile("^=\\s*([^>\\'\\\"\\s]*(?:[^>\\'\\\"\\s\\/]|\\/(?=\\s)))", 2)));
            fallthroughStylePatterns.add(Arrays.asList(PR_PUNCTUATION, Pattern.compile("^[=<>\\/]+")));
            fallthroughStylePatterns.add(Arrays.asList("lang-js", Pattern.compile("^on\\w+\\s*=\\s*\\\"([^\\\"]+)\\\"", 2)));
            fallthroughStylePatterns.add(Arrays.asList("lang-js", Pattern.compile("^on\\w+\\s*=\\s*\\'([^\\']+)\\'", 2)));
            fallthroughStylePatterns.add(Arrays.asList("lang-js", Pattern.compile("^on\\w+\\s*=\\s*([^\\\"\\'>\\s]+)", 2)));
            fallthroughStylePatterns.add(Arrays.asList("lang-css", Pattern.compile("^style\\s*=\\s*\\\"([^\\\"]+)\\\"", 2)));
            fallthroughStylePatterns.add(Arrays.asList("lang-css", Pattern.compile("^style\\s*=\\s*\\'([^\\']+)\\'", 2)));
            fallthroughStylePatterns.add(Arrays.asList("lang-css", Pattern.compile("^style\\s*=\\s\\*([^\\\"\\'>\\s]+)", 2)));
            this.registerLangHandler(new CreateSimpleLexer(shortcutStylePatterns, fallthroughStylePatterns), Arrays.asList("in.tag"));
            shortcutStylePatterns = new ArrayList();
            fallthroughStylePatterns = new ArrayList();
            fallthroughStylePatterns.add(Arrays.asList(PR_ATTRIB_VALUE, Pattern.compile("^[\\s\\S]+")));
            this.registerLangHandler(new CreateSimpleLexer(shortcutStylePatterns, fallthroughStylePatterns), Arrays.asList("uq.val"));
            decorateSourceMap = new HashMap();
            decorateSourceMap.put("keywords", CPP_KEYWORDS);
            decorateSourceMap.put("hashComments", true);
            decorateSourceMap.put("cStyleComments", true);
            decorateSourceMap.put("types", C_TYPES);
            this.registerLangHandler(this.sourceDecorator(decorateSourceMap), Arrays.asList("c", "cc", "cpp", "cxx", "cyc", "m"));
            decorateSourceMap = new HashMap();
            decorateSourceMap.put("keywords", "null,true,false");
            this.registerLangHandler(this.sourceDecorator(decorateSourceMap), Arrays.asList("json"));
            decorateSourceMap = new HashMap();
            decorateSourceMap.put("keywords", CSHARP_KEYWORDS);
            decorateSourceMap.put("hashComments", true);
            decorateSourceMap.put("cStyleComments", true);
            decorateSourceMap.put("verbatimStrings", true);
            decorateSourceMap.put("types", C_TYPES);
            this.registerLangHandler(this.sourceDecorator(decorateSourceMap), Arrays.asList("cs"));
            decorateSourceMap = new HashMap();
            decorateSourceMap.put("keywords", JAVA_KEYWORDS);
            decorateSourceMap.put("cStyleComments", true);
            this.registerLangHandler(this.sourceDecorator(decorateSourceMap), Arrays.asList("java"));
            decorateSourceMap = new HashMap();
            decorateSourceMap.put("keywords", SH_KEYWORDS);
            decorateSourceMap.put("hashComments", true);
            decorateSourceMap.put("multiLineStrings", true);
            this.registerLangHandler(this.sourceDecorator(decorateSourceMap), Arrays.asList("bash", "bsh", "csh", "sh"));
            decorateSourceMap = new HashMap();
            decorateSourceMap.put("keywords", PYTHON_KEYWORDS);
            decorateSourceMap.put("hashComments", true);
            decorateSourceMap.put("multiLineStrings", true);
            decorateSourceMap.put("tripleQuotedStrings", true);
            this.registerLangHandler(this.sourceDecorator(decorateSourceMap), Arrays.asList("cv", "py", "python"));
            decorateSourceMap = new HashMap();
            decorateSourceMap.put("keywords", PERL_KEYWORDS);
            decorateSourceMap.put("hashComments", true);
            decorateSourceMap.put("multiLineStrings", true);
            decorateSourceMap.put("regexLiterals", 2);
            this.registerLangHandler(this.sourceDecorator(decorateSourceMap), Arrays.asList("perl", "pl", "pm"));
            decorateSourceMap = new HashMap();
            decorateSourceMap.put("keywords", RUBY_KEYWORDS);
            decorateSourceMap.put("hashComments", true);
            decorateSourceMap.put("multiLineStrings", true);
            decorateSourceMap.put("regexLiterals", true);
            this.registerLangHandler(this.sourceDecorator(decorateSourceMap), Arrays.asList("rb", "ruby"));
            decorateSourceMap = new HashMap();
            decorateSourceMap.put("keywords", JSCRIPT_KEYWORDS);
            decorateSourceMap.put("cStyleComments", true);
            decorateSourceMap.put("regexLiterals", true);
            this.registerLangHandler(this.sourceDecorator(decorateSourceMap), Arrays.asList("javascript", "js"));
            decorateSourceMap = new HashMap();
            decorateSourceMap.put("keywords", COFFEE_KEYWORDS);
            decorateSourceMap.put("hashComments", 3);
            decorateSourceMap.put("cStyleComments", true);
            decorateSourceMap.put("multilineStrings", true);
            decorateSourceMap.put("tripleQuotedStrings", true);
            decorateSourceMap.put("regexLiterals", true);
            this.registerLangHandler(this.sourceDecorator(decorateSourceMap), Arrays.asList("coffee"));
            decorateSourceMap = new HashMap();
            decorateSourceMap.put("keywords", RUST_KEYWORDS);
            decorateSourceMap.put("cStyleComments", true);
            decorateSourceMap.put("multilineStrings", true);
            this.registerLangHandler(this.sourceDecorator(decorateSourceMap), Arrays.asList("rc", "rs", "rust"));
            shortcutStylePatterns = new ArrayList();
            fallthroughStylePatterns = new ArrayList();
            fallthroughStylePatterns.add(Arrays.asList(PR_STRING, Pattern.compile("^[\\s\\S]+")));
            this.registerLangHandler(new CreateSimpleLexer(shortcutStylePatterns, fallthroughStylePatterns), Arrays.asList("regex"));
            decorateSourceMap = new HashMap();
            decorateSourceMap.put("keywords", "bytes,default,double,enum,extend,extensions,false,group,import,max,message,option,optional,package,repeated,required,returns,rpc,service,syntax,to,true");
            decorateSourceMap.put("types", Pattern.compile("^(bool|(double|s?fixed|[su]?int)(32|64)|float|string)\\b"));
            decorateSourceMap.put("cStyleComments", true);
            this.registerLangHandler(this.sourceDecorator(decorateSourceMap), Arrays.asList("proto"));
            this.register(LangAppollo.class);
            this.register(LangBasic.class);
            this.register(LangClj.class);
            this.register(LangCss.class);
            this.register(LangDart.class);
            this.register(LangErlang.class);
            this.register(LangGo.class);
            this.register(LangHs.class);
            this.register(LangLisp.class);
            this.register(LangLlvm.class);
            this.register(LangLua.class);
            this.register(LangMatlab.class);
            this.register(LangMl.class);
            this.register(LangMumps.class);
            this.register(LangN.class);
            this.register(LangPascal.class);
            this.register(LangR.class);
            this.register(LangRd.class);
            this.register(LangScala.class);
            this.register(LangSql.class);
            this.register(LangTex.class);
            this.register(LangVb.class);
            this.register(LangVhdl.class);
            this.register(LangTcl.class);
            this.register(LangWiki.class);
            this.register(LangXq.class);
            this.register(LangYaml.class);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    protected static void appendDecorations(int basePos, String sourceCode, CreateSimpleLexer langHandler, List<Object> out) {
        if (sourceCode == null) {
            throw new NullPointerException("argument 'sourceCode' cannot be null");
        }
        Job job = new Job();
        job.setSourceCode(sourceCode);
        job.setBasePos(basePos);
        langHandler.decorate(job);
        out.addAll(job.getDecorations());
    }

    protected CreateSimpleLexer sourceDecorator(Map<String, Object> options) throws Exception {
        String keywords;
        Pattern types;
        Object regexLiterals;
        Object hc;
        ArrayList<List<Object>> shortcutStylePatterns = new ArrayList<List<Object>>();
        ArrayList<List<Object>> fallthroughStylePatterns = new ArrayList<List<Object>>();
        if (Util.getVariableValueAsBoolean(options.get("tripleQuotedStrings")).booleanValue()) {
            shortcutStylePatterns.add(Arrays.asList(PR_STRING, Pattern.compile("^(?:\\'\\'\\'(?:[^\\'\\\\]|\\\\[\\s\\S]|\\'{1,2}(?=[^\\']))*(?:\\'\\'\\'|$)|\\\"\\\"\\\"(?:[^\\\"\\\\]|\\\\[\\s\\S]|\\\"{1,2}(?=[^\\\"]))*(?:\\\"\\\"\\\"|$)|\\'(?:[^\\\\\\']|\\\\[\\s\\S])*(?:\\'|$)|\\\"(?:[^\\\\\\\"]|\\\\[\\s\\S])*(?:\\\"|$))"), null, "'\""));
        } else if (Util.getVariableValueAsBoolean(options.get("multiLineStrings")).booleanValue()) {
            shortcutStylePatterns.add(Arrays.asList(PR_STRING, Pattern.compile("^(?:\\'(?:[^\\\\\\']|\\\\[\\s\\S])*(?:\\'|$)|\\\"(?:[^\\\\\\\"]|\\\\[\\s\\S])*(?:\\\"|$)|\\`(?:[^\\\\\\`]|\\\\[\\s\\S])*(?:\\`|$))"), null, "'\"`"));
        } else {
            shortcutStylePatterns.add(Arrays.asList(PR_STRING, Pattern.compile("^(?:\\'(?:[^\\\\\\'\r\n]|\\\\.)*(?:\\'|$)|\\\"(?:[^\\\\\\\"\r\n]|\\\\.)*(?:\\\"|$))"), null, "\"'"));
        }
        if (Util.getVariableValueAsBoolean(options.get("verbatimStrings")).booleanValue()) {
            fallthroughStylePatterns.add(Arrays.asList(PR_STRING, Pattern.compile("^@\\\"(?:[^\\\"]|\\\"\\\")*(?:\\\"|$)"), null));
        }
        if (Util.getVariableValueAsBoolean(hc = options.get("hashComments")).booleanValue()) {
            if (Util.getVariableValueAsBoolean(options.get("cStyleComments")).booleanValue()) {
                if (hc instanceof Integer && (Integer)hc > 1) {
                    shortcutStylePatterns.add(Arrays.asList(PR_COMMENT, Pattern.compile("^#(?:##(?:[^#]|#(?!##))*(?:###|$)|.*)"), null, "#"));
                } else {
                    shortcutStylePatterns.add(Arrays.asList(PR_COMMENT, Pattern.compile("^#(?:(?:define|e(?:l|nd)if|else|error|ifn?def|include|line|pragma|undef|warning)\\b|[^\r\n]*)"), null, "#"));
                }
                fallthroughStylePatterns.add(Arrays.asList(PR_STRING, Pattern.compile("^<(?:(?:(?:\\.\\.\\/)*|\\/?)(?:[\\w-]+(?:\\/[\\w-]+)+)?[\\w-]+\\.h(?:h|pp|\\+\\+)?|[a-z]\\w*)>"), null));
            } else {
                shortcutStylePatterns.add(Arrays.asList(PR_COMMENT, Pattern.compile("^#[^\r\n]*"), null, "#"));
            }
        }
        if (Util.getVariableValueAsBoolean(options.get("cStyleComments")).booleanValue()) {
            fallthroughStylePatterns.add(Arrays.asList(PR_COMMENT, Pattern.compile("^\\/\\/[^\r\n]*"), null));
            fallthroughStylePatterns.add(Arrays.asList(PR_COMMENT, Pattern.compile("^\\/\\*[\\s\\S]*?(?:\\*\\/|$)"), null));
        }
        if (Util.getVariableValueAsBoolean(regexLiterals = options.get("regexLiterals")).booleanValue()) {
            String regexExcls = Util.getVariableValueAsInteger(regexLiterals) > 1 ? "" : "\n\r";
            String regexAny = !regexExcls.isEmpty() ? "." : "[\\S\\s]";
            String REGEX_LITERAL = "/(?=[^/*" + regexExcls + "])(?:[^/\\x5B\\x5C" + regexExcls + "]|\\x5C" + regexAny + "|\\x5B(?:[^\\x5C\\x5D" + regexExcls + "]|\\x5C" + regexAny + ")*(?:\\x5D|$))+/";
            fallthroughStylePatterns.add(Arrays.asList("lang-regex", Pattern.compile("^(?:^^\\.?|[+-]|[!=]=?=?|\\#|%=?|&&?=?|\\(|\\*=?|[+\\-]=|->|\\/=?|::?|<<?=?|>>?>?=?|,|;|\\?|@|\\[|~|\\{|\\^\\^?=?|\\|\\|?=?|break|case|continue|delete|do|else|finally|instanceof|return|throw|try|typeof)\\s*(" + REGEX_LITERAL + ")")));
        }
        if (Util.getVariableValueAsBoolean(types = (Pattern)options.get("types")).booleanValue()) {
            fallthroughStylePatterns.add(Arrays.asList(PR_TYPE, types));
        }
        if ((keywords = (String)options.get("keywords")) != null && (keywords = keywords.replaceAll("^ | $", "")).length() != 0) {
            fallthroughStylePatterns.add(Arrays.asList(PR_KEYWORD, Pattern.compile("^(?:" + keywords.replaceAll("[\\s,]+", "|") + ")\\b"), null));
        }
        shortcutStylePatterns.add(Arrays.asList(PR_PLAIN, Pattern.compile("^\\s+"), null, " \r\n\t" + Character.toString('\u00a0')));
        fallthroughStylePatterns.add(Arrays.asList(PR_LITERAL, Pattern.compile("^@[a-z_$][a-z_$@0-9]*", 2), null));
        fallthroughStylePatterns.add(Arrays.asList(PR_TYPE, Pattern.compile("^(?:[@_]?[A-Z]+[a-z][A-Za-z_$@0-9]*|\\w+_t\\b)"), null));
        fallthroughStylePatterns.add(Arrays.asList(PR_PLAIN, Pattern.compile("^[a-z_$][a-z_$@0-9]*", 2), null));
        fallthroughStylePatterns.add(Arrays.asList(PR_LITERAL, Pattern.compile("^(?:0x[a-f0-9]+|(?:\\d(?:_\\d+)*\\d*(?:\\.\\d*)?|\\.\\d\\+)(?:e[+\\-]?\\d+)?)[a-z]*", 2), null, "0123456789"));
        fallthroughStylePatterns.add(Arrays.asList(PR_PLAIN, Pattern.compile("^\\\\[\\s\\S]?"), null));
        String punctuation = "^.[^\\s\\w.$@'\"`/\\\\]*";
        if (Util.getVariableValueAsBoolean(options.get("regexLiterals")).booleanValue()) {
            punctuation = punctuation + "(?!\\s*/)";
        }
        fallthroughStylePatterns.add(Arrays.asList(PR_PUNCTUATION, Pattern.compile(punctuation), null));
        return new CreateSimpleLexer(shortcutStylePatterns, fallthroughStylePatterns);
    }

    protected void registerLangHandler(CreateSimpleLexer handler, List<String> fileExtensions) throws Exception {
        int i = fileExtensions.size();
        while (--i >= 0) {
            String ext = fileExtensions.get(i);
            if (this.langHandlerRegistry.get(ext) == null) {
                this.langHandlerRegistry.put(ext, handler);
                continue;
            }
            throw new Exception("cannot override language handler " + ext);
        }
    }

    public void register(Class<? extends Lang> clazz) throws Exception {
        if (clazz == null) {
            throw new NullPointerException("argument 'clazz' cannot be null");
        }
        List<String> fileExtensions = this.getFileExtensionsFromClass(clazz);
        int i = fileExtensions.size();
        while (--i >= 0) {
            String ext = fileExtensions.get(i);
            if (this.langHandlerRegistry.get(ext) == null) {
                this.langHandlerRegistry.put(ext, clazz);
                continue;
            }
            throw new Exception("cannot override language handler " + ext);
        }
    }

    protected List<String> getFileExtensionsFromClass(Class<? extends Lang> clazz) throws Exception {
        Method getExtensionsMethod = clazz.getMethod("getFileExtensions", null);
        return (List)getExtensionsMethod.invoke(null, null);
    }

    public CreateSimpleLexer langHandlerForExtension(String extension, String source) {
        CreateSimpleLexer _simpleLexer;
        Object handler;
        if (extension == null || this.langHandlerRegistry.get(extension) == null) {
            String string = extension = Util.test(Pattern.compile("^\\s*<"), source) ? "default-markup" : "default-code";
        }
        if ((handler = this.langHandlerRegistry.get(extension)) instanceof CreateSimpleLexer) {
            return (CreateSimpleLexer)handler;
        }
        try {
            Lang _lang = (Lang)((Class)handler).newInstance();
            _simpleLexer = new CreateSimpleLexer(_lang.getShortcutStylePatterns(), _lang.getFallthroughStylePatterns());
            List<Lang> extendedLangs = _lang.getExtendedLangs();
            for (Lang _extendedLang : extendedLangs) {
                this.register(_extendedLang.getClass());
            }
            List<String> fileExtensions = this.getFileExtensionsFromClass((Class)handler);
            for (String _extension : fileExtensions) {
                this.langHandlerRegistry.put(_extension, _simpleLexer);
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, null, ex);
            return null;
        }
        return _simpleLexer;
    }

    public class CreateSimpleLexer {
        protected List<List<Object>> fallthroughStylePatterns;
        protected Map<Character, List<Object>> shortcuts = new HashMap<Character, List<Object>>();
        protected Pattern tokenizer;
        protected int nPatterns;

        protected CreateSimpleLexer(List<List<Object>> shortcutStylePatterns, List<List<Object>> fallthroughStylePatterns) throws Exception {
            this.fallthroughStylePatterns = fallthroughStylePatterns;
            ArrayList<List<Object>> allPatterns = new ArrayList<List<Object>>(shortcutStylePatterns);
            allPatterns.addAll(fallthroughStylePatterns);
            ArrayList<Pattern> allRegexs = new ArrayList<Pattern>();
            HashMap<String, Object> regexKeys = new HashMap<String, Object>();
            int n = allPatterns.size();
            for (int i = 0; i < n; ++i) {
                Pattern regex;
                String k;
                String shortcutChars;
                List patternParts = (List)allPatterns.get(i);
                String string = shortcutChars = patternParts.size() > 3 ? (String)patternParts.get(3) : null;
                if (shortcutChars != null) {
                    int c = shortcutChars.length();
                    while (--c >= 0) {
                        this.shortcuts.put(Character.valueOf(shortcutChars.charAt(c)), patternParts);
                    }
                }
                if (regexKeys.get(k = (regex = (Pattern)patternParts.get(1)).pattern()) != null) continue;
                allRegexs.add(regex);
                regexKeys.put(k, new Object());
            }
            allRegexs.add(Pattern.compile("[\u0000-\\uffff]"));
            this.tokenizer = new CombinePrefixPattern().combinePrefixPattern(allRegexs);
            this.nPatterns = fallthroughStylePatterns.size();
        }

        public void decorate(Job job) {
            String sourceCode = job.getSourceCode();
            int basePos = job.getBasePos();
            ArrayList<Object> decorations = new ArrayList<Object>(Arrays.asList(basePos, Prettify.PR_PLAIN));
            int pos = 0;
            String[] tokens = Util.match(this.tokenizer, sourceCode, true);
            HashMap<String, String> styleCache = new HashMap<String, String>();
            for (String token : tokens) {
                boolean isEmbedded;
                String style = (String)styleCache.get(token);
                String[] match = null;
                if (style != null) {
                    isEmbedded = false;
                } else {
                    List<Object> patternParts = this.shortcuts.get(Character.valueOf(token.charAt(0)));
                    if (patternParts != null) {
                        match = Util.match((Pattern)patternParts.get(1), token, false);
                        style = (String)patternParts.get(0);
                    } else {
                        for (int i = 0; i < this.nPatterns; ++i) {
                            patternParts = this.fallthroughStylePatterns.get(i);
                            match = Util.match((Pattern)patternParts.get(1), token, false);
                            if (match.length == 0) continue;
                            style = (String)patternParts.get(0);
                            break;
                        }
                        if (match.length == 0) {
                            style = Prettify.PR_PLAIN;
                        }
                    }
                    boolean bl = isEmbedded = style != null && style.length() >= 5 && style.startsWith("lang-");
                    if (isEmbedded && (match.length <= 1 || match[1] == null)) {
                        isEmbedded = false;
                        style = Prettify.PR_SOURCE;
                    }
                    if (!isEmbedded) {
                        styleCache.put(token, style);
                    }
                }
                int tokenStart = pos;
                pos += token.length();
                if (!isEmbedded) {
                    decorations.add(basePos + tokenStart);
                    decorations.add(style);
                    continue;
                }
                void embeddedSource = match[1];
                int embeddedSourceStart = token.indexOf((String)embeddedSource);
                int embeddedSourceEnd = embeddedSourceStart + embeddedSource.length();
                if (match.length > 2 && match[2] != null) {
                    embeddedSourceEnd = token.length() - match[2].length();
                    embeddedSourceStart = embeddedSourceEnd - embeddedSource.length();
                }
                String lang = style.substring(5);
                Prettify.appendDecorations(basePos + tokenStart, token.substring(0, embeddedSourceStart), this, decorations);
                Prettify.appendDecorations(basePos + tokenStart + embeddedSourceStart, (String)embeddedSource, Prettify.this.langHandlerForExtension(lang, (String)embeddedSource), decorations);
                Prettify.appendDecorations(basePos + tokenStart + embeddedSourceEnd, token.substring(embeddedSourceEnd), this, decorations);
            }
            job.setDecorations(Util.removeDuplicates(decorations, job.getSourceCode()));
        }
    }
}

