/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sql2java.lib;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import net.sourceforge.sql2java.lib.DaoBean;
import net.sourceforge.sql2java.lib.DaoManager;
import net.sourceforge.sql2java.lib.Database;
import net.sourceforge.sql2java.lib.Txn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseManager<T extends DaoBean>
implements DaoManager<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseManager.class);
    public static final int SEARCH_EXACT = 0;
    public static final int SEARCH_LIKE = 1;
    public static final int SEARCH_STARTING_LIKE = 2;
    public static final int SEARCH_ENDING_LIKE = 3;
    protected DataSource dataSource;
    private static final String[] patterns = new String[]{"EEE, dd MMM yyyy HH:mm:ss '-'S '('z')'", "EEE, dd MMM yyyy HH:mm:ss '+'S '('z')'", "EEE, dd MMM yyyy HH:mm:ss '-'S", "EEE, dd MMM yyyy HH:mm:ss '+'S", "EEE, dd MMM yyyy HH:mm:ss z", "EEE, dd MMM yyyy HH:mm:ss Z", "EEE, dd MMM yyyy HH:mm:ss", "EEE, d MMM yyyy HH:mm:ss '-'S '('z')'", "EEE, d MMM yyyy HH:mm:ss '+'S '('z')'", "EEE, d MMM yyyy HH:mm:ss '-'S", "EEE, d MMM yyyy HH:mm:ss '+'S", "EEE, d MMM yyyy HH:mm:ss z", "EEE, d MMM yyyy HH:mm:ss Z", "EEE, d MMM yyyy HH:mm:ss", "EEE, dd MMM yy HH:mm:ss '-'S '('z')'", "EEE, dd MMM yy HH:mm:ss '+'S '('z')'", "EEE, dd MMM yy HH:mm:ss '-'S", "EEE, dd MMM yy HH:mm:ss '+'S", "EEE, dd MMM yy HH:mm:ss z", "EEE, dd MMM yy HH:mm:ss Z", "EEE, dd MMM yy HH:mm:ss", "EEE, d MMM yy HH:mm:ss '-'S '('z')'", "EEE, d MMM yy HH:mm:ss '+'S '('z')'", "EEE, d MMM yy HH:mm:ss '-'S", "EEE, d MMM yy HH:mm:ss '+'S", "EEE, d MMM yy HH:mm:ss z", "EEE, d MMM yy HH:mm:ss Z", "EEE, d MMM yy HH:mm:ss", "dd MMM yyyy HH:mm:ss '-'S", "dd MMM yyyy HH:mm:ss '+'S", "dd MMM yyyy HH:mm:ss '-'S '('z')'", "dd MMM yyyy HH:mm:ss '+'S '('z')'", "dd MMM yyyy HH:mm:ss z", "dd MMM yyyy HH:mm:ss Z", "dd MMM yyyy HH:mm:ss", "dd MMM yyy HH:mm:ss '-'S", "dd MMM yyy HH:mm:ss '+'S", "dd MMM yyy HH:mm:ss '-'S '('z')'", "dd MMM yyy HH:mm:ss '+'S '('z')'", "dd MMM yyy HH:mm:ss z", "dd MMM yyy HH:mm:ss Z", "dd MMM yyy HH:mm:ss", "yyyy.MM.dd HH:mm:ss z", "yyyy.MM.dd HH:mm:ss Z", "yyyy.MM.d HH:mm:ss z", "yyyy.MM.d HH:mm:ss Z", "yyyy.MM.dd HH:mm:ss", "yyyy.MM.d HH:mm:ss", "yy.MM.dd HH:mm:ss z", "yy.MM.dd HH:mm:ss Z", "yy.MM.d HH:mm:ss z", "yy.MM.d HH:mm:ss Z", "yy.MM.dd HH:mm:ss", "yy.MM.d HH:mm:ss", "yyyy MM dd HH:mm:ss", "yyyy MM d HH:mm:ss", "yyyy MM dd HH:mm:ss z", "yyyy MM dd HH:mm:ss Z", "yyyy MM d HH:mm:ss z", "yyyy MM d HH:mm:ss Z", "yy MM dd HH:mm:ss", "yy MM d HH:mm:ss", "yy MM dd HH:mm:ss z", "yy MM dd HH:mm:ss Z", "yy MM d HH:mm:ss z", "yy MM d HH:mm:ss Z", "yyyy-MM-dd HH:mm:ss z", "yyyy-MM-dd HH:mm:ss Z", "yyyy-MM-d HH:mm:ss z", "yyyy-MM-d HH:mm:ss Z", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-d HH:mm:ss", "yy-MM-dd HH:mm:ss z", "yy-MM-dd HH:mm:ss Z", "yy-MM-d HH:mm:ss z", "yy-MM-d HH:mm:ss Z", "yy-MM-dd HH:mm:ss", "yy-MM-d HH:mm:ss", "dd MMM yyyy", "d MMM yyyy", "dd.MMM.yyyy", "d.MMM.yyyy", "dd-MMM-yyyy", "d-MMM-yyyy", "dd MM yyyy", "d MM yyyy", "dd.MM.yyyy", "d.MM.yyyy", "dd-MM-yyyy", "d-MM-yyyy", "yyyy MM dd", "yyyy MM d", "yyyy.MM.dd", "yyyy.MM.d", "yyyy-MM-dd", "yyyy-MM-d", "dd MMM yy", "d MMM yy", "dd.MMM.yy", "d.MMM.yy", "dd-MMM-yy", "d-MMM-yy", "dd MM yy", "d MM yy", "dd.MM.yy", "d.MM.yy", "dd-MM-yy", "d-MM-yy", "yy MMM dd", "yy MMM d", "yy.MMM.dd", "yy.MMM.d", "yy-MMM-dd", "yy-MMM-d", "yy MMM dd", "yy MMM d", "yy.MMM.dd", "yy.MMM.d", "yy-MMM-dd", "yy-MMM-d", "EEE dd, MMM yyyy", "EEE dd, MMM yy"};

    protected BaseManager(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected abstract String[] getFullFieldNames();

    protected abstract String[] getFieldNames();

    protected abstract String getAllFullFields();

    protected abstract String getAllFields();

    @Override
    public T loadByPrimaryKey(Integer primaryKey) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public abstract T createBean();

    @Override
    public abstract String getTableName();

    @Override
    public int deleteByPrimaryKey(Integer id) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<T> loadAll() throws SQLException {
        return this.loadUsingTemplate((T)null);
    }

    @Override
    public List<T> loadAll(int startRow, int numRows) throws SQLException {
        return this.loadUsingTemplate((T)null, startRow, numRows);
    }

    @Override
    public List<T> loadByWhere(String where) throws SQLException {
        return this.loadByWhere(where, 1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> loadByWhere(String where, int startRow, int numRows) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ").append(this.getAllFields()).append(" FROM ").append(this.getTableName()).append(" ").append(where);
        Connection c = null;
        Statement st = null;
        ResultSet rs = null;
        if (log.isTraceEnabled()) {
            log.trace("loadByWhere: {}", (Object)sql);
        }
        try {
            c = this.getConnection();
            st = c.createStatement(1005, 1007);
            rs = st.executeQuery(sql.toString());
            List<T> list = this.decodeResultSet(rs, startRow, numRows);
            this.close(st, rs);
            this.releaseConnection(c);
            return list;
        }
        catch (Throwable throwable) {
            this.close(st, rs);
            this.releaseConnection(c);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> loadByWhere(String where, Object ... fields) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ").append(this.getAllFields()).append(" FROM ").append(this.getTableName()).append(" ").append(where);
        Connection c = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        if (log.isTraceEnabled()) {
            log.trace("loadByWhere: {}", (Object)sql);
        }
        try {
            c = this.getConnection();
            ps = c.prepareStatement(sql.toString(), 1004, 1007);
            this.fillPreparedStatement(ps, fields);
            rs = ps.executeQuery();
            List<T> list = this.decodeResultSet(rs, 1, -1);
            this.close(ps, rs);
            this.releaseConnection(c);
            return list;
        }
        catch (Throwable throwable) {
            this.close(ps, rs);
            this.releaseConnection(c);
            throw throwable;
        }
    }

    @Override
    public T loadUniqueByWhere(String where) throws SQLException {
        List<T> os = this.loadByWhere(where);
        if (os != null && os.size() > 0) {
            return (T)((DaoBean)os.get(0));
        }
        return null;
    }

    @Override
    public T loadUniqueByWhere(String where, Object ... fields) throws SQLException {
        List<T> os = this.loadByWhere(where, fields);
        if (os != null && os.size() > 0) {
            return (T)((DaoBean)os.get(0));
        }
        return null;
    }

    @Override
    public int deleteAll() throws SQLException {
        return this.deleteByWhere("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteByWhere(String where) throws SQLException {
        Connection c = null;
        PreparedStatement ps = null;
        try {
            c = this.getConnection();
            StringBuilder sql = new StringBuilder("DELETE FROM ").append(this.getTableName()).append(" ").append(where);
            if (log.isTraceEnabled()) {
                log.trace("deleteByWhere: {}", (Object)sql);
            }
            ps = c.prepareStatement(sql.toString());
            int n = ps.executeUpdate();
            this.close(ps);
            this.releaseConnection(c);
            return n;
        }
        catch (Throwable throwable) {
            this.close(ps);
            this.releaseConnection(c);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteByWhere(String where, Object ... fields) throws SQLException {
        StringBuilder sql = new StringBuilder("DELETE FROM ").append(this.getTableName()).append(" ").append(where);
        Connection c = null;
        PreparedStatement ps = null;
        if (log.isTraceEnabled()) {
            log.trace("deleteByWhere: {}", (Object)sql);
        }
        try {
            c = this.getConnection();
            ps = c.prepareStatement(sql.toString());
            this.fillPreparedStatement(ps, fields);
            int n = ps.executeUpdate();
            this.close(ps);
            this.releaseConnection(c);
            return n;
        }
        catch (Throwable throwable) {
            this.close(ps);
            this.releaseConnection(c);
            throw throwable;
        }
    }

    @Override
    public T save(T bean) throws SQLException {
        if (bean.isNew()) {
            return this.insert(bean);
        }
        return this.update(bean);
    }

    @Override
    public T insert(T bean) throws SQLException {
        return this.insert(bean, false);
    }

    @Override
    public T insert(T bean, boolean orUpdate) throws SQLException {
        return this.insert(bean, orUpdate, false);
    }

    @Override
    public abstract T insert(T var1, boolean var2, boolean var3) throws SQLException;

    @Override
    public abstract T update(T var1) throws SQLException;

    @Override
    public List<T> save(List<T> beans) throws SQLException {
        for (DaoBean bean : beans) {
            this.save((T)bean);
        }
        return beans;
    }

    @Override
    public List<T> insert(List<T> beans) throws SQLException {
        return this.save(beans);
    }

    @Override
    public List<T> update(List<T> beans) throws SQLException {
        return this.save(beans);
    }

    @Override
    public T loadUniqueUsingTemplate(T bean) throws SQLException {
        List<T> beans = this.loadUsingTemplate(bean);
        if (beans.size() == 0) {
            return null;
        }
        if (beans.size() > 1) {
            throw new SQLException("More than one element !!");
        }
        return (T)((DaoBean)beans.get(0));
    }

    @Override
    public List<T> loadUsingTemplate(T bean) throws SQLException {
        return this.loadUsingTemplate(bean, 1, -1);
    }

    @Override
    public List<T> loadUsingTemplate(T bean, int startRow, int numRows) throws SQLException {
        return this.loadUsingTemplate(bean, startRow, numRows, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> loadUsingTemplate(T bean, int startRow, int numRows, int searchType) throws SQLException {
        if (log.isTraceEnabled()) {
            log.trace("loadUsingTemplate startRow:{}, numRows:{}, searchType:{}", new Object[]{startRow, numRows, searchType});
        }
        Connection c = null;
        PreparedStatement ps = null;
        StringBuilder sql = new StringBuilder("SELECT " + this.getAllFields() + " FROM " + this.getTableName() + " ");
        StringBuilder sqlWhere = new StringBuilder("");
        try {
            if (this.fillWhere(sqlWhere, bean, searchType) == 0) {
                if (log.isTraceEnabled()) {
                    log.trace("The bean to look is not initialized... loading all");
                }
            } else {
                sql.append(" WHERE ").append((CharSequence)sqlWhere);
            }
            if (log.isTraceEnabled()) {
                log.trace("loadUsingTemplate: {}", (Object)sql);
            }
            c = this.getConnection();
            int scrollType = 1004;
            if (startRow != 1) {
                scrollType = 1005;
            }
            ps = c.prepareStatement(sql.toString(), scrollType, 1007);
            this.fillPreparedStatement(ps, bean, searchType);
            List<T> list = this.loadByPreparedStatement(ps, startRow, numRows);
            this.close(ps);
            this.releaseConnection(c);
            sql = null;
            sqlWhere = null;
            return list;
        }
        catch (Throwable throwable) {
            this.close(ps);
            this.releaseConnection(c);
            sql = null;
            sqlWhere = null;
            throw throwable;
        }
    }

    @Override
    public abstract int deleteUsingTemplate(T var1) throws SQLException;

    @Override
    public int countAll() throws SQLException {
        return this.countWhere("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int countWhere(String where) throws SQLException {
        StringBuilder sql = new StringBuilder("SELECT COUNT(*) AS MCOUNT FROM ").append(this.getTableName()).append(" ").append(where);
        if (log.isTraceEnabled()) {
            log.trace("countWhere: {}", (Object)sql);
        }
        Connection c = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            int iReturn = -1;
            c = this.getConnection();
            st = c.createStatement(1005, 1007);
            rs = st.executeQuery(sql.toString());
            if (rs.next()) {
                iReturn = rs.getInt("MCOUNT");
            }
            if (iReturn != -1) {
                int n = iReturn;
                this.close(st, rs);
                this.releaseConnection(c);
                return n;
            }
            this.close(st, rs);
            this.releaseConnection(c);
        }
        catch (Throwable throwable) {
            this.close(st, rs);
            this.releaseConnection(c);
            throw throwable;
        }
        throw new SQLException("Error in countWhere");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int countWhere(String where, Object ... fields) throws SQLException {
        StringBuilder sql = new StringBuilder("SELECT COUNT(*) AS MCOUNT FROM ").append(this.getTableName()).append(" ").append(where);
        Connection c = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        if (log.isTraceEnabled()) {
            log.trace("countWhere: {}", (Object)sql);
        }
        try {
            int iReturn = -1;
            c = this.getConnection();
            ps = c.prepareStatement(sql.toString());
            this.fillPreparedStatement(ps, fields);
            rs = ps.executeQuery();
            if (rs.next()) {
                iReturn = rs.getInt("MCOUNT");
            }
            if (iReturn != -1) {
                int n = iReturn;
                this.close(ps, rs);
                this.releaseConnection(c);
                return n;
            }
            this.close(ps, rs);
            this.releaseConnection(c);
        }
        catch (Throwable throwable) {
            this.close(ps, rs);
            this.releaseConnection(c);
            throw throwable;
        }
        throw new SQLException("Error in countWhere");
    }

    @Override
    public int countUsingTemplate(T bean) throws SQLException {
        return this.countUsingTemplate(bean, -1, -1);
    }

    @Override
    public int countUsingTemplate(T bean, int startRow, int numRows) throws SQLException {
        return this.countUsingTemplate(bean, startRow, numRows, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int countUsingTemplate(T bean, int startRow, int numRows, int searchType) throws SQLException {
        Connection c = null;
        PreparedStatement ps = null;
        StringBuilder sql = new StringBuilder("SELECT COUNT(*) AS MCOUNT FROM " + this.getTableName());
        StringBuilder sqlWhere = new StringBuilder("");
        try {
            if (this.fillWhere(sqlWhere, bean, 0) == 0) {
                if (log.isTraceEnabled()) {
                    log.trace("The bean to look is not initialized... counting all...");
                }
            } else {
                sql.append(" WHERE ").append((CharSequence)sqlWhere);
            }
            if (log.isTraceEnabled()) {
                log.trace("countUsingTemplate: {}", (Object)sql);
            }
            c = this.getConnection();
            ps = c.prepareStatement(sql.toString(), 1004, 1007);
            this.fillPreparedStatement(ps, bean, searchType);
            int n = this.countByPreparedStatement(ps);
            this.close(ps);
            this.releaseConnection(c);
            sql = null;
            sqlWhere = null;
            return n;
        }
        catch (Throwable throwable) {
            this.close(ps);
            this.releaseConnection(c);
            sql = null;
            sqlWhere = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int countByPreparedStatement(PreparedStatement ps) throws SQLException {
        ResultSet rs = null;
        try {
            int iReturn = -1;
            rs = ps.executeQuery();
            if (rs.next()) {
                iReturn = rs.getInt("MCOUNT");
            }
            if (iReturn != -1) {
                int n = iReturn;
                return n;
            }
        }
        finally {
            this.close(rs);
        }
        throw new SQLException("Error in countByPreparedStatement");
    }

    @Override
    public List<T> decodeResultSet(ResultSet rs, int startRow, int numRows) throws SQLException {
        ArrayList<Object> v = new ArrayList<Object>();
        int count = 0;
        if (rs.absolute(startRow) && numRows != 0) {
            do {
                v.add(this.decodeRow(rs));
            } while ((++count < numRows || numRows < 0) && rs.next());
        }
        return Collections.unmodifiableList(v);
    }

    @Override
    public abstract T decodeRow(ResultSet var1) throws SQLException;

    @Override
    public abstract T metaDataDecodeRow(ResultSet var1) throws SQLException;

    @Override
    public List<T> loadByPreparedStatement(PreparedStatement ps) throws SQLException {
        return this.loadByPreparedStatement(ps, 1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> loadByPreparedStatement(PreparedStatement ps, int startRow, int numRows) throws SQLException {
        ResultSet rs = null;
        try {
            rs = ps.executeQuery();
            List<T> list = this.decodeResultSet(rs, startRow, numRows);
            return list;
        }
        finally {
            this.close(rs);
        }
    }

    protected abstract int fillWhere(StringBuilder var1, T var2, int var3) throws SQLException;

    protected abstract int fillPreparedStatement(PreparedStatement var1, T var2, int var3) throws SQLException;

    protected int fillPreparedStatement(PreparedStatement ps, Object ... fields) throws SQLException {
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i] instanceof Boolean) {
                BaseManager.setBoolean(ps, i + 1, (Boolean)fields[i]);
                continue;
            }
            if (fields[i] instanceof Double) {
                BaseManager.setDouble(ps, i + 1, (Double)fields[i]);
                continue;
            }
            if (fields[i] instanceof Float) {
                BaseManager.setFloat(ps, i + 1, (Float)fields[i]);
                continue;
            }
            if (fields[i] instanceof Integer) {
                BaseManager.setInteger(ps, i + 1, (Integer)fields[i]);
                continue;
            }
            if (fields[i] instanceof Long) {
                BaseManager.setLong(ps, i + 1, (Long)fields[i]);
                continue;
            }
            if (fields[i] instanceof BigDecimal) {
                ps.setBigDecimal(i + 1, (BigDecimal)fields[i]);
                continue;
            }
            if (fields[i] instanceof String) {
                ps.setString(i + 1, (String)fields[i]);
                continue;
            }
            if (fields[i] instanceof Date) {
                ps.setDate(i + 1, (Date)fields[i]);
                continue;
            }
            if (fields[i] instanceof Timestamp) {
                ps.setTimestamp(i + 1, (Timestamp)fields[i]);
                continue;
            }
            ps.setObject(i + 1, fields[i]);
        }
        return fields.length;
    }

    public Connection getConnection() throws SQLException {
        Txn transaction = Database.currentTransaction();
        if (transaction == null) {
            return this.dataSource.getConnection();
        }
        try {
            transaction.setDataSource(this.dataSource);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return transaction.getConnection();
    }

    public void releaseConnection(Connection c) {
        Txn transaction;
        if (c != null && (transaction = Database.currentTransaction()) == null) {
            try {
                c.close();
            }
            catch (Exception e) {
                log.warn("Error releasing connection", (Throwable)e);
            }
        }
    }

    public void close(Statement s) {
        try {
            if (s != null) {
                s.close();
            }
        }
        catch (SQLException x) {
            log.warn("Could not close statement", (Throwable)x);
        }
    }

    public void close(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException x) {
            log.warn("Could not close result set", (Throwable)x);
        }
    }

    public void close(Statement s, ResultSet rs) {
        this.close(rs);
        this.close(s);
    }

    public static Integer getInteger(ResultSet rs, int pos) throws SQLException {
        int i = rs.getInt(pos);
        return rs.wasNull() ? (Integer)null : new Integer(i);
    }

    public static Integer getInteger(ResultSet rs, String column) throws SQLException {
        int i = rs.getInt(column);
        return rs.wasNull() ? (Integer)null : new Integer(i);
    }

    public static void setInteger(PreparedStatement ps, int pos, Integer i) throws SQLException {
        if (i == null) {
            ps.setNull(pos, 4);
        } else {
            ps.setInt(pos, i);
        }
    }

    public static Float getFloat(ResultSet rs, int pos) throws SQLException {
        float f = rs.getFloat(pos);
        return rs.wasNull() ? (Float)null : new Float(f);
    }

    public static Float getFloat(ResultSet rs, String column) throws SQLException {
        float f = rs.getFloat(column);
        return rs.wasNull() ? (Float)null : new Float(f);
    }

    public static void setFloat(PreparedStatement ps, int pos, Float f) throws SQLException {
        if (f == null) {
            ps.setNull(pos, 6);
        } else {
            ps.setFloat(pos, f.floatValue());
        }
    }

    public static Double getDouble(ResultSet rs, int pos) throws SQLException {
        double d = rs.getDouble(pos);
        return rs.wasNull() ? (Double)null : new Double(d);
    }

    public static Double getDouble(ResultSet rs, String column) throws SQLException {
        double d = rs.getDouble(column);
        return rs.wasNull() ? (Double)null : new Double(d);
    }

    public static void setDouble(PreparedStatement ps, int pos, Double d) throws SQLException {
        if (d == null) {
            ps.setNull(pos, 8);
        } else {
            ps.setDouble(pos, d);
        }
    }

    public static Long getLong(ResultSet rs, int pos) throws SQLException {
        long l = rs.getLong(pos);
        return rs.wasNull() ? (Long)null : new Long(l);
    }

    public static Long getLong(ResultSet rs, String column) throws SQLException {
        long l = rs.getLong(column);
        return rs.wasNull() ? (Long)null : new Long(l);
    }

    public static void setLong(PreparedStatement ps, int pos, Long l) throws SQLException {
        if (l == null) {
            ps.setNull(pos, -5);
        } else {
            ps.setLong(pos, l);
        }
    }

    public static Boolean getBoolean(ResultSet rs, int pos) throws SQLException {
        boolean b = rs.getBoolean(pos);
        return rs.wasNull() ? (Boolean)null : new Boolean(b);
    }

    public static Boolean getBoolean(ResultSet rs, String column) throws SQLException {
        boolean b = rs.getBoolean(column);
        return rs.wasNull() ? (Boolean)null : new Boolean(b);
    }

    public static void setBoolean(PreparedStatement ps, int pos, Boolean b) throws SQLException {
        if (b == null) {
            ps.setNull(pos, 16);
        } else {
            ps.setBoolean(pos, b);
        }
    }

    protected String getStringFromClob(ResultSet rs, int pos) throws SQLException {
        return BaseManager.getStringFromClob(rs, this.getFieldNames()[pos - 1]);
    }

    public static String getStringFromClob(ResultSet rs, String column) throws SQLException {
        Clob c = rs.getClob(column);
        StringBuilder sb = new StringBuilder();
        BufferedReader br = null;
        try {
            int b;
            br = new BufferedReader(c.getCharacterStream());
            while (-1 != (b = br.read())) {
                sb.append((char)b);
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            log.warn("Could not convert CLOB to String", (Throwable)e);
            throw new SQLException(e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception ignore) {}
            }
        }
    }

    public static void setClob(PreparedStatement ps, int pos, String s) throws SQLException {
        if (s == null) {
            ps.setNull(pos, 2005);
        } else {
            ps.setClob(pos, new StringReader(s), s.length());
        }
    }

    public static java.util.Date getDateFromString(String strDate) {
        if (strDate != null) {
            strDate = strDate.trim();
        }
        SimpleDateFormat pSimpleDateFormat = new SimpleDateFormat("");
        java.util.Date dReceivedDate = Calendar.getInstance().getTime();
        if (strDate != null && !"".equals(strDate)) {
            for (int i = 0; i < patterns.length; ++i) {
                try {
                    pSimpleDateFormat.applyPattern(patterns[i]);
                    dReceivedDate = pSimpleDateFormat.parse(strDate);
                    if (dReceivedDate != null) {
                        return dReceivedDate;
                    }
                    continue;
                }
                catch (ParseException pe) {
                    // empty catch block
                }
            }
        }
        return dReceivedDate;
    }

    public static boolean isDate(String strDate) {
        if (strDate != null) {
            strDate = strDate.trim();
        }
        SimpleDateFormat pSimpleDateFormat = new SimpleDateFormat("");
        if (strDate != null && !"".equals(strDate)) {
            for (int i = 0; i < patterns.length; ++i) {
                try {
                    pSimpleDateFormat.applyPattern(patterns[i]);
                    java.util.Date dReceivedDate = pSimpleDateFormat.parse(strDate);
                    if (dReceivedDate != null) {
                        return true;
                    }
                    continue;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        return false;
    }
}

