/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sql2java.lib;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import net.sourceforge.sql2java.lib.DaoBean;
import net.sourceforge.sql2java.lib.DaoManager;
import net.sourceforge.sql2java.lib.Txn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Database {
    private static final Logger log = LoggerFactory.getLogger(Database.class);
    private final DataSource dataSource;
    private final Map<Class, DaoManager> classMap;
    private static final ThreadLocal<Txn> transaction = new ThreadLocal<Txn>(){

        @Override
        protected Txn initialValue() {
            return null;
        }
    };

    protected Database(DataSource dataSource) {
        this.dataSource = dataSource;
        this.classMap = new HashMap<Class, DaoManager>();
    }

    protected void registerManager(DaoManager manager) {
        Class<?> beanClass = manager.createBean().getClass();
        log.trace("Added mapping for {} : {}", (Object)beanClass.getName(), (Object)manager.getClass().getName());
        this.classMap.put(beanClass, manager);
    }

    public <T extends DaoBean> DaoManager<T> managerForClass(Class<T> type) {
        return this.getManagerForClass(type);
    }

    public DaoManager getManagerForClass(Class type) {
        DaoManager daoManager = this.classMap.get(type);
        if (daoManager == null) {
            throw new IllegalArgumentException("No DaoManager found for " + type.getClass().getName());
        }
        return daoManager;
    }

    public <T extends DaoBean> T createBean(Class<T> type) {
        return (T)((DaoBean)this.getManagerForClass(type).createBean());
    }

    public String getTableName(Class<?> type) {
        return this.getManagerForClass(type).getTableName();
    }

    public <T extends DaoBean> T loadByPrimaryKey(Class<T> type, Integer id) throws SQLException {
        return (T)((DaoBean)this.getManagerForClass(type).loadByPrimaryKey(id));
    }

    public int deleteByPrimaryKey(Class<?> type, Integer id) throws SQLException {
        return this.getManagerForClass(type).deleteByPrimaryKey(id);
    }

    public <T extends DaoBean> List<T> loadAll(Class<T> type) throws SQLException {
        return this.getManagerForClass(type).loadAll();
    }

    public <T extends DaoBean> List<T> loadAll(Class<T> type, int startRow, int numRows) throws SQLException {
        return this.getManagerForClass(type).loadAll(startRow, numRows);
    }

    public <T extends DaoBean> List<T> loadByWhere(Class<T> type, String where) throws SQLException {
        return this.getManagerForClass(type).loadByWhere(where);
    }

    public <T extends DaoBean> List<T> loadByWhere(Class<T> type, String where, Object ... fields) throws SQLException {
        return this.getManagerForClass(type).loadByWhere(where, fields);
    }

    public <T extends DaoBean> List<T> loadByWhere(Class<T> type, String where, int startRow, int numRows) throws SQLException {
        return this.getManagerForClass(type).loadByWhere(where, startRow, numRows);
    }

    public <T extends DaoBean> T loadUniqueByWhere(Class<T> type, String where) throws SQLException {
        return (T)((DaoBean)this.getManagerForClass(type).loadUniqueByWhere(where));
    }

    public <T extends DaoBean> T loadUniqueByWhere(Class<T> type, String where, Object ... fields) throws SQLException {
        return (T)((DaoBean)this.getManagerForClass(type).loadUniqueByWhere(where, fields));
    }

    public int deleteAll(Class<?> type) throws SQLException {
        return this.getManagerForClass(type).deleteAll();
    }

    public int deleteByWhere(Class<?> type, String where) throws SQLException {
        return this.getManagerForClass(type).deleteByWhere(where);
    }

    public int deleteByWhere(Class<?> type, String where, Object ... fields) throws SQLException {
        return this.getManagerForClass(type).deleteByWhere(where, fields);
    }

    public <T extends DaoBean> T save(T bean) throws SQLException {
        return this.getManagerForClass(bean.getClass()).save(bean);
    }

    public <T extends DaoBean> T insert(T bean) throws SQLException {
        return this.getManagerForClass(bean.getClass()).insert(bean);
    }

    public <T extends DaoBean> T insert(T bean, boolean orUpdate) throws SQLException {
        return this.getManagerForClass(bean.getClass()).insert(bean, orUpdate);
    }

    public <T extends DaoBean> T insert(T bean, boolean orUpdate, boolean delayed) throws SQLException {
        return this.getManagerForClass(bean.getClass()).insert(bean, orUpdate, delayed);
    }

    public <T extends DaoBean> T update(T bean) throws SQLException {
        return this.getManagerForClass(bean.getClass()).update(bean);
    }

    public <T extends DaoBean> List<T> save(List<T> beans) throws SQLException {
        if (beans == null || beans.size() < 1) {
            return beans;
        }
        Class<?> type = ((DaoBean)beans.get(0)).getClass();
        return this.getManagerForClass(type).save(beans);
    }

    public <T extends DaoBean> List<T> insert(List<T> beans) throws SQLException {
        if (beans == null || beans.size() < 1) {
            return beans;
        }
        Class<?> type = ((DaoBean)beans.get(0)).getClass();
        return this.getManagerForClass(type).insert(beans);
    }

    public <T extends DaoBean> List<T> update(List<T> beans) throws SQLException {
        if (beans == null || beans.size() < 1) {
            return beans;
        }
        Class<?> type = ((DaoBean)beans.get(0)).getClass();
        return this.getManagerForClass(type).update(beans);
    }

    public <T extends DaoBean> T loadUniqueUsingTemplate(T bean) throws SQLException {
        return this.getManagerForClass(bean.getClass()).loadUniqueUsingTemplate(bean);
    }

    public <T extends DaoBean> List<T> loadUsingTemplate(Class<T> type, T bean) throws SQLException {
        return this.getManagerForClass(type).loadUsingTemplate(bean);
    }

    public <T extends DaoBean> List<T> loadUsingTemplate(T bean, int startRow, int numRows) throws SQLException {
        return this.getManagerForClass(bean.getClass()).loadUsingTemplate(bean, startRow, numRows);
    }

    public <T extends DaoBean> List<T> loadUsingTemplate(T bean, int startRow, int numRows, int searchType) throws SQLException {
        return this.getManagerForClass(bean.getClass()).loadUsingTemplate(bean, startRow, numRows, searchType);
    }

    public <T extends DaoBean> boolean delete(T bean) throws SQLException {
        if (bean instanceof DaoBean) {
            if (bean.isNew()) {
                return false;
            }
            return this.getManagerForClass(bean.getClass()).deleteUsingTemplate(bean) > 0;
        }
        throw new IllegalArgumentException("Not a DaoBean " + bean.getClass().getName());
    }

    public <T extends DaoBean> int deleteUsingTemplate(T bean) throws SQLException {
        return this.getManagerForClass(bean.getClass()).deleteUsingTemplate(bean);
    }

    public int countAll(Class<?> type) throws SQLException {
        return this.getManagerForClass(type).countAll();
    }

    public int countWhere(Class<?> type, String where) throws SQLException {
        return this.getManagerForClass(type).countWhere(where);
    }

    public int countWhere(Class<?> type, String where, Object ... fields) throws SQLException {
        return this.getManagerForClass(type).countWhere(where, fields);
    }

    public <T extends DaoBean> int countUsingTemplate(T bean) throws SQLException {
        return this.getManagerForClass(bean.getClass()).countUsingTemplate(bean);
    }

    public <T extends DaoBean> int countUsingTemplate(T bean, int startRow, int numRows) throws SQLException {
        return this.getManagerForClass(bean.getClass()).countUsingTemplate(bean, startRow, numRows);
    }

    public <T extends DaoBean> int countUsingTemplate(T bean, int startRow, int numRows, int searchType) throws SQLException {
        return this.getManagerForClass(bean.getClass()).countUsingTemplate(bean, startRow, numRows, searchType);
    }

    public <T extends DaoBean> List<T> decodeResultSet(Class<T> type, ResultSet rs, int startRow, int numRows) throws SQLException {
        return this.getManagerForClass(type).decodeResultSet(rs, startRow, numRows);
    }

    public <T extends DaoBean> T decodeRow(Class<T> type, ResultSet rs) throws SQLException {
        return (T)((DaoBean)this.getManagerForClass(type).decodeRow(rs));
    }

    public <T extends DaoBean> T metaDataDecodeRow(Class<T> type, ResultSet rs) throws SQLException {
        return (T)((DaoBean)this.getManagerForClass(type).metaDataDecodeRow(rs));
    }

    public <T extends DaoBean> List<T> loadByPreparedStatement(Class<T> type, PreparedStatement ps) throws SQLException {
        return this.getManagerForClass(type).loadByPreparedStatement(ps);
    }

    public <T extends DaoBean> List<T> loadByPreparedStatement(Class<T> type, PreparedStatement ps, int startRow, int numRows) throws SQLException {
        return this.getManagerForClass(type).loadByPreparedStatement(ps, startRow, numRows);
    }

    public static Txn beginTransaction() {
        if (transaction.get() != null) {
            throw new IllegalStateException("Transaction already begun.");
        }
        transaction.set(new Txn());
        return transaction.get();
    }

    public static Txn beginTransaction(Txn.Isolation isolation) {
        if (transaction.get() != null) {
            throw new IllegalStateException("Transaction already begun.");
        }
        transaction.set(new Txn(isolation));
        return transaction.get();
    }

    public static Txn currentTransaction() {
        return transaction.get();
    }

    public static void commitTransaction() {
        if (transaction.get() == null) {
            throw new IllegalStateException("No transaction to commit.");
        }
        try {
            transaction.get().commit();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void endTransaction() {
        if (transaction.get() == null) {
            throw new IllegalStateException("No transaction to commit.");
        }
        if (transaction.get().isActive()) {
            Database.rollbackTransaction();
        }
        transaction.remove();
    }

    public static void rollbackTransaction() {
        if (transaction.get() == null) {
            throw new IllegalStateException("No transaction to rollback.");
        }
        try {
            transaction.get().rollback();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

