/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sql2java.lib;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class Txn {
    private final Isolation isolation;
    private DataSource dataSource;
    private boolean active;
    private Connection connection;

    public Txn() {
        this.isolation = Isolation.DEFAULT;
        this.active = false;
    }

    public Txn(Isolation isolation) {
        this.isolation = isolation;
        this.active = false;
    }

    public Txn(DataSource dataSource, Isolation isolation) {
        this.dataSource = dataSource;
        this.isolation = isolation;
        this.active = true;
    }

    public void setDataSource(DataSource dataSource) {
        if (this.dataSource != null) {
            throw new IllegalStateException();
        }
        this.dataSource = dataSource;
        this.active = true;
    }

    public boolean isDefault() {
        return this.isolation == Isolation.DEFAULT;
    }

    public boolean isActive() {
        return this.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws SQLException {
        if (this.connection == null || !this.active) {
            throw new IllegalStateException();
        }
        try {
            this.connection.commit();
        }
        finally {
            this.active = false;
            this.connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SQLException {
        if (this.connection == null || !this.active) {
            throw new IllegalStateException();
        }
        try {
            this.connection.rollback();
        }
        finally {
            this.active = false;
            this.connection.close();
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.dataSource == null || !this.active) {
            throw new IllegalStateException();
        }
        if (this.connection != null) {
            return this.connection;
        }
        this.connection = this.dataSource.getConnection();
        this.connection.setAutoCommit(false);
        this.connection.setTransactionIsolation(this.isolation.getLevel());
        return this.connection;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Isolation {
        DEFAULT(-1),
        READ_COMMITTED(2),
        READ_UNCOMMITTED(1),
        REPEATABLE_READ(4),
        SERIALIZABLE(8);

        final int level;

        private Isolation(int i) {
            this.level = i;
        }

        public int getLevel() {
            return this.level;
        }
    }
}

