/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sql2java;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import net.sourceforge.sql2java.Column;
import net.sourceforge.sql2java.Database;
import net.sourceforge.sql2java.StringUtilities;
import net.sourceforge.sql2java.Table;
import net.sourceforge.sql2java.UserCodeParser;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.FieldMethodizer;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public class CodeWriter {
    protected static Properties props;
    protected static String dateClassName;
    protected static String timeClassName;
    protected static String timestampClassName;
    protected Database db;
    protected Hashtable includeHash;
    protected Hashtable excludeHash;
    protected String basePackage;
    protected String destDir;
    protected String optimisticLockType;
    protected String optimisticLockColumn;
    public String classPrefix;
    protected VelocityContext vc;
    public Table table;
    protected VelocityContext current_vc;
    protected boolean useLibrary = false;
    protected String libraryPackage;
    String current_fullfilename = "";
    String current_filename = "";

    public CodeWriter(Database db, Properties props) {
        try {
            this.db = db;
            CodeWriter.props = props;
            dateClassName = props.getProperty("jdbc2java.date", "java.sql.Date");
            timeClassName = props.getProperty("jdbc2java.time", "java.sql.Time");
            timestampClassName = props.getProperty("jdbc2java.timestamp", "java.sql.Timestamp");
            this.basePackage = props.getProperty("mgrwriter.package");
            this.classPrefix = props.getProperty("mgrwriter.classprefix");
            this.excludeHash = this.setHash(props.getProperty("mgrwriter.exclude"));
            if (this.excludeHash.size() != 0) {
                System.out.println("Excluding the following tables: " + props.getProperty("mgrwriter.exclude"));
            }
            this.includeHash = this.setHash(props.getProperty("mgrwriter.include"));
            if (this.includeHash.size() != 0) {
                System.out.println("Including only the following tables: " + props.getProperty("mgrwriter.include"));
            }
            this.optimisticLockType = props.getProperty("optimisticlock.type", "none");
            this.optimisticLockColumn = props.getProperty("optimisticlock.column");
            if (this.basePackage == null) {
                throw new Exception("Missing property: mgrwriter.package");
            }
        }
        catch (Exception e) {
            System.err.println("Threw an exception in the CodeWriter constructor:" + e.getMessage());
            e.printStackTrace();
        }
    }

    public void setUseLibrary(String libraryPackage) {
        this.useLibrary = true;
        this.libraryPackage = libraryPackage;
    }

    public void setDestinationFolder(String destDir) throws Exception {
        this.destDir = destDir;
        if (destDir == null) {
            throw new Exception("Missing property: mgrwriter.destdir");
        }
        File dir = new File(destDir);
        try {
            dir.mkdirs();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!dir.isDirectory() || !dir.canWrite()) {
            throw new Exception("Cannot write to: " + destDir);
        }
    }

    private Hashtable setHash(String str) {
        if (str == null || str.trim().equals("")) {
            return new Hashtable();
        }
        Hashtable<String, String> hash = new Hashtable<String, String>();
        StringTokenizer st = new StringTokenizer(str);
        while (st.hasMoreTokens()) {
            String val = st.nextToken().toLowerCase();
            hash.put(val, val);
        }
        return hash;
    }

    public boolean checkTable(Table table) throws Exception {
        System.out.println("    checking table " + table.getName() + " ...");
        boolean error = false;
        Column[] primaryKeys = table.getPrimaryKeys();
        if (table.getColumns().length == 0) {
            System.err.println("        WARN : no column found !");
            error = false;
        }
        if (primaryKeys.length == 0) {
            System.err.println("        WARN : No primary key is defined on table " + table.getName());
            System.err.println("            Tables without primary key are not fully supported");
            error = false;
        } else if (primaryKeys.length > 1) {
            System.err.print("        WARN : Composite primary key ");
            for (int ii = 0; ii < primaryKeys.length; ++ii) {
                System.err.print(primaryKeys[ii].getFullName() + ", ");
            }
            System.err.println();
            System.err.println("            Tables with composite primary key are not fully supported");
        } else {
            String normalKey;
            Column pk = primaryKeys[0];
            String pkName = pk.getName();
            if (!pkName.equalsIgnoreCase(normalKey = table.getName() + "_id")) {
                System.err.println("          WARN : primary key should of form <TABLE_NAME>_ID");
                System.err.println("              found " + pkName + " expected " + normalKey);
            }
            if (!pk.isColumnNumeric()) {
                System.err.println("          WARN : primary key should be an integer ");
                System.err.println("              found " + pk.getJavaType());
            }
        }
        return error;
    }

    public void checkDatabase() throws Exception {
        System.out.println("Checking database tables");
        boolean error = false;
        Table[] tables = this.db.getTables();
        for (int i = 0; i < tables.length; ++i) {
            boolean b;
            if (this.includeHash.size() != 0) {
                if (this.includeHash.get(tables[i].getName().toLowerCase()) == null || this.excludeHash.get(tables[i].getName().toLowerCase()) != null || !(b = this.checkTable(tables[i]))) continue;
                error = true;
                continue;
            }
            if (this.excludeHash.size() != 0) {
                if (this.excludeHash.get(tables[i].getName().toLowerCase()) != null || !(b = this.checkTable(tables[i]))) continue;
                error = true;
                continue;
            }
            b = this.checkTable(tables[i]);
            if (!b) continue;
            error = true;
        }
        if (error) {
            System.err.println("    Failed : at least one of the mandatory rule for sql2java is followed by your schema.");
            System.err.println("    Please check the documentation for more information");
            System.exit(-1);
        }
        System.out.println("    Passed.");
    }

    public void cleanup() {
        if (this.db != null) {
            this.db.cleanup();
        }
    }

    public synchronized void process() throws Exception {
        if ("true".equalsIgnoreCase(props.getProperty("check.database"))) {
            this.checkDatabase();
        }
        if ("true".equalsIgnoreCase(props.getProperty("check.only.database"))) {
            return;
        }
        Properties vprops = new Properties();
        vprops.put("runtime.log", "target/velocity.log");
        vprops.put("resource.loader", "classpath");
        vprops.put("classpath.resource.loader.class", ClasspathResourceLoader.class.getName());
        Velocity.init((Properties)vprops);
        this.vc = new VelocityContext();
        this.vc.put("CodeWriter", (Object)new FieldMethodizer((Object)this));
        this.vc.put("codewriter", (Object)this);
        this.vc.put("pkg", (Object)this.basePackage);
        this.vc.put("pkgPath", (Object)this.basePackage.replace('.', '/'));
        this.vc.put("useLib", (Object)this.useLibrary);
        this.vc.put("libPath", (Object)this.libraryPackage);
        this.vc.put("strUtil", (Object)StringUtilities.getInstance());
        this.vc.put("db", (Object)this.db);
        this.current_vc = new VelocityContext((Context)this.vc);
        System.out.println("Generation in folder " + this.destDir + " ...");
        String[] schema_templates = CodeWriter.getPropertyExploded("mgrwriter.templates.perschema");
        for (int i = 0; i < schema_templates.length; ++i) {
            this.writeComponent(schema_templates[i]);
        }
        if ("true".equalsIgnoreCase(props.getProperty("write.only.per.schema.templates"))) {
            return;
        }
        Table[] tables = this.db.getTables();
        for (int i = 0; i < tables.length; ++i) {
            if (this.includeHash.size() != 0) {
                if (this.includeHash.get(tables[i].getName().toLowerCase()) == null || this.excludeHash.get(tables[i].getName().toLowerCase()) != null) continue;
                this.writeTable(tables[i]);
                continue;
            }
            if (this.excludeHash.size() != 0) {
                if (this.excludeHash.get(tables[i].getName().toLowerCase()) != null || this.includeHash.get(tables[i].getName().toLowerCase()) == null) continue;
                this.writeTable(tables[i]);
                continue;
            }
            this.writeTable(tables[i]);
        }
    }

    private void writeTable(Table table) throws Exception {
        Column[] cs = table.getColumns();
        if (cs.length == 0) {
            return;
        }
        this.current_vc = new VelocityContext((Context)this.vc);
        this.table = table;
        this.current_vc.put("table", (Object)table);
        String[] table_templates = CodeWriter.getPropertyExploded("mgrwriter.templates.pertable");
        for (int i = 0; i < table_templates.length; ++i) {
            this.writeComponent(table_templates[i]);
        }
    }

    public void writeComponent(String templateName) throws Exception {
        Template template = null;
        try {
            template = Velocity.getTemplate((String)templateName);
        }
        catch (ResourceNotFoundException rnfe) {
            rnfe.printStackTrace();
            System.err.println("Aborted writing component:" + templateName + (this.table != null ? " for table:" + this.table.getName() : "") + " because Velocity could not find the resource.");
            return;
        }
        catch (ParseErrorException pee) {
            pee.printStackTrace();
            System.err.println("Aborted writing component:" + templateName + (this.table != null ? " for table:" + this.table.getName() : "") + " because there was a parse error in the resource.\n" + pee.getLocalizedMessage());
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Aborted writing component:" + templateName + (this.table != null ? " for table:" + this.table.getName() : "") + " there was an error initializing the template.\n" + e.getLocalizedMessage());
            return;
        }
        StringWriter sw = new StringWriter();
        Velocity.mergeTemplate((String)templateName, (String)"ISO-8859-1", (Context)this.current_vc, (Writer)sw);
        File file = new File(this.current_fullfilename);
        new File(file.getParent()).mkdirs();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(new FileOutputStream(this.current_fullfilename)));
        writer.write(sw.toString());
        writer.flush();
        writer.close();
        System.out.println("    " + this.current_filename + " done.");
    }

    public void setCurrentFilename(String relpath_or_package, String fn) throws Exception {
        this.current_filename = relpath_or_package.replace('.', File.separatorChar) + File.separatorChar + fn;
        this.current_fullfilename = this.destDir + File.separatorChar + relpath_or_package.replace('.', File.separatorChar) + File.separatorChar + fn;
        UserCodeParser uc = new UserCodeParser(this.current_fullfilename);
        this.current_vc.put("userCode", (Object)uc);
    }

    public void setCurrentJavaFilename(String relpath_or_package, String fn) throws Exception {
        this.setCurrentFilename(relpath_or_package, fn);
    }

    public void log(String logStr) {
        System.out.println("        " + logStr);
    }

    public String getClassPrefix() {
        return this.classPrefix;
    }

    public Database getDb() {
        return this.db;
    }

    public List getTables() {
        Table[] tabs = this.db.getTables();
        ArrayList<Table> tables = new ArrayList<Table>(tabs.length);
        for (int i = 0; i < tabs.length; ++i) {
            tables.add(tabs[i]);
        }
        return tables;
    }

    public Table getTable(String tableName) {
        return this.db.getTable(tableName);
    }

    public String tableName() {
        if (this.table == null) {
            return "";
        }
        return this.table.getName();
    }

    public List getColumns() {
        Column[] cols = this.table.getColumns();
        ArrayList<Column> columns = new ArrayList<Column>(cols.length);
        for (int i = 0; i < cols.length; ++i) {
            columns.add(cols[i]);
        }
        return columns;
    }

    public List getImportedKeys() {
        Column[] cols = this.table.getImportedKeys();
        ArrayList<Column> columns = new ArrayList<Column>(cols.length);
        for (int i = 0; i < cols.length; ++i) {
            columns.add(cols[i]);
        }
        return columns;
    }

    public List getForeignKeys() {
        Column[] cols = this.table.getForeignKeys();
        ArrayList<Column> columns = new ArrayList<Column>(cols.length);
        for (int i = 0; i < cols.length; ++i) {
            columns.add(cols[i]);
        }
        return columns;
    }

    public List getPrimaryKeys() {
        Column[] cols = this.table.getPrimaryKeys();
        ArrayList<Column> columns = new ArrayList<Column>(cols.length);
        for (int i = 0; i < cols.length; ++i) {
            columns.add(cols[i]);
        }
        return columns;
    }

    public boolean hasRemarks() {
        String remarks = this.table.getRemarks();
        return remarks != null && remarks.length() > 0;
    }

    public String getRemarks() {
        return this.table.getRemarks();
    }

    public List getRelationTable() {
        Table[] rtabs = this.db.getRelationTable(this.table);
        ArrayList<Table> tables = new ArrayList<Table>(rtabs.length);
        for (int i = 0; i < rtabs.length; ++i) {
            tables.add(rtabs[i]);
        }
        return tables;
    }

    public List getLinkedTables(Table rTable) {
        Table[] ltabs = rTable.linkedTables(this.db, this.table);
        ArrayList<Table> tables = new ArrayList<Table>(ltabs.length);
        for (int i = 0; i < ltabs.length; ++i) {
            tables.add(ltabs[i]);
        }
        return tables;
    }

    public boolean isPresentLock(Collection cols) {
        Column[] columns = new Column[cols.size()];
        int i = 0;
        Iterator iter = cols.iterator();
        while (iter.hasNext()) {
            columns[i++] = (Column)iter.next();
        }
        return Column.isPresentLock(columns, this.optimisticLockType, this.optimisticLockColumn);
    }

    public Column getLockColumn(Collection cols) {
        for (Column col : cols) {
            if (!col.getName().equalsIgnoreCase(this.optimisticLockColumn)) continue;
            return col;
        }
        return null;
    }

    public Table getTable() {
        return this.table;
    }

    public boolean listContainsString(List list, String string) {
        Object obj = null;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            if (string.equals(obj)) {
                return true;
            }
            obj = iter.next();
        }
        return false;
    }

    public static String getProperty(String key) {
        String s = props.getProperty(key);
        return s != null ? s.trim() : s;
    }

    public static String getProperty(String key, String default_val) {
        String s = props.getProperty(key, default_val);
        return s != null ? s.trim() : s;
    }

    public static String[] getPropertyExploded(String key) {
        String v = CodeWriter.getProperty(key);
        if (v == null) {
            return new String[0];
        }
        ArrayList<String> al = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(v, " ,;\t");
        while (st.hasMoreTokens()) {
            al.add(st.nextToken().trim());
        }
        return al.toArray(new String[al.size()]);
    }
}

