/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sql2java;

import java.util.List;
import java.util.Vector;
import net.sourceforge.sql2java.CodeWriter;
import net.sourceforge.sql2java.Database;
import net.sourceforge.sql2java.Main;
import net.sourceforge.sql2java.StringUtilities;
import net.sourceforge.sql2java.Table;

public class Column
implements Cloneable {
    public static final int M_ARRAY = 0;
    public static final int M_BIGDECIMAL = 1;
    public static final int M_BOOLEAN = 2;
    public static final int M_BYTES = 3;
    public static final int M_CLOB = 4;
    public static final int M_SQLDATE = 5;
    public static final int M_UTILDATE = 6;
    public static final int M_DOUBLE = 7;
    public static final int M_FLOAT = 8;
    public static final int M_BLOB = 9;
    public static final int M_INTEGER = 10;
    public static final int M_LONG = 11;
    public static final int M_REF = 12;
    public static final int M_STRING = 13;
    public static final int M_TIME = 14;
    public static final int M_TIMESTAMP = 15;
    public static final int M_URL = 16;
    public static final int M_OBJECT = 17;
    private String catalog;
    private String schema;
    private String tableName;
    private String name;
    private String remarks;
    private String defaultValue;
    private int size;
    private int decDigits;
    private int radix;
    private int nullable;
    private int ordinal;
    private short type;
    private boolean isPrimaryKey;
    private String strCheckingType = "";
    private Database db;
    private List foreignKeys = new Vector();
    private List importedKeys = new Vector();

    public String toString() {
        return "\n --------- " + this.tableName + "." + this.name + " --------- " + "\n schema        = " + this.schema + "\n tableName     = " + this.tableName + "\n catalog       = " + this.catalog + "\n remarks       = " + this.remarks + "\n defaultValue  = " + this.defaultValue + "\n decDigits     = " + this.decDigits + "\n radix         = " + this.radix + "\n nullable      = " + this.nullable + "\n ordinal       = " + this.ordinal + "\n size          = " + this.size + "\n type          = " + this.type + " " + "\n isPrimaryKey  = " + (this.isPrimaryKey ? "true" : "false");
    }

    public void setCheckingType(String strValue) {
        this.strCheckingType = strValue;
    }

    public String getCheckingType() {
        return this.strCheckingType;
    }

    public void setDatabase(Database db) {
        this.db = db;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(short type) {
        this.type = type;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setDecimalDigits(int decDigits) {
        this.decDigits = decDigits;
    }

    public void setRadix(int radix) {
        this.radix = radix;
    }

    public void setNullable(int nullable) {
        this.nullable = nullable;
    }

    public void setRemarks(String remarks) {
        if (remarks != null) {
            this.remarks = remarks.replaceAll("/\\*", "SLASH*").replaceAll("\\*/", "*SLASH");
        }
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setOrdinalPosition(int ordinal) {
        this.ordinal = ordinal;
    }

    public void isPrimaryKey(boolean isPrimaryKey) {
        this.isPrimaryKey = isPrimaryKey;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getName() {
        return this.name;
    }

    public short getType() {
        return this.type;
    }

    public int getSize() {
        return this.size;
    }

    public int getDecimalDigits() {
        return this.decDigits;
    }

    public int getRadix() {
        return this.radix;
    }

    public int getNullable() {
        return this.nullable;
    }

    public String getNullableAsString() {
        return this.getNullable() != 0 ? "nullable" : "null not allowed";
    }

    public String getRemarks() {
        return this.remarks == null ? "" : this.remarks;
    }

    public String getDefaultValue() {
        return this.defaultValue == null ? "" : this.defaultValue;
    }

    public int getOrdinalPosition() {
        return this.ordinal;
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public String getFullName() {
        return this.tableName + "." + this.getName();
    }

    public String getConstName() {
        return this.getName().toUpperCase();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void tuoe() {
        throw new UnsupportedOperationException("not supported yet: " + this.getTableName() + "." + this.getName() + " " + this.getJavaTypeAsTypeName());
    }

    private void tiae() {
        throw new IllegalArgumentException("No primary type associated: " + this.getTableName() + "." + this.getName());
    }

    public int getMappedType() {
        switch (this.getType()) {
            case 2003: {
                return 0;
            }
            case -5: {
                return 11;
            }
            case -2: {
                return 3;
            }
            case -7: {
                return 2;
            }
            case 2004: {
                return 9;
            }
            case 16: {
                return 2;
            }
            case 1: {
                return 13;
            }
            case 2005: {
                return 4;
            }
            case 70: {
                return 16;
            }
            case 91: {
                if (CodeWriter.dateClassName.equals("java.util.Date")) {
                    return 6;
                }
                if (CodeWriter.dateClassName.equals("java.sql.Date")) {
                    return 5;
                }
                this.tuoe();
            }
            case 3: {
                return this.getDecimalDigits() > 0 ? 1 : 11;
            }
            case 2001: {
                return 17;
            }
            case 8: {
                return 7;
            }
            case 6: {
                return 7;
            }
            case 4: {
                return 10;
            }
            case 2000: {
                return 17;
            }
            case -4: {
                return 3;
            }
            case -1: {
                return 13;
            }
            case 2: {
                return this.getDecimalDigits() > 0 ? 1 : 11;
            }
            case 1111: {
                return 17;
            }
            case 7: {
                return 8;
            }
            case 2006: {
                return 12;
            }
            case 5: {
                return 10;
            }
            case 2002: {
                return 17;
            }
            case 92: {
                if (CodeWriter.timeClassName.equals("java.util.Date")) {
                    return 6;
                }
                if (CodeWriter.timeClassName.equals("java.sql.Time")) {
                    return 14;
                }
                this.tuoe();
            }
            case 93: {
                if (CodeWriter.timestampClassName.equals("java.util.Date")) {
                    return 6;
                }
                if (CodeWriter.timestampClassName.equals("java.sql.Timestamp")) {
                    return 15;
                }
                this.tuoe();
            }
            case -6: {
                return 10;
            }
            case -3: {
                return 3;
            }
            case 12: {
                return 13;
            }
        }
        this.tuoe();
        return -1;
    }

    public String getJavaType() {
        switch (this.getMappedType()) {
            case 0: {
                return "Array";
            }
            case 1: {
                return "java.math.BigDecimal";
            }
            case 2: {
                return "Boolean";
            }
            case 3: {
                return "byte[]";
            }
            case 4: {
                return "String";
            }
            case 5: {
                return "java.sql.Date";
            }
            case 6: {
                return "java.util.Date";
            }
            case 7: {
                return "Double";
            }
            case 8: {
                return "Float";
            }
            case 10: {
                return "Integer";
            }
            case 11: {
                return "Long";
            }
            case 12: {
                return "Ref";
            }
            case 13: {
                return "String";
            }
            case 14: {
                return "java.sql.Time";
            }
            case 15: {
                return "java.sql.Timestamp";
            }
            case 16: {
                return "java.net.URL";
            }
            case 17: {
                return "Object";
            }
        }
        return null;
    }

    public boolean hasPrimaryType() {
        return this.getJavaPrimaryType() != null;
    }

    public String getJavaPrimaryType() throws IllegalArgumentException {
        int decimalDigits = this.getDecimalDigits();
        short type = this.getType();
        int size = this.getSize();
        if ((type == 3 || type == 2) && decimalDigits == 0) {
            if (size == 1) {
                return "boolean";
            }
            if (size < 3) {
                return "byte";
            }
            if (size < 5) {
                return "short";
            }
            if (size < 10) {
                return "int";
            }
            if (size < 19) {
                return "long";
            }
            return "java.math.BigDecimal";
        }
        switch (this.getMappedType()) {
            case 2: {
                return "boolean";
            }
            case 5: {
                return "long";
            }
            case 6: {
                return "long";
            }
            case 7: {
                return "double";
            }
            case 8: {
                return "float";
            }
            case 10: {
                return "int";
            }
            case 11: {
                return "long";
            }
            case 14: {
                return "long";
            }
            case 15: {
                return "long";
            }
        }
        return null;
    }

    public String getJavaTypeAsTypeName() {
        switch (this.getType()) {
            case 2003: {
                return "Types.ARRAY";
            }
            case -5: {
                return "Types.BIGINT";
            }
            case -2: {
                return "Types.BINARY";
            }
            case -7: {
                return "Types.BIT";
            }
            case 2004: {
                return "Types.BLOB";
            }
            case 16: {
                return "Types.BOOLEAN";
            }
            case 1: {
                return "Types.CHAR";
            }
            case 2005: {
                return "Types.CLOB";
            }
            case 70: {
                return "Types.DATALINK";
            }
            case 91: {
                return "Types.DATE";
            }
            case 3: {
                return "Types.DECIMAL";
            }
            case 2001: {
                return "Types.DISTINCT";
            }
            case 8: {
                return "Types.DOUBLE";
            }
            case 6: {
                return "Types.FLOAT";
            }
            case 4: {
                return "Types.INTEGER";
            }
            case 2000: {
                return "Types.JAVA_OBJECT";
            }
            case -4: {
                return "Types.LONGVARBINARY";
            }
            case -1: {
                return "Types.LONGVARCHAR";
            }
            case 0: {
                return "Types.NULL";
            }
            case 2: {
                return "Types.NUMERIC";
            }
            case 1111: {
                return "Types.OTHER";
            }
            case 7: {
                return "Types.REAL";
            }
            case 2006: {
                return "Types.REF";
            }
            case 5: {
                return "Types.SMALLINT";
            }
            case 2002: {
                return "Types.STRUCT";
            }
            case 92: {
                return "Types.TIME";
            }
            case 93: {
                return "Types.TIMESTAMP";
            }
            case -6: {
                return "Types.TINYINT";
            }
            case -3: {
                return "Types.VARBINARY";
            }
            case 12: {
                return "Types.VARCHAR";
            }
        }
        this.tuoe();
        return null;
    }

    public boolean isColumnNumeric() {
        switch (this.getMappedType()) {
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    public boolean isString() {
        return this.getMappedType() == 13;
    }

    public boolean hasCompareTo() throws Exception {
        switch (this.getMappedType()) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
            case 4: {
                return false;
            }
            case 5: {
                return true;
            }
            case 6: {
                return true;
            }
            case 7: {
                return true;
            }
            case 8: {
                return true;
            }
            case 10: {
                return true;
            }
            case 11: {
                return true;
            }
            case 12: {
                return false;
            }
            case 13: {
                return true;
            }
            case 14: {
                return true;
            }
            case 15: {
                return true;
            }
            case 16: {
                return false;
            }
            case 17: {
                return false;
            }
        }
        return false;
    }

    public boolean useEqualsInSetter() throws Exception {
        switch (this.getMappedType()) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public String getResultSetMethodObject(String pos) {
        return this.getResultSetMethodObject("rs", pos);
    }

    public String getResultSetMethodObject(String resultSet, String pos) {
        switch (this.getMappedType()) {
            case 0: {
                return resultSet + ".getArray(" + pos + ")";
            }
            case 11: {
                return "getLong(" + resultSet + ", " + pos + ")";
            }
            case 3: {
                return resultSet + ".getBytes(" + pos + ")";
            }
            case 9: {
                return resultSet + ".getBlob(" + pos + ")";
            }
            case 2: {
                return "getBoolean(" + resultSet + ", " + pos + ")";
            }
            case 13: {
                return resultSet + ".getString(" + pos + ")";
            }
            case 4: {
                return "getStringFromClob(" + resultSet + ", " + pos + ")";
            }
            case 16: {
                return resultSet + ".getURL(" + pos + ")";
            }
            case 1: {
                return resultSet + ".getBigDecimal(" + pos + ")";
            }
            case 7: {
                return "getDouble(" + resultSet + ", " + pos + ")";
            }
            case 8: {
                return "getFloat(" + resultSet + ", " + pos + ")";
            }
            case 10: {
                return "getInteger(" + resultSet + ", " + pos + ")";
            }
            case 17: {
                return resultSet + ".getObject(" + pos + ")";
            }
            case 12: {
                return resultSet + ".getRef(" + pos + ")";
            }
            case 5: {
                return resultSet + ".getDate(" + pos + ")";
            }
            case 14: {
                return resultSet + ".getTime(" + pos + ")";
            }
            case 15: {
                return resultSet + ".getTimestamp(" + pos + ")";
            }
            case 6: {
                switch (this.getType()) {
                    case 92: {
                        return resultSet + ".getTime(" + pos + ")";
                    }
                    case 93: {
                        return resultSet + ".getTimestamp(" + pos + ")";
                    }
                    case 91: {
                        return resultSet + ".getDate(" + pos + ")";
                    }
                }
            }
        }
        this.tuoe();
        return null;
    }

    public String getPreparedStatementMethod(String var, int pos) {
        return this.getPreparedStatementMethod(var, Integer.toString(pos));
    }

    public String getPreparedStatementMethod(String var, String pos) {
        switch (this.getMappedType()) {
            case 0: {
                return "ps.setArray(" + pos + ", " + var + ");";
            }
            case 11: {
                return "setLong(ps, " + pos + ", " + var + ");";
            }
            case 3: {
                return "ps.setBytes(" + pos + ", " + var + ");";
            }
            case 9: {
                return "ps.setBlob(" + pos + ", " + var + ");";
            }
            case 2: {
                return "setBoolean(ps, " + pos + ", " + var + ");";
            }
            case 13: {
                return "ps.setString(" + pos + ", " + var + ");";
            }
            case 4: {
                return "setClob(ps, " + pos + ", " + var + ");";
            }
            case 16: {
                return "ps.setURL(" + pos + ", " + var + ");";
            }
            case 1: {
                return "ps.setBigDecimal(" + pos + ", " + var + ");";
            }
            case 7: {
                return "setDouble(ps, " + pos + ", " + var + ");";
            }
            case 10: {
                return "setInteger(ps, " + pos + ", " + var + ");";
            }
            case 17: {
                return "ps.setObject(" + pos + ", " + var + ");";
            }
            case 8: {
                return "setFloat(ps, " + pos + ", " + var + ");";
            }
            case 5: {
                return "ps.setDate(" + pos + ", " + var + ");";
            }
            case 14: {
                return "ps.setTime(" + pos + ", " + var + ");";
            }
            case 15: {
                return "ps.setTimestamp(" + pos + ", " + var + ");";
            }
            case 6: {
                switch (this.getType()) {
                    case 93: {
                        return "if (" + var + " == null) ps.setNull(" + pos + ", " + this.getJavaTypeAsTypeName() + "); else ps.setTimestamp(" + pos + ", new java.sql.Timestamp(" + var + ".getTime()));";
                    }
                    case 91: {
                        return "if (" + var + " == null) ps.setNull(" + pos + ", " + this.getJavaTypeAsTypeName() + "); else ps.setDate(" + pos + ", new java.sql.Date(" + var + ".getTime()));";
                    }
                    case 92: {
                        return "if (" + var + " == null) ps.setNull(" + pos + ", " + this.getJavaTypeAsTypeName() + "); else ps.setTime(" + pos + ", new java.sql.Time(" + var + ".getTime()));";
                    }
                }
                return null;
            }
            case 12: {
                return "ps.setRef(" + pos + ", " + var + ");";
            }
        }
        return "ps.setObject(" + pos + ", " + var + ");";
    }

    public String getStringConvertionMethod() {
        switch (this.getMappedType()) {
            case 1: {
                return "new java.math.BigDecimal";
            }
            case 2: {
                return "new Boolean";
            }
            case 5: {
                return "new java.sql.Date";
            }
            case 7: {
                return "new Double";
            }
            case 8: {
                return "new Float";
            }
            case 10: {
                return "new Integer";
            }
            case 11: {
                return "new Long";
            }
            case 13: {
                return "";
            }
            case 6: 
            case 14: 
            case 15: {
                if (CodeWriter.dateClassName.equals("java.util.GregorianCalendar")) {
                    return "GregorianDate";
                }
                return "getDateFromString";
            }
        }
        System.err.println("type unknown for " + this.getFullName());
        return "";
    }

    public String getDefaultWidget() {
        if (this.isForeignKey()) {
            return "SelectWidget";
        }
        if (this.isString() && (this.getSize() > 200 || this.getSize() == -1)) {
            return "TextAreaWidget";
        }
        switch (this.getMappedType()) {
            case 2: {
                return "BooleanWidget";
            }
            case 5: 
            case 6: 
            case 14: 
            case 15: {
                return "DateWidget";
            }
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                return "InputWidget";
            }
        }
        System.err.println("type unknown for " + this.getFullName());
        return "";
    }

    static boolean isPresentLock(Column[] cols, String optimisticLockType, String optimisticLockColumn) {
        boolean retVal = false;
        if (optimisticLockType.equalsIgnoreCase("timestamp")) {
            for (int i = 0; i < cols.length; ++i) {
                if (!cols[i].getName().equalsIgnoreCase(optimisticLockColumn) || cols[i].getMappedType() != 11 && cols[i].getMappedType() != 13) continue;
                retVal = true;
                break;
            }
        }
        return retVal;
    }

    public Table getTable() {
        return this.db.getTable(this.getTableName());
    }

    public void addForeignKey(Column col) {
        this.foreignKeys.add(col);
        this.getTable().addForeignKey(this);
    }

    public List getForeignKeys() {
        return this.foreignKeys;
    }

    public void addImportedKey(Column col) {
        this.importedKeys.add(col);
        this.getTable().addImportedKey(col);
    }

    public List getImportedKeys() {
        return this.importedKeys;
    }

    public int countImportedKeys() {
        return this.importedKeys.size();
    }

    public boolean isImportedKey() {
        return this.countImportedKeys() > 0;
    }

    public Column getForeignColumn() {
        return (Column)this.foreignKeys.get(0);
    }

    public int countForeignKeys() {
        return this.foreignKeys.size();
    }

    public boolean isForeignKey() {
        return this.countForeignKeys() > 0;
    }

    public String getPropertyTag() {
        return (this.getTableName() + "." + this.getName()).toLowerCase();
    }

    public String getVarName() {
        return StringUtilities.convertName(this.getName(), true);
    }

    public String getDefaultRules() {
        String rule = "";
        rule = this.getNullable() == 0 && !this.isPrimaryKey() ? rule + " nullnotallowed" : rule + " nullallowed";
        if (this.getType() == 91 || this.getType() == 93) {
            rule = rule + " dateformat";
        }
        return rule;
    }

    public boolean columnFor(String type) {
        String property = "table." + this.getTableName().toLowerCase() + ".in." + type.toLowerCase();
        String[] exclude = CodeWriter.getPropertyExploded(property + ".exclude");
        String[] include = CodeWriter.getPropertyExploded(property + ".include");
        if (exclude.length == 0 && include.length == 0) {
            return true;
        }
        if (Main.isInArray(include, this.getName())) {
            return true;
        }
        if (Main.isInArray(exclude, this.getName())) {
            return false;
        }
        return include.length == 0;
    }
}

