/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sql2java;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.sourceforge.sql2java.CodeWriter;
import net.sourceforge.sql2java.Column;
import net.sourceforge.sql2java.Database;

public class Table {
    private Hashtable colHash = new Hashtable();
    private Vector cols = new Vector();
    private Vector priKey = new Vector();
    private Hashtable manyToManyHash = new Hashtable();
    private String catalog;
    private String schema;
    private String name;
    private String type;
    private String remarks;
    private Database db;
    private Vector foreignKeys = new Vector();
    private Vector importedKeys = new Vector();

    public boolean isRelationTable() {
        return this.importedKeys.size() > 1;
    }

    public boolean relationConnectsTo(Table otherTable) {
        if (this.equals(otherTable)) {
            return false;
        }
        for (int i = 0; i < this.foreignKeys.size(); ++i) {
            Column c = (Column)this.importedKeys.get(i);
            if (!c.getTableName().equals(otherTable.getName())) continue;
            return true;
        }
        return false;
    }

    public Table[] linkedTables(Database pDatabase, Table pTable) {
        Vector<Table> vector = new Vector<Table>();
        for (int iIndex = 0; iIndex < this.importedKeys.size(); ++iIndex) {
            Table pTableToAdd;
            Column pColumn = (Column)this.importedKeys.get(iIndex);
            if (pColumn.getTableName().equals(pTable.getName()) || vector.contains(pTableToAdd = pDatabase.getTable(pColumn.getTableName()))) continue;
            vector.add(pTableToAdd);
        }
        return vector.toArray(new Table[0]);
    }

    public Column getForeignKeyFor(Table pTable) {
        Vector vector = new Vector();
        for (int iIndex = 0; iIndex < this.importedKeys.size(); ++iIndex) {
            Column pColumn = (Column)this.importedKeys.get(iIndex);
            if (!pColumn.getTableName().equals(pTable.getName())) continue;
            return pColumn;
        }
        return null;
    }

    public void setDatabase(Database db) {
        this.db = db;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setRemarks(String remarks) {
        if (remarks != null) {
            this.remarks = remarks.replaceAll("/\\*", "SLASH*").replaceAll("\\*/", "*SLASH");
        }
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getRemarks() {
        return this.remarks == null ? "" : this.remarks;
    }

    public Column[] getColumns() {
        return this.cols.toArray(new Column[0]);
    }

    public Column getColumn(String name) {
        return (Column)this.colHash.get(name.toLowerCase());
    }

    public void addColumn(Column column) {
        this.colHash.put(column.getName().toLowerCase(), column);
        this.cols.addElement(column);
    }

    public void removeColumn(Column column) {
        this.cols.removeElement(column);
        this.colHash.remove(column.getName().toLowerCase());
    }

    public Column[] getPrimaryKeys() {
        return this.priKey.toArray(new Column[0]);
    }

    public void addPrimaryKey(Column column) {
        this.priKey.addElement(column);
        column.isPrimaryKey(true);
    }

    public Column[] getImportedKeys() {
        return this.importedKeys.toArray(new Column[0]);
    }

    public void addImportedKey(Column column) {
        if (!this.importedKeys.contains(column)) {
            this.importedKeys.addElement(column);
        }
    }

    public Column[][] getManyToManyKeys() {
        Column[][] list = new Column[this.manyToManyHash.size()][2];
        int i = 0;
        Enumeration e = this.manyToManyHash.keys();
        while (e.hasMoreElements()) {
            Column fk = (Column)e.nextElement();
            Column pk = (Column)this.manyToManyHash.get(fk);
            list[i][0] = fk;
            list[i][1] = pk;
            ++i;
        }
        return list;
    }

    public void addManyToManyKey(Column fk, Column pk) {
        this.manyToManyHash.put(fk, pk);
    }

    public int countColumns() {
        return this.cols.size();
    }

    public int countPrimaryKeys() {
        return this.priKey.size();
    }

    public boolean hasPrimaryKey() {
        return this.countPrimaryKeys() > 0;
    }

    public int countImportedKeys() {
        return this.importedKeys.size();
    }

    public boolean hasImportedKeys() {
        return this.countImportedKeys() > 0;
    }

    public int countForeignKeys() {
        return this.foreignKeys.size();
    }

    public boolean hasForeignKeys() {
        return this.countForeignKeys() > 0;
    }

    public void addForeignKey(Column col) {
        if (!this.foreignKeys.contains(col)) {
            this.foreignKeys.add(col);
        }
    }

    public Column[] getForeignKeys() {
        return this.foreignKeys.toArray(new Column[0]);
    }

    public boolean isForeignKey(Column col) {
        return this.foreignKeys.contains(col);
    }

    public Table[] getLinkedTables() {
        Table pTableToAdd;
        Column column;
        int iIndex;
        Vector<Table> vector = new Vector<Table>();
        for (iIndex = 0; iIndex < this.importedKeys.size(); ++iIndex) {
            column = (Column)this.importedKeys.get(iIndex);
            if (column.getTableName().equals(this.getName()) || vector.contains(pTableToAdd = column.getTable())) continue;
            vector.add(pTableToAdd);
        }
        for (iIndex = 0; iIndex < this.foreignKeys.size(); ++iIndex) {
            column = (Column)this.foreignKeys.get(iIndex);
            if ((column = column.getForeignColumn()).getTableName().equals(this.getName()) || vector.contains(pTableToAdd = column.getTable())) continue;
            vector.add(pTableToAdd);
        }
        return vector.toArray(new Table[0]);
    }

    private Table[] getImportedTablesFromVector(Vector keys) {
        Vector<Table> vector = new Vector<Table>();
        for (int iIndex = 0; iIndex < keys.size(); ++iIndex) {
            Table pTableToAdd;
            Column column = (Column)keys.get(iIndex);
            if (column.getTableName().equals(this.getName()) || vector.contains(pTableToAdd = column.getTable())) continue;
            vector.add(pTableToAdd);
        }
        return vector.toArray(new Table[0]);
    }

    public Table[] getImportedTables() {
        return this.getImportedTablesFromVector(this.importedKeys);
    }

    public Table[] getForeignTables() {
        return this.getImportedTablesFromVector(this.foreignKeys);
    }

    public String[] getLinkedPackages() {
        Vector<String> vector = new Vector<String>();
        Table[] linkedTables = this.getLinkedTables();
        for (int iIndex = 0; iIndex < linkedTables.length; ++iIndex) {
            if (vector.contains(linkedTables[iIndex].getPackage())) continue;
            vector.add(linkedTables[iIndex].getPackage());
        }
        return vector.toArray(new String[0]);
    }

    public String getPackage() {
        String[] tables;
        String basePackage = CodeWriter.getProperty("mgrwriter.package");
        int iterating = 1;
        do {
            String tablesProperty = "subpackage." + iterating + ".tables";
            String packageNameProperty = "subpackage." + iterating + ".name";
            tables = CodeWriter.getPropertyExploded(tablesProperty);
            for (int i = 0; i < tables.length; ++i) {
                if (!this.getName().equalsIgnoreCase(tables[i])) continue;
                String packageName = CodeWriter.getProperty(packageNameProperty);
                if (packageName == null) {
                    return basePackage;
                }
                return basePackage + "." + packageName;
            }
            ++iterating;
        } while (tables.length != 0);
        return basePackage;
    }

    public String getPackagePath() {
        return this.getPackage().replace('.', '/');
    }

    public Column[] getColumnsFor(String type) {
        Vector<Column> vector = new Vector<Column>();
        for (int i = 0; i < this.cols.size(); ++i) {
            Column c = (Column)this.cols.get(i);
            if (!c.columnFor(type)) continue;
            vector.add(c);
        }
        return vector.toArray(new Column[0]);
    }
}

