/*
 * Decompiled with CFR 0.152.
 */
package com.github.xplosunn.sanejava;

import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class PatternTreeVisitor
extends TreePathScanner<Void, Void> {
    private final SourcePositions sourcePositions;
    private final Trees trees;
    private final Types types;
    private final TypeMirror enumType;
    private CompilationUnitTree currCompUnit;
    private int issueCount;

    public PatternTreeVisitor(JavacTask task) {
        this.types = task.getTypes();
        this.trees = Trees.instance(task);
        this.sourcePositions = this.trees.getSourcePositions();
        Elements elements = task.getElements();
        this.enumType = elements.getTypeElement("java.lang.Enum").asType();
        this.issueCount = 0;
    }

    @Override
    public Void visitCompilationUnit(CompilationUnitTree tree, Void p) {
        this.currCompUnit = tree;
        Void visit = (Void)super.visitCompilationUnit(tree, p);
        if (this.issueCount > 0) {
            String errorMessage = "Found " + this.issueCount + " issues.";
            System.out.println(errorMessage);
            throw new IssueFoundException(errorMessage);
        }
        return visit;
    }

    @Override
    public Void visitSwitch(SwitchTree node, Void aVoid) {
        ParenthesizedTree expression = (ParenthesizedTree)node.getExpression();
        TypeMirror expressionTypeMirror = this.trees.getTypeMirror(new TreePath(this.getCurrentPath(), expression));
        if (this.isEnumExpression(expressionTypeMirror)) {
            EnumMembersVisitor enumMembersVisitor = new EnumMembersVisitor();
            this.types.asElement(expressionTypeMirror).accept(enumMembersVisitor, null);
            if (!this.allEnumMembersCovered(enumMembersVisitor.enumMembers, node.getCases())) {
                this.error(node);
            }
        }
        return (Void)super.visitSwitch(node, aVoid);
    }

    private boolean isEnumExpression(TypeMirror expressionTypeMirror) {
        return this.types.directSupertypes(expressionTypeMirror).stream().anyMatch(t -> this.types.erasure((TypeMirror)t).equals(this.types.erasure(this.enumType)));
    }

    private boolean allEnumMembersCovered(List<Element> elements, List<? extends CaseTree> caseTrees) {
        List found = caseTrees.stream().filter(caseTree -> caseTree.getExpression() != null).map(caseTree -> {
            ExpressionTree caseExpression = caseTree.getExpression();
            return caseExpression.toString();
        }).collect(Collectors.toList());
        boolean containsAll = found.containsAll(elements.stream().map(el -> el.getSimpleName().toString()).collect(Collectors.toList()));
        return containsAll;
    }

    private void error(Tree tree) {
        ++this.issueCount;
        System.out.println(PatternTreeVisitor.errorMessage(this.getLineNumber(tree), this.currCompUnit.getSourceFile().toUri().toString()));
    }

    private long getLineNumber(Tree tree) {
        LineMap lineMap = this.currCompUnit.getLineMap();
        if (lineMap == null) {
            return -1L;
        }
        long position = this.sourcePositions.getStartPosition(this.currCompUnit, tree);
        return lineMap.getLineNumber(position);
    }

    public static String errorMessage(long line, String file) {
        return "Found a non-exhaustive enum switch in " + file + ":" + line;
    }

    private static class EnumMembersVisitor
    implements ElementVisitor<Void, Void> {
        private List<Element> enumMembers;

        private EnumMembersVisitor() {
        }

        @Override
        public Void visitType(TypeElement e, Void aVoid) {
            this.enumMembers = e.getEnclosedElements().stream().filter(elem -> elem.getKind().equals((Object)ElementKind.ENUM_CONSTANT)).collect(Collectors.toList());
            return null;
        }

        @Override
        public Void visit(Element e, Void aVoid) {
            return null;
        }

        @Override
        public Void visit(Element e) {
            return null;
        }

        @Override
        public Void visitPackage(PackageElement e, Void aVoid) {
            return null;
        }

        @Override
        public Void visitVariable(VariableElement e, Void aVoid) {
            return null;
        }

        @Override
        public Void visitExecutable(ExecutableElement e, Void aVoid) {
            return null;
        }

        @Override
        public Void visitTypeParameter(TypeParameterElement e, Void aVoid) {
            return null;
        }

        @Override
        public Void visitUnknown(Element e, Void aVoid) {
            return null;
        }
    }

    public static class IssueFoundException
    extends RuntimeException {
        public IssueFoundException(String message) {
            super(message);
        }
    }
}

