/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.api.sharedpreferences;

import android.content.SharedPreferences;
import com.googlecode.androidannotations.api.sharedpreferences.BooleanPrefEditorField;
import com.googlecode.androidannotations.api.sharedpreferences.FloatPrefEditorField;
import com.googlecode.androidannotations.api.sharedpreferences.IntPrefEditorField;
import com.googlecode.androidannotations.api.sharedpreferences.LongPrefEditorField;
import com.googlecode.androidannotations.api.sharedpreferences.SharedPreferencesCompat;
import com.googlecode.androidannotations.api.sharedpreferences.StringPrefEditorField;

public abstract class EditorHelper<T extends EditorHelper<T>> {
    private final SharedPreferences.Editor editor;

    public EditorHelper(SharedPreferences sharedPreferences) {
        this.editor = sharedPreferences.edit();
    }

    protected SharedPreferences.Editor getEditor() {
        return this.editor;
    }

    public final T clear() {
        this.editor.clear();
        return this.cast();
    }

    public final void apply() {
        SharedPreferencesCompat.apply(this.editor);
    }

    protected IntPrefEditorField<T> intField(String key) {
        return new IntPrefEditorField<T>(this.cast(), key);
    }

    protected StringPrefEditorField<T> stringField(String key) {
        return new StringPrefEditorField<T>(this.cast(), key);
    }

    protected BooleanPrefEditorField<T> booleanField(String key) {
        return new BooleanPrefEditorField<T>(this.cast(), key);
    }

    protected FloatPrefEditorField<T> floatField(String key) {
        return new FloatPrefEditorField<T>(this.cast(), key);
    }

    protected LongPrefEditorField<T> longField(String key) {
        return new LongPrefEditorField<T>(this.cast(), key);
    }

    private T cast() {
        return (T)this;
    }
}

