/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.processing;

import com.googlecode.androidannotations.annotations.Extra;
import com.googlecode.androidannotations.helper.APTCodeModelHelper;
import com.googlecode.androidannotations.helper.CanonicalNameConstants;
import com.googlecode.androidannotations.processing.DecoratingElementProcessor;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.googlecode.androidannotations.processing.EBeansHolder;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCatchBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPrimitiveType;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JType;
import com.sun.codemodel.JTypeVar;
import com.sun.codemodel.JVar;
import java.lang.annotation.Annotation;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class ExtraProcessor
implements DecoratingElementProcessor {
    private final APTCodeModelHelper helper = new APTCodeModelHelper();
    private final ProcessingEnvironment processingEnv;

    public ExtraProcessor(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    @Override
    public Class<? extends Annotation> getTarget() {
        return Extra.class;
    }

    @Override
    public void process(Element element, JCodeModel codeModel, EBeanHolder holder) {
        Extra annotation = element.getAnnotation(Extra.class);
        String extraKey = annotation.value();
        String fieldName = element.getSimpleName().toString();
        if (extraKey.isEmpty()) {
            extraKey = fieldName;
        }
        TypeMirror elementType = element.asType();
        boolean isPrimitive = elementType.getKind().isPrimitive();
        EBeansHolder.Classes classes = holder.classes();
        if (!isPrimitive && holder.cast == null) {
            this.generateCastMethod(codeModel, holder);
        }
        if (holder.extras == null) {
            this.injectExtras(holder, codeModel);
        }
        JBlock ifContainsKey = holder.extrasNotNullBlock._if(JExpr.invoke((JExpression)holder.extras, "containsKey").arg(extraKey))._then();
        JTryBlock containsKeyTry = ifContainsKey._try();
        JFieldRef extraField = JExpr.ref(fieldName);
        if (isPrimitive) {
            JPrimitiveType primitiveType = JType.parse(codeModel, ((Object)elementType).toString());
            JClass wrapperType = primitiveType.boxify();
            containsKeyTry.body().assign(extraField, JExpr.cast(wrapperType, holder.extras.invoke("get").arg(extraKey)));
        } else {
            containsKeyTry.body().assign(extraField, JExpr.invoke(holder.cast).arg(holder.extras.invoke("get").arg(extraKey)));
        }
        JCatchBlock containsKeyCatch = containsKeyTry._catch(classes.CLASS_CAST_EXCEPTION);
        JVar exceptionParam = containsKeyCatch.param("e");
        JInvocation logError = classes.LOG.staticInvoke("e");
        logError.arg(holder.generatedClass.name());
        logError.arg("Could not cast extra to expected type, the field is left to its default value");
        logError.arg(exceptionParam);
        containsKeyCatch.body().add(logError);
        if (holder.intentBuilderClass != null) {
            JMethod method = holder.intentBuilderClass.method(1, holder.intentBuilderClass, fieldName);
            boolean castToSerializable = false;
            TypeMirror extraType = elementType;
            if (extraType.getKind() == TypeKind.DECLARED) {
                TypeMirror stringType;
                TypeMirror parcelableType;
                Elements elementUtils = this.processingEnv.getElementUtils();
                Types typeUtils = this.processingEnv.getTypeUtils();
                if (!typeUtils.isSubtype(extraType, parcelableType = elementUtils.getTypeElement("android.os.Parcelable").asType()) && !typeUtils.isSubtype(extraType, stringType = elementUtils.getTypeElement(CanonicalNameConstants.STRING).asType())) {
                    castToSerializable = true;
                }
            }
            JClass paramClass = this.helper.typeMirrorToJClass(extraType, holder);
            JVar extraParam = method.param(paramClass, fieldName);
            JBlock body = method.body();
            JInvocation invocation = body.invoke((JExpression)holder.intentField, "putExtra").arg(extraKey);
            if (castToSerializable) {
                invocation.arg(JExpr.cast(classes.SERIALIZABLE, extraParam));
            } else {
                invocation.arg(extraParam);
            }
            body._return(JExpr._this());
        }
    }

    private void generateCastMethod(JCodeModel codeModel, EBeanHolder holder) {
        JType objectType = codeModel._ref(Object.class);
        JMethod method = holder.generatedClass.method(4, objectType, "cast_");
        JTypeVar genericType = method.generify("T");
        method.type(genericType);
        JVar objectParam = method.param(objectType, "object");
        method.annotate(SuppressWarnings.class).param("value", "unchecked");
        method.body()._return(JExpr.cast(genericType, objectParam));
        holder.cast = method;
    }

    private void injectExtras(EBeanHolder holder, JCodeModel codeModel) {
        EBeansHolder.Classes classes = holder.classes();
        JMethod injectExtrasMethod = holder.generatedClass.method(4, codeModel.VOID, "injectExtras_");
        this.overrideSetIntent(holder, codeModel, injectExtrasMethod);
        this.injectExtrasOnInit(holder, classes.INTENT, injectExtrasMethod);
        JBlock injectExtrasBody = injectExtrasMethod.body();
        JVar intent = injectExtrasBody.decl(classes.INTENT, "intent_", JExpr.invoke("getIntent"));
        holder.extras = injectExtrasBody.decl(classes.BUNDLE, "extras_");
        holder.extras.init(intent.invoke("getExtras"));
        holder.extrasNotNullBlock = injectExtrasBody._if(holder.extras.ne(JExpr._null()))._then();
    }

    private void overrideSetIntent(EBeanHolder holder, JCodeModel codeModel, JMethod initIntentMethod) {
        if (holder.intentBuilderClass != null) {
            JMethod setIntentMethod = holder.generatedClass.method(1, codeModel.VOID, "setIntent");
            setIntentMethod.annotate(Override.class);
            JVar methodParam = setIntentMethod.param(holder.classes().INTENT, "newIntent");
            JBlock setIntentBody = setIntentMethod.body();
            setIntentBody.invoke(JExpr._super(), setIntentMethod).arg(methodParam);
            setIntentBody.invoke(initIntentMethod);
        }
    }

    private void injectExtrasOnInit(EBeanHolder holder, JClass intentClass, JMethod injectExtrasMethod) {
        holder.init.body().invoke(injectExtrasMethod);
    }
}

