/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.processing;

import com.googlecode.androidannotations.annotations.Bean;
import com.googlecode.androidannotations.annotations.NonConfigurationInstance;
import com.googlecode.androidannotations.helper.APTCodeModelHelper;
import com.googlecode.androidannotations.helper.AnnotationHelper;
import com.googlecode.androidannotations.processing.DecoratingElementProcessor;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.googlecode.androidannotations.processing.NonConfigurationHolder;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import java.lang.annotation.Annotation;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public class NonConfigurationInstanceProcessor
implements DecoratingElementProcessor {
    private APTCodeModelHelper aptCodeModelHelper;
    private AnnotationHelper annotationHelper;

    public NonConfigurationInstanceProcessor(ProcessingEnvironment processingEnv) {
        this.annotationHelper = new AnnotationHelper(processingEnv);
        this.aptCodeModelHelper = new APTCodeModelHelper();
    }

    @Override
    public Class<? extends Annotation> getTarget() {
        return NonConfigurationInstance.class;
    }

    @Override
    public void process(Element element, JCodeModel codeModel, EBeanHolder holder) throws JClassAlreadyExistsException {
        boolean hasBeanAnnotation;
        NonConfigurationHolder ncHolder = holder.nonConfigurationHolder;
        if (ncHolder == null) {
            holder.nonConfigurationHolder = ncHolder = new NonConfigurationHolder();
            ncHolder.holderClass = holder.generatedClass._class(20, "NonConfigurationInstancesHolder");
            JFieldVar superNonConfigurationInstanceField = ncHolder.holderClass.field(9, Object.class, "superNonConfigurationInstance");
            ncHolder.holderConstructor = ncHolder.holderClass.constructor(1);
            JVar superNonConfigurationInstanceParam = ncHolder.holderConstructor.param(Object.class, "superNonConfigurationInstance");
            ncHolder.holderConstructor.body().assign(JExpr._this().ref(superNonConfigurationInstanceField), superNonConfigurationInstanceParam);
            TypeElement fragmentActivityTypeElement = this.annotationHelper.typeElementFromQualifiedName("android.support.v4.app.FragmentActivity");
            TypeElement typeElement = this.annotationHelper.typeElementFromQualifiedName(holder.generatedClass._extends().fullName());
            String getLastNonConfigurationInstanceName = "getLastNonConfigurationInstance";
            String onRetainNonConfigurationInstanceName = "onRetainNonConfigurationInstance";
            if (fragmentActivityTypeElement != null && this.annotationHelper.isSubtype(typeElement.asType(), fragmentActivityTypeElement.asType())) {
                getLastNonConfigurationInstanceName = "getLastCustomNonConfigurationInstance";
                onRetainNonConfigurationInstanceName = "onRetainCustomNonConfigurationInstance";
            }
            JBlock initBody = holder.init.body();
            ncHolder.initNonConfigurationInstance = initBody.decl(ncHolder.holderClass, "nonConfigurationInstance", JExpr.cast(ncHolder.holderClass, JExpr._super().invoke(getLastNonConfigurationInstanceName)));
            ncHolder.initIfNonConfigurationNotNullBody = initBody._if(ncHolder.initNonConfigurationInstance.ne(JExpr._null()))._then();
            JMethod getLastNonConfigurationInstance = holder.generatedClass.method(1, Object.class, getLastNonConfigurationInstanceName);
            getLastNonConfigurationInstance.annotate(Override.class);
            JBlock body = getLastNonConfigurationInstance.body();
            JVar nonConfigurationInstance = body.decl(ncHolder.holderClass, "nonConfigurationInstance", JExpr.cast(ncHolder.holderClass, JExpr._super().invoke(getLastNonConfigurationInstance)));
            body._if(nonConfigurationInstance.eq(JExpr._null()))._then()._return(JExpr._null());
            body._return(nonConfigurationInstance.ref(superNonConfigurationInstanceField));
            JMethod onRetainNonConfigurationInstance = holder.generatedClass.method(1, ncHolder.holderClass, onRetainNonConfigurationInstanceName);
            onRetainNonConfigurationInstance.annotate(Override.class);
            ncHolder.newHolder = JExpr._new(ncHolder.holderClass);
            ncHolder.newHolder.arg(JExpr._super().invoke(onRetainNonConfigurationInstance));
            onRetainNonConfigurationInstance.body()._return(ncHolder.newHolder);
        }
        String fieldName = element.getSimpleName().toString();
        JClass fieldType = this.aptCodeModelHelper.typeMirrorToJClass(element.asType(), holder);
        JFieldVar field = ncHolder.holderClass.field(9, fieldType, fieldName);
        JVar constructorParam = ncHolder.holderConstructor.param(fieldType, fieldName);
        ncHolder.holderConstructor.body().assign(JExpr._this().ref(field), constructorParam);
        ncHolder.newHolder.arg(field);
        ncHolder.initIfNonConfigurationNotNullBody.assign(field, ncHolder.initNonConfigurationInstance.ref(field));
        boolean bl = hasBeanAnnotation = element.getAnnotation(Bean.class) != null;
        if (hasBeanAnnotation) {
            DeclaredType targetAnnotationClassValue = this.annotationHelper.extractAnnotationClassParameter(element, Bean.class);
            TypeMirror elementType = targetAnnotationClassValue != null ? targetAnnotationClassValue : element.asType();
            String typeQualifiedName = ((Object)elementType).toString();
            JClass fieldGeneratedBeanClass = holder.refClass(typeQualifiedName + "_");
            ncHolder.initIfNonConfigurationNotNullBody.invoke((JExpression)JExpr.cast(fieldGeneratedBeanClass, field), "rebind").arg(JExpr._this());
        }
    }
}

