/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.validation;

import com.googlecode.androidannotations.helper.IdAnnotationHelper;
import com.googlecode.androidannotations.helper.IdValidatorHelper;
import com.googlecode.androidannotations.model.AnnotationElements;
import com.googlecode.androidannotations.rclass.IRClass;
import com.googlecode.androidannotations.validation.ElementValidator;
import com.googlecode.androidannotations.validation.IsValid;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;

public abstract class AbstractSeekBarTouchValidator
implements ElementValidator {
    private final IdValidatorHelper validatorHelper;
    private final IdAnnotationHelper annotationHelper;

    public AbstractSeekBarTouchValidator(ProcessingEnvironment processingEnv, IRClass rClass) {
        this.annotationHelper = new IdAnnotationHelper(processingEnv, this.getTarget(), rClass);
        this.validatorHelper = new IdValidatorHelper(this.annotationHelper);
    }

    @Override
    public boolean validate(Element element, AnnotationElements validatedElements) {
        IsValid valid = new IsValid();
        this.validatorHelper.enclosingElementHasEnhancedViewSupportAnnotation(element, validatedElements, valid);
        this.validatorHelper.resIdsExist(element, IRClass.Res.ID, IdValidatorHelper.FallbackStrategy.USE_ELEMENT_NAME, valid);
        this.validatorHelper.isNotPrivate(element, valid);
        this.validatorHelper.doesntThrowException(element, valid);
        ExecutableElement executableElement = (ExecutableElement)element;
        this.validatorHelper.returnTypeIsVoid(executableElement, valid);
        this.hasProgressChangeMethodParameters(executableElement, valid);
        return valid.isValid();
    }

    private void hasProgressChangeMethodParameters(ExecutableElement executableElement, IsValid valid) {
        String parameterType;
        List<? extends VariableElement> parameters = executableElement.getParameters();
        if (parameters.size() > 1) {
            this.annotationHelper.printAnnotationError(executableElement, "Unrecognized parameter declaration. You can only have one parameter of type android.widget.SeekBar. Try declaring " + executableElement.getSimpleName() + "(" + "android.widget.SeekBar" + " seekBar);");
            valid.invalidate();
            return;
        }
        if (parameters.size() == 1 && !(parameterType = ((Object)parameters.get(0).asType()).toString()).equals("android.widget.SeekBar")) {
            this.annotationHelper.printAnnotationError(executableElement, "Unrecognized parameter declaration. You can only have one parameter of type android.widget.SeekBar. Try declaring " + executableElement.getSimpleName() + "(" + "android.widget.SeekBar" + " seekBar);");
            valid.invalidate();
        }
    }
}

