/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.generation;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JPackage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.annotation.processing.Filer;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public class SourceCodewriter
extends CodeWriter {
    private final Filer filer;
    private final Messager message;
    private static final VoidOutputStream VOID_OUTPUT_STREAM = new VoidOutputStream();
    private Map<String, Element> originatingElementsByGeneratedClassQualifiedName;

    public SourceCodewriter(Filer filer, Messager message, Map<String, Element> originatingElementsByGeneratedClassQualifiedName) {
        this.filer = filer;
        this.message = message;
        this.originatingElementsByGeneratedClassQualifiedName = originatingElementsByGeneratedClassQualifiedName;
    }

    @Override
    public OutputStream openBinary(JPackage pkg, String fileName) throws IOException {
        String qualifiedClassName = this.toQualifiedClassName(pkg, fileName);
        this.message.printMessage(Diagnostic.Kind.NOTE, "Generating source file: " + qualifiedClassName);
        Element originatingElement = this.originatingElementsByGeneratedClassQualifiedName.get(qualifiedClassName);
        try {
            JavaFileObject sourceFile;
            if (originatingElement != null) {
                sourceFile = this.filer.createSourceFile(qualifiedClassName, originatingElement);
            } else {
                this.message.printMessage(Diagnostic.Kind.NOTE, "Generating class with no originating element: " + qualifiedClassName);
                sourceFile = this.filer.createSourceFile(qualifiedClassName, new Element[0]);
            }
            return sourceFile.openOutputStream();
        }
        catch (FilerException e) {
            this.message.printMessage(Diagnostic.Kind.NOTE, "Could not generate source file for " + qualifiedClassName + ", message: " + e.getMessage());
            return VOID_OUTPUT_STREAM;
        }
    }

    private String toQualifiedClassName(JPackage pkg, String fileName) {
        int suffixPosition = fileName.lastIndexOf(46);
        String className = fileName.substring(0, suffixPosition);
        String qualifiedClassName = pkg.name() + "." + className;
        return qualifiedClassName;
    }

    @Override
    public void close() throws IOException {
    }

    private static class VoidOutputStream
    extends OutputStream {
        private VoidOutputStream() {
        }

        @Override
        public void write(int arg0) throws IOException {
        }
    }
}

