/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.helper;

import com.googlecode.androidannotations.annotations.OnActivityResult;
import com.googlecode.androidannotations.annotations.OptionsItem;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.googlecode.androidannotations.rclass.IRInnerClass;
import com.googlecode.androidannotations.rclass.RInnerClass;
import com.sun.codemodel.JFieldRef;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public class AnnotationHelper {
    private final ProcessingEnvironment processingEnv;

    public AnnotationHelper(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    public boolean isSubtype(TypeMirror potentialSubtype, TypeMirror potentialSupertype) {
        return this.processingEnv.getTypeUtils().isSubtype(potentialSubtype, potentialSupertype);
    }

    public boolean isSubtype(TypeElement t1, TypeElement t2) {
        return this.isSubtype(t1.asType(), t2.asType());
    }

    public TypeElement typeElementFromQualifiedName(String qualifiedName) {
        return this.processingEnv.getElementUtils().getTypeElement(qualifiedName);
    }

    public AnnotationMirror findAnnotationMirror(Element annotatedElement, Class<? extends Annotation> annotationClass) {
        List<? extends AnnotationMirror> annotationMirrors = annotatedElement.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            TypeElement annotationElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!this.isAnnotation(annotationElement, annotationClass)) continue;
            return annotationMirror;
        }
        return null;
    }

    public boolean isAnnotation(TypeElement annotation, Class<? extends Annotation> annotationClass) {
        return annotation.getQualifiedName().toString().equals(annotationClass.getName());
    }

    public void printAnnotationError(Element annotatedElement, Class<? extends Annotation> annotationClass, String message) {
        this.printAnnotationMessage(Diagnostic.Kind.ERROR, annotatedElement, annotationClass, message);
    }

    public void printAnnotationWarning(Element annotatedElement, Class<? extends Annotation> annotationClass, String message) {
        this.printAnnotationMessage(Diagnostic.Kind.WARNING, annotatedElement, annotationClass, message);
    }

    public void printAnnotationMessage(Diagnostic.Kind diagnosticKind, Element annotatedElement, Class<? extends Annotation> annotationClass, String message) {
        AnnotationMirror annotationMirror = this.findAnnotationMirror(annotatedElement, annotationClass);
        if (annotationMirror != null) {
            this.processingEnv.getMessager().printMessage(diagnosticKind, message, annotatedElement, annotationMirror);
        } else {
            this.printError(annotatedElement, message);
        }
    }

    public void printError(Element element, String message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message, element);
    }

    public boolean isPrivate(Element element) {
        return element.getModifiers().contains((Object)Modifier.PRIVATE);
    }

    public boolean isPublic(Element element) {
        return element.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    public boolean isAbstract(Element element) {
        return element.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    public boolean isInterface(TypeElement element) {
        return element.getKind().isInterface();
    }

    public boolean isTopLevel(TypeElement element) {
        return element.getNestingKind() == NestingKind.TOP_LEVEL;
    }

    public boolean isFinal(Element element) {
        return element.getModifiers().contains((Object)Modifier.FINAL);
    }

    public boolean isSynchronized(Element element) {
        return element.getModifiers().contains((Object)Modifier.SYNCHRONIZED);
    }

    public Elements getElementUtils() {
        return this.processingEnv.getElementUtils();
    }

    public Types getTypeUtils() {
        return this.processingEnv.getTypeUtils();
    }

    public List<JFieldRef> extractAnnotationFieldRefs(EBeanHolder holder, Element element, Class<? extends Annotation> target, IRInnerClass rInnerClass, boolean useElementName) {
        ArrayList<JFieldRef> fieldRefs = new ArrayList<JFieldRef>();
        for (String refQualifiedName : this.extractAnnotationResources(element, target, rInnerClass, useElementName)) {
            fieldRefs.add(RInnerClass.extractIdStaticRef(holder, refQualifiedName));
        }
        return fieldRefs;
    }

    public List<String> extractAnnotationResources(Element element, Class<? extends Annotation> target, IRInnerClass rInnerClass, boolean useElementName) {
        ArrayList<String> resourceIdQualifiedNames;
        block4: {
            int[] values;
            block2: {
                String[] resNames;
                block3: {
                    values = this.extractAnnotationResIdValueParameter(element, target);
                    resourceIdQualifiedNames = new ArrayList<String>();
                    if (!this.defaultResIdValue(values)) break block2;
                    resNames = this.extractAnnotationResNameParameter(element, target);
                    if (!this.defaultResName(resNames)) break block3;
                    if (!useElementName) break block4;
                    String elementName = this.extractElementName(element, target);
                    String clickQualifiedId = rInnerClass.getIdQualifiedName(elementName);
                    resourceIdQualifiedNames.add(clickQualifiedId);
                    break block4;
                }
                for (String resName : resNames) {
                    String resourceIdQualifiedName = rInnerClass.getIdQualifiedName(resName);
                    resourceIdQualifiedNames.add(resourceIdQualifiedName);
                }
                break block4;
            }
            for (int value : values) {
                String resourceIdQualifiedName = rInnerClass.getIdQualifiedName(value);
                resourceIdQualifiedNames.add(resourceIdQualifiedName);
            }
        }
        return resourceIdQualifiedNames;
    }

    public String extractElementName(Element element, Class<? extends Annotation> target) {
        String elementName = element.getSimpleName().toString();
        int lastIndex = elementName.lastIndexOf(this.actionName(target));
        if (lastIndex != -1) {
            elementName = elementName.substring(0, lastIndex);
        }
        return elementName;
    }

    public boolean defaultResName(String[] resNames) {
        return resNames.length == 0 || resNames.length == 1 && "".equals(resNames[0]);
    }

    public boolean defaultResIdValue(int[] values) {
        return values.length == 0 || values.length == 1 && values[0] == -1;
    }

    public String[] extractAnnotationResNameParameter(Element element, Class<? extends Annotation> target) {
        Object annotationResName = this.extractAnnotationParameter(element, target, "resName");
        String[] resNames = annotationResName.getClass().isArray() ? (String[])annotationResName : new String[]{(String)annotationResName};
        return resNames;
    }

    public int[] extractAnnotationResIdValueParameter(Element element, Class<? extends Annotation> target) {
        Object annotationValue = this.extractAnnotationParameter(element, target, "value");
        int[] values = annotationValue.getClass().isArray() ? (int[])annotationValue : new int[]{(Integer)annotationValue};
        return values;
    }

    public <T> T extractAnnotationParameter(Element element, Class<? extends Annotation> target, String methodName) {
        Annotation annotation = element.getAnnotation(target);
        try {
            Method method = annotation.getClass().getMethod(methodName, new Class[0]);
            return (T)method.invoke((Object)annotation, new Object[0]);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof MirroredTypeException) {
                MirroredTypeException cause = (MirroredTypeException)e.getCause();
                return (T)cause.getTypeMirror();
            }
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String actionName(Class<? extends Annotation> target) {
        if (target == OptionsItem.class) {
            return "Selected";
        }
        if (target == OnActivityResult.class) {
            return "Result";
        }
        String annotationSimpleName = target.getSimpleName();
        if (annotationSimpleName.endsWith("e")) {
            return target.getSimpleName() + "d";
        }
        return target.getSimpleName() + "ed";
    }

    public List<DeclaredType> extractAnnotationClassArrayParameter(Element element, Class<? extends Annotation> target, String methodName) {
        AnnotationMirror annotationMirror = this.findAnnotationMirror(element, target);
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
            if (!methodName.equals(entry.getKey().getSimpleName().toString())) continue;
            AnnotationValue annotationValue = entry.getValue();
            List annotationClassArray = (List)annotationValue.getValue();
            ArrayList<DeclaredType> result = new ArrayList<DeclaredType>(annotationClassArray.size());
            for (AnnotationValue annotationClassValue : annotationClassArray) {
                result.add((DeclaredType)annotationClassValue.getValue());
            }
            return result;
        }
        return null;
    }

    public DeclaredType extractAnnotationClassParameter(Element element, Class<? extends Annotation> target, String methodName) {
        AnnotationMirror annotationMirror = this.findAnnotationMirror(element, target);
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
            if (!methodName.equals(entry.getKey().getSimpleName().toString())) continue;
            AnnotationValue annotationValue = entry.getValue();
            DeclaredType annotationClass = (DeclaredType)annotationValue.getValue();
            return annotationClass;
        }
        return null;
    }

    public DeclaredType extractAnnotationClassParameter(Element element, Class<? extends Annotation> target) {
        return this.extractAnnotationClassParameter(element, target, "value");
    }
}

