/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.helper;

import com.googlecode.androidannotations.helper.APTCodeModelHelper;
import com.googlecode.androidannotations.helper.IdAnnotationHelper;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.googlecode.androidannotations.processing.OnSeekBarChangeListenerHolder;
import com.googlecode.androidannotations.rclass.IRClass;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCast;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import java.lang.annotation.Annotation;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.TypeMirror;

public class OnSeekBarChangeListenerHelper
extends IdAnnotationHelper {
    private final APTCodeModelHelper codeModelHelper;

    public OnSeekBarChangeListenerHelper(ProcessingEnvironment processingEnv, Class<? extends Annotation> target, IRClass rClass, APTCodeModelHelper codeModelHelper) {
        super(processingEnv, target, rClass);
        this.codeModelHelper = codeModelHelper;
    }

    public OnSeekBarChangeListenerHolder getOrCreateListener(JCodeModel codeModel, EBeanHolder holder, JFieldRef idRef) {
        String idRefString = this.codeModelHelper.getIdStringFromIdFieldRef(idRef);
        OnSeekBarChangeListenerHolder onSeekBarChangeListenerHolder = holder.onSeekBarChangeListeners.get(idRefString);
        if (onSeekBarChangeListenerHolder == null) {
            JClass seekBarClass = holder.classes().SEEKBAR;
            JDefinedClass onSeekbarChangeListenerClass = codeModel.anonymousClass(holder.classes().ON_SEEKBAR_CHANGE_LISTENER);
            JMethod onStartTrackingTouchMethod = onSeekbarChangeListenerClass.method(1, codeModel.VOID, "onStartTrackingTouch");
            onStartTrackingTouchMethod.param(seekBarClass, "seekBar");
            onStartTrackingTouchMethod.annotate(Override.class);
            JMethod onProgressChangedMethod = onSeekbarChangeListenerClass.method(1, codeModel.VOID, "onProgressChanged");
            onProgressChangedMethod.param(seekBarClass, "seekBar");
            onProgressChangedMethod.param(codeModel.INT, "progress");
            onProgressChangedMethod.param(codeModel.BOOLEAN, "fromUser");
            onProgressChangedMethod.annotate(Override.class);
            JMethod onStopTrackingTouchMethod = onSeekbarChangeListenerClass.method(1, codeModel.VOID, "onStopTrackingTouch");
            onStopTrackingTouchMethod.param(seekBarClass, "seekBar");
            onStopTrackingTouchMethod.annotate(Override.class);
            JBlock block = holder.afterSetContentView.body().block();
            TypeMirror viewParameterType = this.typeElementFromQualifiedName("android.widget.SeekBar").asType();
            String viewParameterTypeString = ((Object)viewParameterType).toString();
            JClass viewClass = holder.refClass(viewParameterTypeString);
            JCast findViewById = JExpr.cast(viewClass, JExpr.invoke("findViewById").arg(idRef));
            JVar viewVariable = block.decl(8, viewClass, "view", findViewById);
            block._if(viewVariable.ne(JExpr._null()))._then().invoke((JExpression)viewVariable, "setOnSeekBarChangeListener").arg(JExpr._new(onSeekbarChangeListenerClass));
            onSeekBarChangeListenerHolder = new OnSeekBarChangeListenerHolder(onStartTrackingTouchMethod, onProgressChangedMethod, onStopTrackingTouchMethod, viewVariable);
            holder.onSeekBarChangeListeners.put(idRefString, onSeekBarChangeListenerHolder);
        }
        return onSeekBarChangeListenerHolder;
    }
}

