/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.processing;

import com.googlecode.androidannotations.annotations.BeforeTextChange;
import com.googlecode.androidannotations.helper.APTCodeModelHelper;
import com.googlecode.androidannotations.helper.TextWatcherHelper;
import com.googlecode.androidannotations.processing.DecoratingElementProcessor;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.googlecode.androidannotations.processing.TextWatcherHolder;
import com.googlecode.androidannotations.rclass.IRClass;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class BeforeTextChangeProcessor
implements DecoratingElementProcessor {
    private final TextWatcherHelper helper;
    private final APTCodeModelHelper codeModelHelper = new APTCodeModelHelper();

    public BeforeTextChangeProcessor(ProcessingEnvironment processingEnv, IRClass rClass) {
        this.helper = new TextWatcherHelper(processingEnv, this.getTarget(), rClass, this.codeModelHelper);
    }

    @Override
    public Class<? extends Annotation> getTarget() {
        return BeforeTextChange.class;
    }

    @Override
    public void process(Element element, JCodeModel codeModel, EBeanHolder holder) {
        String methodName = element.getSimpleName().toString();
        ExecutableElement executableElement = (ExecutableElement)element;
        List<? extends VariableElement> parameters = executableElement.getParameters();
        int startParameterPosition = -1;
        int countParameterPosition = -1;
        int afterParameterPosition = -1;
        int charSequenceParameterPosition = -1;
        int viewParameterPosition = -1;
        TypeMirror viewParameterType = null;
        for (int i = 0; i < parameters.size(); ++i) {
            VariableElement parameter = parameters.get(i);
            String parameterName = parameter.toString();
            TypeMirror parameterType = parameter.asType();
            if ("java.lang.CharSequence".equals(((Object)parameterType).toString())) {
                charSequenceParameterPosition = i;
                continue;
            }
            if (parameterType.getKind() == TypeKind.INT || "java.lang.Integer".equals(((Object)parameterType).toString())) {
                if ("start".equals(parameterName)) {
                    startParameterPosition = i;
                    continue;
                }
                if ("count".equals(parameterName)) {
                    countParameterPosition = i;
                    continue;
                }
                if (!"after".equals(parameterName)) continue;
                afterParameterPosition = i;
                continue;
            }
            TypeMirror textViewType = this.helper.typeElementFromQualifiedName("android.widget.TextView").asType();
            if (!this.helper.isSubtype(parameterType, textViewType)) continue;
            viewParameterPosition = i;
            viewParameterType = parameterType;
        }
        List<JFieldRef> idsRefs = this.helper.extractAnnotationFieldRefs(holder, element, IRClass.Res.ID, true);
        for (JFieldRef idRef : idsRefs) {
            TextWatcherHolder textWatcherHolder = this.helper.getOrCreateListener(codeModel, holder, idRef, viewParameterType);
            JMethod methodToCall = textWatcherHolder.beforeTextChangedMethod;
            JBlock previousBody = this.codeModelHelper.removeBody(methodToCall);
            JBlock methodBody = methodToCall.body();
            methodBody.add(previousBody);
            JFieldRef activityRef = holder.generatedClass.staticRef("this");
            JInvocation textChangeCall = methodBody.invoke((JExpression)activityRef, methodName);
            for (int i = 0; i < parameters.size(); ++i) {
                if (i == startParameterPosition) {
                    JVar startParameter = this.codeModelHelper.findParameterByName(methodToCall, "start");
                    textChangeCall.arg(startParameter);
                    continue;
                }
                if (i == countParameterPosition) {
                    JVar countParameter = this.codeModelHelper.findParameterByName(methodToCall, "count");
                    textChangeCall.arg(countParameter);
                    continue;
                }
                if (i == afterParameterPosition) {
                    JVar afterParameter = this.codeModelHelper.findParameterByName(methodToCall, "after");
                    textChangeCall.arg(afterParameter);
                    continue;
                }
                if (i == charSequenceParameterPosition) {
                    JVar charSequenceParam = this.codeModelHelper.findParameterByName(methodToCall, "s");
                    textChangeCall.arg(charSequenceParam);
                    continue;
                }
                if (i != viewParameterPosition) continue;
                JVar viewParameter = textWatcherHolder.viewVariable;
                textChangeCall.arg(viewParameter);
            }
        }
    }
}

