/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.processing;

import com.googlecode.androidannotations.annotations.FragmentById;
import com.googlecode.androidannotations.helper.IdAnnotationHelper;
import com.googlecode.androidannotations.processing.DecoratingElementProcessor;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.googlecode.androidannotations.processing.EBeansHolder;
import com.googlecode.androidannotations.rclass.IRClass;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import java.lang.annotation.Annotation;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public class FragmentByIdProcessor
implements DecoratingElementProcessor {
    private final IdAnnotationHelper annotationHelper;

    public FragmentByIdProcessor(ProcessingEnvironment processingEnv, IRClass rClass) {
        this.annotationHelper = new IdAnnotationHelper(processingEnv, this.getTarget(), rClass);
    }

    @Override
    public Class<? extends Annotation> getTarget() {
        return FragmentById.class;
    }

    @Override
    public void process(Element element, JCodeModel codeModel, EBeanHolder holder) {
        JBlock body;
        JVar idParam;
        JMethod findFragmentById;
        EBeansHolder.Classes classes = holder.classes();
        String fieldName = element.getSimpleName().toString();
        TypeMirror elementType = element.asType();
        String typeQualifiedName = ((Object)elementType).toString();
        TypeElement nativeFragmentElement = this.annotationHelper.typeElementFromQualifiedName("android.app.Fragment");
        if (nativeFragmentElement != null && this.annotationHelper.isSubtype(elementType, nativeFragmentElement.asType())) {
            findFragmentById = null;
            if (holder.findNativeFragmentById == null) {
                holder.findNativeFragmentById = holder.generatedClass.method(4, classes.FRAGMENT, "findNativeFragmentById");
                idParam = holder.findNativeFragmentById.param(codeModel.INT, "id");
                holder.findNativeFragmentById.javadoc().add("You should check that context is an activity before calling this method");
                body = holder.findNativeFragmentById.body();
                JVar activityVar = body.decl(classes.ACTIVITY, "activity_", JExpr.cast(classes.ACTIVITY, holder.contextRef));
                body._return(activityVar.invoke("getFragmentManager").invoke("findFragmentById").arg(idParam));
            }
            findFragmentById = holder.findNativeFragmentById;
        } else {
            if (holder.findSupportFragmentById == null) {
                holder.findSupportFragmentById = holder.generatedClass.method(4, classes.SUPPORT_V4_FRAGMENT, "findSupportFragmentById");
                idParam = holder.findSupportFragmentById.param(codeModel.INT, "id");
                body = holder.findSupportFragmentById.body();
                body._if(holder.contextRef._instanceof(classes.FRAGMENT_ACTIVITY).not())._then()._return(JExpr._null());
                JVar activityVar = body.decl(classes.FRAGMENT_ACTIVITY, "activity_", JExpr.cast(classes.FRAGMENT_ACTIVITY, holder.contextRef));
                body._return(activityVar.invoke("getSupportFragmentManager").invoke("findFragmentById").arg(idParam));
            }
            findFragmentById = holder.findSupportFragmentById;
        }
        JBlock methodBody = holder.afterSetContentView.body();
        JFieldRef idRef = this.annotationHelper.extractOneAnnotationFieldRef(holder, element, IRClass.Res.ID, true);
        methodBody.assign(JExpr.ref(fieldName), JExpr.cast(holder.refClass(typeQualifiedName), JExpr.invoke(findFragmentById).arg(idRef)));
    }
}

