/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.processing;

import com.googlecode.androidannotations.annotations.sharedpreferences.Pref;
import com.googlecode.androidannotations.annotations.sharedpreferences.SharedPref;
import com.googlecode.androidannotations.model.AnnotationElements;
import com.googlecode.androidannotations.processing.DecoratingElementProcessor;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JFieldRef;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.TypeMirror;

public class PrefProcessor
implements DecoratingElementProcessor {
    private final AnnotationElements validatedModel;

    public PrefProcessor(AnnotationElements validatedModel) {
        this.validatedModel = validatedModel;
    }

    @Override
    public Class<? extends Annotation> getTarget() {
        return Pref.class;
    }

    @Override
    public void process(Element element, JCodeModel codeModel, EBeanHolder holder) {
        String fieldName = element.getSimpleName().toString();
        TypeMirror fieldTypeMirror = element.asType();
        String fieldType = ((Object)fieldTypeMirror).toString();
        if (fieldTypeMirror instanceof ErrorType) {
            String elementTypeName = ((Object)fieldTypeMirror).toString();
            String prefTypeName = elementTypeName.substring(0, elementTypeName.length() - "_".length());
            Set<? extends Element> sharedPrefElements = this.validatedModel.getRootAnnotatedElements(SharedPref.class.getName());
            for (Element element2 : sharedPrefElements) {
                TypeElement sharedPrefTypeElement = (TypeElement)element2;
                String sharedPrefSimpleName = sharedPrefTypeElement.getSimpleName().toString();
                String sharedPrefQualifiedName = sharedPrefTypeElement.getQualifiedName().toString();
                if (!sharedPrefSimpleName.equals(prefTypeName)) continue;
                fieldType = sharedPrefQualifiedName + "_";
                break;
            }
        }
        JBlock methodBody = holder.init.body();
        JFieldRef field = JExpr.ref(fieldName);
        methodBody.assign(field, JExpr._new(holder.refClass(fieldType)).arg(holder.contextRef));
    }
}

