/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.processing;

import com.googlecode.androidannotations.annotations.res.HtmlRes;
import com.googlecode.androidannotations.helper.IdAnnotationHelper;
import com.googlecode.androidannotations.model.AndroidRes;
import com.googlecode.androidannotations.processing.DecoratingElementProcessor;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.googlecode.androidannotations.processing.EBeansHolder;
import com.googlecode.androidannotations.rclass.IRClass;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import java.lang.annotation.Annotation;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;

public class ResProcessor
implements DecoratingElementProcessor {
    private final AndroidRes androidValue;
    private final IdAnnotationHelper annotationHelper;

    public ResProcessor(ProcessingEnvironment processingEnv, AndroidRes androidValue, IRClass rClass) {
        this.androidValue = androidValue;
        this.annotationHelper = new IdAnnotationHelper(processingEnv, this.getTarget(), rClass);
    }

    @Override
    public Class<? extends Annotation> getTarget() {
        return this.androidValue.getTarget();
    }

    @Override
    public void process(Element element, JCodeModel codeModel, EBeanHolder holder) {
        EBeansHolder.Classes classes = holder.classes();
        String fieldName = element.getSimpleName().toString();
        IRClass.Res resInnerClass = this.androidValue.getRInnerClass();
        JFieldRef idRef = this.annotationHelper.extractOneAnnotationFieldRef(holder, element, resInnerClass, true);
        JBlock methodBody = holder.init.body();
        TypeMirror fieldTypeMirror = element.asType();
        String fieldType = ((Object)fieldTypeMirror).toString();
        if ("android.view.animation.Animation".equals(fieldType)) {
            methodBody.assign(JExpr.ref(fieldName), classes.ANIMATION_UTILS.staticInvoke("loadAnimation").arg(holder.contextRef).arg(idRef));
        } else {
            if (holder.resources == null) {
                holder.resources = methodBody.decl(classes.RESOURCES, "resources_", holder.contextRef.invoke("getResources"));
            }
            String resourceMethodName = this.androidValue.getResourceMethodName();
            if (element.getAnnotation(HtmlRes.class) != null) {
                methodBody.assign(JExpr.ref(fieldName), classes.HTML.staticInvoke("fromHtml").arg(JExpr.invoke((JExpression)holder.resources, resourceMethodName).arg(idRef)));
            } else {
                methodBody.assign(JExpr.ref(fieldName), JExpr.invoke((JExpression)holder.resources, resourceMethodName).arg(idRef));
            }
        }
    }
}

