/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.processing;

import com.googlecode.androidannotations.annotations.SeekBarProgressChange;
import com.googlecode.androidannotations.helper.APTCodeModelHelper;
import com.googlecode.androidannotations.helper.CanonicalNameConstants;
import com.googlecode.androidannotations.helper.OnSeekBarChangeListenerHelper;
import com.googlecode.androidannotations.processing.DecoratingElementProcessor;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.googlecode.androidannotations.processing.OnSeekBarChangeListenerHolder;
import com.googlecode.androidannotations.rclass.IRClass;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class SeekBarProgressChangeProcessor
implements DecoratingElementProcessor {
    private final OnSeekBarChangeListenerHelper helper;
    private final APTCodeModelHelper codeModelHelper = new APTCodeModelHelper();

    public SeekBarProgressChangeProcessor(ProcessingEnvironment processingEnv, IRClass rClass) {
        this.helper = new OnSeekBarChangeListenerHelper(processingEnv, this.getTarget(), rClass, this.codeModelHelper);
    }

    @Override
    public Class<? extends Annotation> getTarget() {
        return SeekBarProgressChange.class;
    }

    @Override
    public void process(Element element, JCodeModel codeModel, EBeanHolder holder) {
        String methodName = element.getSimpleName().toString();
        ExecutableElement executableElement = (ExecutableElement)element;
        List<? extends VariableElement> parameters = executableElement.getParameters();
        int seekBarViewParameterPosition = -1;
        int progressParameterPosition = -1;
        int fromUserParameterPosition = -1;
        for (int i = 0; i < parameters.size(); ++i) {
            VariableElement parameter = parameters.get(i);
            TypeMirror parameterType = parameter.asType();
            if ("android.widget.SeekBar".equals(((Object)parameterType).toString())) {
                seekBarViewParameterPosition = i;
                continue;
            }
            if (parameterType.getKind() == TypeKind.INT || CanonicalNameConstants.INTEGER.equals(((Object)parameterType).toString())) {
                progressParameterPosition = i;
                continue;
            }
            if (parameterType.getKind() != TypeKind.BOOLEAN && !CanonicalNameConstants.BOOLEAN.equals(((Object)parameterType).toString())) continue;
            fromUserParameterPosition = i;
        }
        List<JFieldRef> idsRefs = this.helper.extractAnnotationFieldRefs(holder, element, IRClass.Res.ID, true);
        for (JFieldRef idRef : idsRefs) {
            OnSeekBarChangeListenerHolder onSeekBarChangeListenerHolder = this.helper.getOrCreateListener(codeModel, holder, idRef);
            JMethod methodToCall = onSeekBarChangeListenerHolder.onProgressChangedMethod;
            JBlock previousBody = this.codeModelHelper.removeBody(methodToCall);
            JBlock methodBody = methodToCall.body();
            methodBody.add(previousBody);
            JFieldRef activityRef = holder.generatedClass.staticRef("this");
            JInvocation textChangeCall = methodBody.invoke((JExpression)activityRef, methodName);
            for (int i = 0; i < parameters.size(); ++i) {
                if (i == seekBarViewParameterPosition) {
                    JVar seekBarViewParameter = this.codeModelHelper.findParameterByName(methodToCall, "seekBar");
                    textChangeCall.arg(seekBarViewParameter);
                    continue;
                }
                if (i == progressParameterPosition) {
                    JVar progressParameter = this.codeModelHelper.findParameterByName(methodToCall, "progress");
                    textChangeCall.arg(progressParameter);
                    continue;
                }
                if (i != fromUserParameterPosition) continue;
                JVar fromUserParameter = this.codeModelHelper.findParameterByName(methodToCall, "fromUser");
                textChangeCall.arg(fromUserParameter);
            }
        }
    }
}

