/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.validation;

import com.googlecode.androidannotations.annotations.OnActivityResult;
import com.googlecode.androidannotations.helper.CanonicalNameConstants;
import com.googlecode.androidannotations.helper.IdAnnotationHelper;
import com.googlecode.androidannotations.helper.IdValidatorHelper;
import com.googlecode.androidannotations.model.AnnotationElements;
import com.googlecode.androidannotations.rclass.IRClass;
import com.googlecode.androidannotations.validation.ElementValidator;
import com.googlecode.androidannotations.validation.IsValid;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class OnActivityResultValidator
implements ElementValidator {
    private final IdValidatorHelper validatorHelper;
    private final IdAnnotationHelper annotationHelper;

    public OnActivityResultValidator(ProcessingEnvironment processingEnv, IRClass rClass) {
        this.annotationHelper = new IdAnnotationHelper(processingEnv, this.getTarget(), rClass);
        this.validatorHelper = new IdValidatorHelper(this.annotationHelper);
    }

    @Override
    public Class<? extends Annotation> getTarget() {
        return OnActivityResult.class;
    }

    @Override
    public boolean validate(Element element, AnnotationElements validatedElements) {
        IsValid valid = new IsValid();
        this.validatorHelper.enclosingElementHasEActivity(element, validatedElements, valid);
        this.validatorHelper.isNotPrivate(element, valid);
        this.validatorHelper.doesntThrowException(element, valid);
        OnActivityResult onResultAnnotation = element.getAnnotation(OnActivityResult.class);
        this.validatorHelper.annotationValuePositiveAndInAShort(element, valid, onResultAnnotation.value());
        ExecutableElement executableElement = (ExecutableElement)element;
        this.validatorHelper.returnTypeIsVoid(executableElement, valid);
        this.hasOnResultMethodParameters(executableElement, valid);
        return valid.isValid();
    }

    private void hasOnResultMethodParameters(ExecutableElement executableElement, IsValid valid) {
        List<? extends VariableElement> parameters = executableElement.getParameters();
        boolean resultCodeParameterFound = false;
        boolean intentParameterFound = false;
        for (VariableElement variableElement : parameters) {
            TypeMirror parameterType = variableElement.asType();
            if (((Object)parameterType).toString().equals(CanonicalNameConstants.INTEGER) || parameterType.getKind().equals((Object)TypeKind.INT)) {
                if (resultCodeParameterFound) {
                    this.annotationHelper.printAnnotationError(executableElement, "Unrecognized parameter declaration. you can declare only one parameter of type int or java.lang.Integer");
                    valid.invalidate();
                }
                resultCodeParameterFound = true;
                continue;
            }
            if (((Object)parameterType).toString().equals("android.content.Intent")) {
                if (intentParameterFound) {
                    this.annotationHelper.printAnnotationError(executableElement, "Unrecognized parameter declaration. you can declare only one parameter of type android.content.Intent");
                    valid.invalidate();
                }
                intentParameterFound = true;
                continue;
            }
            valid.invalidate();
            this.annotationHelper.printAnnotationError(executableElement, "Unrecognized parameter type. %s can only have a android.content.Intent parameter and/or an Integer parameter");
        }
    }
}

