/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.validation;

import com.googlecode.androidannotations.helper.IdAnnotationHelper;
import com.googlecode.androidannotations.helper.IdValidatorHelper;
import com.googlecode.androidannotations.model.AndroidRes;
import com.googlecode.androidannotations.model.AnnotationElements;
import com.googlecode.androidannotations.rclass.IRClass;
import com.googlecode.androidannotations.validation.ElementValidator;
import com.googlecode.androidannotations.validation.IsValid;
import java.lang.annotation.Annotation;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;

public class ResValidator
implements ElementValidator {
    private final AndroidRes androidValue;
    private IdValidatorHelper validatorHelper;

    public ResValidator(AndroidRes androidValue, ProcessingEnvironment processingEnv, IRClass rClass) {
        this.androidValue = androidValue;
        IdAnnotationHelper annotationHelper = new IdAnnotationHelper(processingEnv, this.getTarget(), rClass);
        this.validatorHelper = new IdValidatorHelper(annotationHelper);
    }

    @Override
    public Class<? extends Annotation> getTarget() {
        return this.androidValue.getTarget();
    }

    @Override
    public boolean validate(Element element, AnnotationElements validatedElements) {
        IsValid valid = new IsValid();
        this.validatorHelper.enclosingElementHasEnhancedComponentAnnotation(element, validatedElements, valid);
        TypeMirror fieldTypeMirror = element.asType();
        this.validatorHelper.allowedType(element, valid, fieldTypeMirror, this.androidValue.getAllowedTypes());
        this.validatorHelper.resIdsExist(element, this.androidValue.getRInnerClass(), IdValidatorHelper.FallbackStrategy.USE_ELEMENT_NAME, valid);
        this.validatorHelper.isNotPrivate(element, valid);
        return valid.isValid();
    }
}

