/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.validation;

import com.googlecode.androidannotations.annotations.sharedpreferences.SharedPref;
import com.googlecode.androidannotations.helper.TargetAnnotationHelper;
import com.googlecode.androidannotations.helper.ValidatorHelper;
import com.googlecode.androidannotations.model.AnnotationElements;
import com.googlecode.androidannotations.validation.ElementValidator;
import com.googlecode.androidannotations.validation.IsValid;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

public class SharedPrefValidator
implements ElementValidator {
    private final ValidatorHelper validatorHelper;
    private final Elements elements;

    public SharedPrefValidator(ProcessingEnvironment processingEnv) {
        this.elements = processingEnv.getElementUtils();
        TargetAnnotationHelper annotationHelper = new TargetAnnotationHelper(processingEnv, this.getTarget());
        this.validatorHelper = new ValidatorHelper(annotationHelper);
    }

    @Override
    public Class<? extends Annotation> getTarget() {
        return SharedPref.class;
    }

    @Override
    public boolean validate(Element element, AnnotationElements validatedElements) {
        IsValid valid = new IsValid();
        TypeElement typeElement = (TypeElement)element;
        this.validatorHelper.isInterface(typeElement, valid);
        List<? extends Element> inheritedMembers = this.elements.getAllMembers(typeElement);
        for (Element element2 : inheritedMembers) {
            if (((Object)element2.getEnclosingElement().asType()).toString().equals("java.lang.Object")) continue;
            boolean isPrefMethod = this.validatorHelper.isPrefMethod(element2);
            if (isPrefMethod) {
                this.validatorHelper.hasCorrectDefaultAnnotation((ExecutableElement)element2);
                continue;
            }
            valid.invalidate();
        }
        return valid.isValid();
    }
}

